/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.IExperimentHeader;

public class ExperimentClusterHeader
extends JPanel
implements IExperimentHeader {
    private static final int RECT_HEIGHT = 15;
    private static final int COLOR_BAR_HEIGHT = 15;
    private Experiment experiment;
    private IData data;
    private int[][] samplesOrder;
    private ArrayList<Color> storedGeneColors;
    private ArrayList<Color> storedSampleColors = new ArrayList();
    private ArrayList<Color> savedSampleColorOrder = new ArrayList();
    private int compactedColorBarHeight = 0;
    private int elementWidth;
    private boolean isAntiAliasing = true;
    private boolean isCompact = false;
    public boolean isShowRects = true;
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    int clusterIndex = 0;
    private String centroidName;
    private boolean hasCentroid;
    private int activeCluster = 0;
    private static int[] ColorOverlaps = new int[1000000];
    private boolean mouseOnMap = false;
    private int mouseRow = 0;
    private int mouseColumn = 0;
    private int clickedRow = 0;
    private int clickedColumn = 0;
    public boolean clickedCell = false;
    private int maxSampleLabelLength = 0;
    private int oldLabelLength = 0;
    public boolean clusterViewerClicked = false;
    public int clusterViewerClickedColumn = 0;
    private boolean isDrag = false;
    private boolean headerDrag = false;
    private int headerDragColumn = 0;
    private int headerDragRow = 0;
    private int dragColumn = 0;
    private int dragRow = 0;
    private int startColumn = 0;
    private int startRow = 0;
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean useDoubleGradient = true;
    private String userFont = "monospaced";
    private int userFontSize;

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"experiment", "samplesOrder"};
    }

    public String getCentroidName() {
        return this.centroidName;
    }

    public int[][] getSamplesOrder() {
        return this.samplesOrder;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    public boolean getHasCentroid() {
        return this.hasCentroid;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
    }

    public ExperimentClusterHeader(int[][] samplesOrder, String centroidName, int elementWidth, boolean hasCentroid, Insets insets) {
        this(null, samplesOrder, centroidName);
        this.elementWidth = elementWidth;
        this.hasCentroid = hasCentroid;
        this.insets = insets;
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterHeader(Experiment experiment, int[] samplesOrder) {
        this.experiment = experiment;
        this.samplesOrder = new int[1][];
        this.samplesOrder[0] = samplesOrder;
        this.hasCentroid = false;
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] samplesOrder) {
        this.experiment = experiment;
        this.samplesOrder = samplesOrder;
        this.hasCentroid = false;
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] samplesOrder, ArrayList storedGeneColors) {
        this.experiment = experiment;
        this.samplesOrder = samplesOrder;
        this.hasCentroid = false;
        this.storedGeneColors = storedGeneColors;
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] samplesOrder, String centroidName) {
        this.experiment = experiment;
        this.samplesOrder = samplesOrder;
        this.centroidName = centroidName;
        this.hasCentroid = true;
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public ExperimentClusterHeader(Experiment experiment, int[][] samplesOrder, String centroidName, ArrayList<Color> strdGeneColors) {
        this.experiment = experiment;
        this.samplesOrder = samplesOrder;
        this.centroidName = centroidName;
        this.hasCentroid = true;
        this.storedGeneColors = strdGeneColors;
        this.setBackground(Color.white);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    public void setStoredColors(ArrayList<Color> storedColors) {
        this.storedGeneColors = storedColors;
    }

    @Override
    public void setData(IData data) {
        this.data = data;
    }

    @Override
    public void setClusterIndex(int index) {
        this.clusterIndex = index;
    }

    @Override
    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.midValue = midValue;
    }

    @Override
    public void setValues(float minValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public void setDrag(boolean setting, int dragColumn, int dragRow) {
        this.isDrag = setting;
        this.dragColumn = dragColumn;
        this.dragRow = dragRow;
    }

    public void clearStoredSampleColors() {
        this.storedSampleColors.clear();
    }

    public void setCompactClusters(boolean value) {
        if (value == this.isCompact) {
            return;
        }
        if (value) {
            this.savedSampleColorOrder.clear();
            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                this.savedSampleColorOrder.add(this.storedSampleColors.get(i));
            }
            this.storedSampleColors.clear();
        } else {
            this.storedSampleColors.clear();
            this.clearColorOverlaps();
            for (int i = 0; i < this.savedSampleColorOrder.size(); ++i) {
                this.storedSampleColors.add(this.savedSampleColorOrder.get(i));
            }
        }
        this.isCompact = value;
    }

    private void clearColorOverlaps() {
        for (int i = 0; i < ColorOverlaps.length; ++i) {
            ExperimentClusterHeader.ColorOverlaps[i] = i;
        }
    }

    public void drawClusterHeaderRectsAt(int column, Color color) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(color);
        int centroidOffset = 0;
        if (this.hasCentroid) {
            centroidOffset = this.elementWidth + 5;
        }
        if (!this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + centroidOffset, this.getSize().height - 15 * this.storedSampleColors.size() - 2, this.elementWidth - 1, 15 * this.storedSampleColors.size());
        }
        if (this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + centroidOffset, this.getSize().height - 15 * this.compactedColorBarHeight - 2, this.elementWidth - 1, 15 * this.compactedColorBarHeight);
        }
    }

    public void drawClusterHeaderRectsAt(int column, Color color, boolean cluster) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        int side = 0;
        int inset = 0;
        if (cluster) {
            inset = 4;
        }
        g.setColor(color);
        int centroidOffset = 0;
        if (this.hasCentroid) {
            centroidOffset = this.elementWidth + 5;
        }
        if (column > this.samplesOrder[this.clusterIndex].length - 1) {
            side = 10;
        }
        if (column > this.experiment.getNumberOfSamples() - 1 && this.isCompact) {
            return;
        }
        if (!this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + centroidOffset + inset, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + side);
        }
        if (this.isCompact) {
            g.drawRect(column * this.elementWidth + this.insets.left + centroidOffset + inset, this.getSize().height - (15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 7), this.elementWidth - 1, 15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 4 + side);
        }
    }

    @Override
    public void setNegAndPosColorImages(BufferedImage neg, BufferedImage pos) {
        this.negColorImage = neg;
        this.posColorImage = pos;
    }

    @Override
    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    private void setElementWidth(int width) {
        this.elementWidth = width;
        if (this.userFontSize == 0) {
            if (width > 16) {
                width = 16;
            }
        } else if (this.userFontSize != -1) {
            width = this.userFontSize;
        }
        this.setFont(new Font(this.userFont, 0, width));
    }

    @Override
    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
    }

    public void fixHeaderWidth(int minSize) {
        if (this.getSize().width < minSize) {
            this.setSize(minSize, this.getSize().height);
        }
    }

    @Override
    public void updateSizes(int contentWidth, int elementWidth) {
        this.setElementWidth(elementWidth);
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        contentWidth = (this.experiment.getNumberOfSamples() + this.storedGeneColors.size()) * elementWidth + this.insets.left + 4;
        int size = this.samplesOrder[this.clusterIndex].length;
        for (int feature = 0; feature < size; ++feature) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][feature]));
            maxHeight = Math.max(maxHeight, hfm.stringWidth(name));
        }
        this.maxSampleLabelLength = maxHeight;
        if (this.hasCentroid) {
            maxHeight = Math.max(maxHeight, hfm.stringWidth(this.centroidName));
        }
        maxHeight += 15 + hfm.getHeight() + 10;
        if (!this.isCompact) {
            maxHeight += this.getColorBarHeight() * this.storedSampleColors.size();
            int labelLength = 0;
            for (int feature = 0; feature < this.storedSampleColors.size(); ++feature) {
                String sampleLabel = this.data.getClusterLabel(feature, false);
                if (sampleLabel == null) continue;
                labelLength = Math.max(labelLength, hfm.stringWidth(sampleLabel));
            }
            if (labelLength < 60) {
                labelLength = 60;
            }
            contentWidth = contentWidth + labelLength + 10;
            this.oldLabelLength = labelLength;
        }
        if (this.isCompact) {
            int maxSpacesOver = -1;
            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                if (ColorOverlaps[i] <= maxSpacesOver) continue;
                maxSpacesOver = ColorOverlaps[i];
            }
            this.compactedColorBarHeight = maxSpacesOver + 1;
            this.setSize(this.getWidth(), maxHeight += this.getColorBarHeight() * (maxSpacesOver + 1));
            this.setPreferredSize(new Dimension(this.getWidth(), maxHeight));
            return;
        }
        if (!this.hasCentroid) {
            this.setSize(contentWidth, maxHeight);
            this.setPreferredSize(new Dimension(contentWidth, maxHeight));
        } else {
            this.setSize(contentWidth, maxHeight);
            this.setPreferredSize(new Dimension(contentWidth, maxHeight));
        }
        this.drawHeader(g);
    }

    private int getColorBarHeight() {
        for (int sample = 0; sample < this.samplesOrder[this.clusterIndex].length; ++sample) {
            if (this.data.getExperimentColor(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][sample])) == null) continue;
            return 15;
        }
        return 0;
    }

    public void setClusters(int[][] mat) {
        this.samplesOrder = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.samplesOrder[i][j] = mat[i][j];
            }
        }
        this.repaint();
        this.updateUI();
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.data == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(g);
    }

    private void drawHeader(Graphics2D g) {
        String clusterName;
        int index;
        int cluster;
        int numberOfClusters;
        int samples = this.samplesOrder[this.clusterIndex].length;
        if (samples == 0) {
            return;
        }
        int width = samples * this.elementWidth;
        if (this.hasCentroid) {
            width += this.elementWidth + 5;
        }
        if (this.useDoubleGradient) {
            g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
            g.drawImage(this.posColorImage, (int)((float)width / 2.0f + (float)this.insets.left), 0, (int)((float)width / 2.0f), 15, null);
        } else {
            g.drawImage(this.posColorImage, this.insets.left, 0, width, 15, null);
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.black);
        g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
        int textWidth = hfm.stringWidth(String.valueOf(this.midValue));
        if (this.useDoubleGradient) {
            g.drawString(String.valueOf(this.midValue), (int)((float)(width + this.insets.left) / 2.0f) - textWidth / 2, 15 + fHeight);
        }
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        g.rotate(-1.5707963267948966);
        int h = -this.getSize().height + 5;
        boolean hasColorBar = false;
        if (this.getColorBarHeight() > 0) {
            if (this.isCompact) {
                h += 15 * this.compactedColorBarHeight;
            }
            if (!this.isCompact) {
                h += 15 * this.storedSampleColors.size();
            }
            hasColorBar = true;
        }
        int centroidNameOffset = 0;
        if (this.hasCentroid) {
            centroidNameOffset = this.elementWidth + 5;
            g.drawString(this.centroidName, h, descent + this.elementWidth / 2 + this.insets.left);
        }
        for (int sample = 0; sample < samples; ++sample) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][sample]));
            g.drawString(name, h, descent + this.elementWidth * sample + this.elementWidth / 2 + this.insets.left + centroidNameOffset);
        }
        g.rotate(1.5707963267948966);
        int visibleClusters = 0;
        if (!this.isCompact) {
            g.rotate(-1.5707963267948966);
            numberOfClusters = this.storedGeneColors.size();
            for (cluster = 0; cluster < numberOfClusters; ++cluster) {
                index = this.data.getVisibleCluster(this.storedGeneColors.get(cluster), true);
                clusterName = this.data.getClusterLabel(index, true);
                if (clusterName != null) {
                    g.drawString(clusterName, h, descent + this.elementWidth * (samples + cluster) + this.elementWidth / 2 + this.insets.left + 5 + centroidNameOffset);
                }
                ++visibleClusters;
            }
            g.rotate(1.5707963267948966);
        }
        if (this.storedSampleColors != null && !this.isCompact) {
            numberOfClusters = this.storedSampleColors.size();
            for (cluster = 0; cluster < numberOfClusters; ++cluster) {
                index = this.data.getVisibleCluster(this.storedSampleColors.get(cluster), false);
                clusterName = this.data.getClusterLabel(index, false);
                if (clusterName == null) continue;
                g.drawString(clusterName, this.elementWidth * (samples + visibleClusters) + this.insets.left + 10 + centroidNameOffset, -h + 15 * (numberOfClusters - cluster));
            }
        }
        int spacesOver = 0;
        if (hasColorBar) {
            int sscLength = this.storedSampleColors.size();
            for (int sample = 0; sample < samples; ++sample) {
                Color[] colors = this.data.getSampleColorArray(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][sample]));
                if (colors == null) continue;
                for (int clusters = 0; clusters < colors.length; ++clusters) {
                    if (colors[clusters] == null) continue;
                    if (this.storedSampleColors.contains(colors[clusters])) {
                        this.activeCluster = this.storedSampleColors.indexOf(colors[clusters]);
                    } else {
                        this.storedSampleColors.add(colors[clusters]);
                        ExperimentClusterHeader.ColorOverlaps[this.activeCluster] = this.activeCluster = this.storedSampleColors.size() - 1;
                        boolean compact = false;
                        if (this.isCompact) {
                            compact = true;
                        }
                        while (compact) {
                            for (int i = 0; i < this.storedSampleColors.size(); ++i) {
                                boolean allClear = true;
                                for (int j = 0; j < this.storedSampleColors.size(); ++j) {
                                    if (ColorOverlaps[j] != i) continue;
                                    if (this.data.isColorOverlap(this.experiment.getSampleIndex(this.samplesOrder[this.clusterIndex][sample]), colors[clusters], this.storedSampleColors.get(j), false)) {
                                        allClear = false;
                                        break;
                                    }
                                    allClear = true;
                                }
                                if (!allClear) continue;
                                ExperimentClusterHeader.ColorOverlaps[this.activeCluster] = i;
                                compact = true;
                                break;
                            }
                            if (!compact) continue;
                        }
                    }
                    spacesOver = ColorOverlaps[this.activeCluster];
                    g.setColor(colors[clusters]);
                    if (sscLength != this.storedSampleColors.size()) {
                        g.setColor(Color.white);
                    }
                    g.fillRect(sample * this.elementWidth + this.insets.left + centroidNameOffset, this.getSize().height - 15 * (1 + spacesOver) - 2, this.elementWidth, 15);
                }
            }
            int sizeTest = this.getSize().width;
            if (sscLength != this.storedSampleColors.size()) {
                this.updateSizes(this.getSize().width, this.elementWidth);
            }
            if (sizeTest != this.getSize().width) {
                this.repaint();
            }
        }
        if (this.mouseOnMap && this.isShowRects) {
            if (this.mouseColumn != this.clickedColumn) {
                this.drawClusterHeaderRectsAt(this.mouseColumn, Color.gray, false);
            }
            if (this.mouseRow != this.clickedRow) {
                this.drawHorizontalRect(this.mouseRow, Color.gray);
            }
        }
        this.mouseOnMap = false;
        if (this.clickedCell) {
            g.setColor(Color.red);
            int centroidOffset = 0;
            if (this.hasCentroid) {
                centroidOffset = this.elementWidth + 5;
            }
            if (!this.isCompact) {
                g.drawRect(centroidOffset + this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - this.clickedRow) - 3, this.elementWidth * this.experiment.getNumberOfSamples() + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.oldLabelLength + 2, 15);
                g.drawRect(centroidOffset + this.clickedColumn * this.elementWidth + this.insets.left, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4);
            }
        }
        if (this.clusterViewerClicked && !this.isCompact) {
            g.setColor(Color.red);
            g.drawRect(this.clusterViewerClickedColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
        }
        if (this.isDrag) {
            g.setColor(Color.blue);
            if (!this.isCompact) {
                g.drawRect(this.dragColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 7), this.elementWidth, 15 * this.storedSampleColors.size() + this.maxSampleLabelLength + 4 + 10);
            }
            if (this.isCompact) {
                g.drawRect(this.dragColumn * this.elementWidth + this.insets.left + 4, this.getSize().height - (15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 7), this.elementWidth - 1, 15 * this.compactedColorBarHeight + this.maxSampleLabelLength + 4 + 10);
            }
        }
        if (this.headerDrag) {
            g.setColor(Color.blue);
            if (!this.isCompact) {
                g.drawRect(this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - this.headerDragRow) - 3, this.elementWidth * this.samplesOrder[this.clusterIndex].length + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.oldLabelLength + 2, 15);
            }
            if (this.isCompact) {
                g.drawRect(this.insets.left, this.getHeight() - 15 * (this.compactedColorBarHeight - this.headerDragRow) - 3, this.elementWidth * this.samplesOrder[this.clusterIndex].length, 15);
            }
        }
    }

    private void drawHorizontalRect(int row, Color color) {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        int centroidOffset = 0;
        if (this.hasCentroid) {
            centroidOffset = this.elementWidth + 5;
        }
        g.setColor(color);
        if (!this.isCompact) {
            g.drawRect(centroidOffset + this.insets.left, this.getHeight() - 15 * (this.storedSampleColors.size() - row) - 3, this.elementWidth * this.samplesOrder[this.clusterIndex].length + 5 + this.elementWidth * this.storedGeneColors.size() + 5 + this.oldLabelLength + 2, 15);
        }
    }

    private int findColumn(int targetx) {
        int xSize = this.samplesOrder[this.clusterIndex].length * this.elementWidth;
        if (this.hasCentroid) {
            if (targetx >= (xSize += this.elementWidth + 5) + this.insets.left || targetx < this.insets.left + this.elementWidth + 5) {
                return -1;
            }
            return (targetx - this.insets.left - this.elementWidth - 5) / this.elementWidth;
        }
        if (targetx < this.insets.left) {
            return -1;
        }
        if (targetx > xSize + this.insets.left) {
            return -1;
        }
        return (targetx - this.insets.left) / this.elementWidth;
    }

    private int findRow(int targety) {
        int length = 0;
        if (!this.isCompact) {
            length = this.getSize().height - this.getColorBarHeight() * this.storedSampleColors.size();
        }
        if (this.isCompact) {
            length = this.getSize().height - this.compactedColorBarHeight * this.getColorBarHeight();
        }
        if (targety >= this.getSize().height || targety < length) {
            return -1;
        }
        return (targety - length) / 15;
    }

    private boolean isLegalPosition(int row, int column) {
        return this.isLegalRow(row) && this.isLegalColumn(column);
    }

    private boolean isLegalColumn(int column) {
        return column >= 0 && column <= this.experiment.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int row) {
        if (row < 0 || row > this.storedSampleColors.size()) {
            return false;
        }
        return !this.isCompact || row >= 0 && row <= this.compactedColorBarHeight;
    }

    public void setUserFont(String userFont) {
        this.userFont = userFont;
    }

    public void setUserFontSize(int userFontSize) {
        this.userFontSize = userFontSize;
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private int oldRow = -1;
        private int oldColumn = -1;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = ExperimentClusterHeader.this.findColumn(event.getX());
            int row = ExperimentClusterHeader.this.findRow(event.getY());
            if (!ExperimentClusterHeader.this.isLegalPosition(row, column)) {
                return;
            }
            if (row == ExperimentClusterHeader.this.clickedRow && column == ExperimentClusterHeader.this.clickedColumn) {
                ExperimentClusterHeader.this.clickedCell = false;
                return;
            }
            ExperimentClusterHeader.this.clickedRow = row;
            ExperimentClusterHeader.this.clickedColumn = column;
            ExperimentClusterHeader.this.clickedCell = true;
            ExperimentClusterHeader.this.drawClusterHeaderRectsAt(ExperimentClusterHeader.this.clickedColumn, Color.red, false);
            ExperimentClusterHeader.this.drawHorizontalRect(ExperimentClusterHeader.this.clickedRow, Color.red);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ExperimentClusterHeader.this.mouseOnMap = false;
            ExperimentClusterHeader.this.repaint();
            if (ExperimentClusterHeader.this.clickedCell && !ExperimentClusterHeader.this.isCompact) {
                ExperimentClusterHeader.this.drawClusterHeaderRectsAt(ExperimentClusterHeader.this.clickedColumn, Color.red, false);
                ExperimentClusterHeader.this.drawHorizontalRect(ExperimentClusterHeader.this.clickedRow, Color.red);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!ExperimentClusterHeader.this.isShowRects) {
                return;
            }
            if (ExperimentClusterHeader.this.experiment.getNumberOfSamples() == 0 || event.isShiftDown()) {
                return;
            }
            int column = ExperimentClusterHeader.this.findColumn(event.getX());
            int row = ExperimentClusterHeader.this.findRow(event.getY());
            Graphics g = null;
            g = ExperimentClusterHeader.this.getGraphics();
            if (!ExperimentClusterHeader.this.isLegalPosition(row, column)) {
                ExperimentClusterHeader.this.repaint();
                if (ExperimentClusterHeader.this.clickedCell && !ExperimentClusterHeader.this.isCompact) {
                    ExperimentClusterHeader.this.drawClusterHeaderRectsAt(ExperimentClusterHeader.this.clickedColumn, Color.red, false);
                    ExperimentClusterHeader.this.drawHorizontalRect(ExperimentClusterHeader.this.clickedRow, Color.red);
                }
                return;
            }
            if (this.isCurrentPosition(row, column)) {
                if (ExperimentClusterHeader.this.isLegalPosition(row, column)) {
                    ExperimentClusterHeader.this.drawClusterHeaderRectsAt(this.oldColumn, Color.gray, false);
                    ExperimentClusterHeader.this.drawHorizontalRect(row, Color.gray);
                }
                if (ExperimentClusterHeader.this.clickedCell && !ExperimentClusterHeader.this.isCompact) {
                    ExperimentClusterHeader.this.drawClusterHeaderRectsAt(ExperimentClusterHeader.this.clickedColumn, Color.red, false);
                    ExperimentClusterHeader.this.drawHorizontalRect(ExperimentClusterHeader.this.clickedRow, Color.red);
                }
                return;
            }
            if (!this.isCurrentPosition(row, column) && ExperimentClusterHeader.this.isLegalPosition(row, column)) {
                ExperimentClusterHeader.this.mouseOnMap = true;
                ExperimentClusterHeader.this.mouseRow = row;
                ExperimentClusterHeader.this.mouseColumn = column;
                ExperimentClusterHeader.this.repaint();
                ExperimentClusterHeader.this.drawClusterHeaderRectsAt(this.oldColumn, Color.gray, false);
                if (ExperimentClusterHeader.this.clickedCell && !ExperimentClusterHeader.this.isCompact) {
                    ExperimentClusterHeader.this.drawClusterHeaderRectsAt(ExperimentClusterHeader.this.clickedColumn, Color.red, false);
                    ExperimentClusterHeader.this.drawHorizontalRect(ExperimentClusterHeader.this.clickedRow, Color.red);
                }
            }
            this.setOldPosition(row, column);
            if (g != null) {
                g.dispose();
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            ExperimentClusterHeader.this.repaint();
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            int column = ExperimentClusterHeader.this.findColumn(event.getX());
            int row = ExperimentClusterHeader.this.findRow(event.getY());
            if (!ExperimentClusterHeader.this.isLegalPosition(row, column)) {
                ExperimentClusterHeader.this.headerDrag = false;
                return;
            }
            if (!ExperimentClusterHeader.this.headerDrag) {
                return;
            }
            ExperimentClusterHeader.this.headerDragColumn = column;
            ExperimentClusterHeader.this.headerDragRow = row;
            if (column >= ExperimentClusterHeader.this.experiment.getNumberOfSamples()) {
                ExperimentClusterHeader.this.headerDrag = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            ExperimentClusterHeader.this.startColumn = ExperimentClusterHeader.this.findColumn(event.getX());
            ExperimentClusterHeader.this.startRow = ExperimentClusterHeader.this.findRow(event.getY());
            if (!ExperimentClusterHeader.this.isLegalPosition(ExperimentClusterHeader.this.startRow, ExperimentClusterHeader.this.startColumn)) {
                return;
            }
            ExperimentClusterHeader.this.headerDrag = true;
            ExperimentClusterHeader.this.headerDragColumn = ExperimentClusterHeader.this.startColumn;
            ExperimentClusterHeader.this.headerDragRow = ExperimentClusterHeader.this.startRow;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!ExperimentClusterHeader.this.headerDrag) {
                return;
            }
            ExperimentClusterHeader.this.headerDrag = false;
            int endRow = ExperimentClusterHeader.this.findRow(event.getY());
            if (!ExperimentClusterHeader.this.isLegalPosition(ExperimentClusterHeader.this.startRow, ExperimentClusterHeader.this.startColumn)) {
                return;
            }
            if (!ExperimentClusterHeader.this.isCompact) {
                Color inter = (Color)ExperimentClusterHeader.this.storedSampleColors.get(ExperimentClusterHeader.this.storedSampleColors.size() - 1 - ExperimentClusterHeader.this.startRow);
                ExperimentClusterHeader.this.storedSampleColors.remove(ExperimentClusterHeader.this.storedSampleColors.size() - 1 - ExperimentClusterHeader.this.startRow);
                ExperimentClusterHeader.this.storedSampleColors.add(ExperimentClusterHeader.this.storedSampleColors.size() - endRow, inter);
                ExperimentClusterHeader.this.repaint();
            } else {
                for (int j = 0; j < ExperimentClusterHeader.this.storedSampleColors.size(); ++j) {
                    if (ColorOverlaps[j] == ExperimentClusterHeader.this.compactedColorBarHeight - 1 - ExperimentClusterHeader.this.startRow) {
                        ColorOverlaps[j] = -1;
                    }
                    if (ColorOverlaps[j] == ExperimentClusterHeader.this.compactedColorBarHeight - 1 - endRow) {
                        ColorOverlaps[j] = ExperimentClusterHeader.this.compactedColorBarHeight - 1 - ExperimentClusterHeader.this.startRow;
                    }
                    if (ColorOverlaps[j] != -1) continue;
                    ColorOverlaps[j] = ExperimentClusterHeader.this.compactedColorBarHeight - 1 - endRow;
                }
                ExperimentClusterHeader.this.repaint();
            }
        }

        private void setOldPosition(int row, int column) {
            this.oldColumn = column;
            this.oldRow = row;
        }

        private boolean isCurrentPosition(int row, int column) {
            return row == this.oldRow && column == this.oldColumn;
        }
    }
}

