/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ExperimentClusterCentroidsViewer
extends JPanel
implements IViewer {
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    protected static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    private int exptID = 0;
    protected ExperimentClusterCentroidViewer centroidViewer;
    protected JPopupMenu popup;
    protected JMenuItem setOverallMaxMenuItem;
    protected JMenuItem setClusterMaxMenuItem;

    public ExperimentClusterCentroidsViewer(Experiment experiment, int[][] clusters) {
        this.centroidViewer = new ExperimentClusterCentroidViewer(experiment, clusters);
        this.exptID = experiment.getId();
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public ExperimentClusterCentroidsViewer(ExperimentClusterCentroidViewer cv) {
        this.centroidViewer = cv;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.centroidViewer});
    }

    @Override
    public void setExperiment(Experiment e) {
        this.centroidViewer.setExperimentID(e.getId());
        this.centroidViewer.setExperiment(e);
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.centroidViewer.setData(framework.getData());
        this.centroidViewer.setMode((Integer)framework.getUserObject());
        this.centroidViewer.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
        this.centroidViewer.onSelected(framework);
    }

    @Override
    public void onDataChanged(IData data) {
        this.centroidViewer.setData(data);
    }

    public void setMeans(float[][] means) {
        this.centroidViewer.setMeans(means);
    }

    public void setVariances(float[][] variances) {
        this.centroidViewer.setVariances(variances);
    }

    public void setCodes(float[][] codes) {
        this.centroidViewer.setCodes(codes);
    }

    @Override
    public Experiment getExperiment() {
        return this.centroidViewer.getExperiment();
    }

    protected IData getData() {
        return this.centroidViewer.getData();
    }

    @Override
    public int[][] getClusters() {
        return this.centroidViewer.getClusters();
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.centroidViewer.onMenuChanged(menu);
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int gap = 10;
        int imagesX = (int)Math.ceil(Math.sqrt(this.getClusters().length));
        int imagesY = (int)Math.ceil((float)this.getClusters().length / (float)imagesX);
        float stepX = (float)(this.getWidth() - 10) / (float)imagesX;
        float stepY = (float)(this.getHeight() - 10) / (float)imagesY;
        Rectangle rect = new Rectangle();
        for (int y = 0; y < imagesY; ++y) {
            int cluster;
            for (int x = 0; x < imagesX && (cluster = y * imagesX + x) < this.getClusters().length; ++x) {
                this.centroidViewer.setClusterIndex(cluster);
                rect.setBounds(Math.round(10.0f + (float)x * stepX), Math.round(10.0f + (float)y * stepY), Math.round(stepX - 10.0f), Math.round(stepY - 10.0f));
                this.centroidViewer.paint((Graphics2D)g, rect, false);
            }
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public int getViewerType() {
        return 1;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected JPopupMenu createJPopupMenu(PopupListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, PopupListener listener) {
        JMenuItem menuItem = new JMenuItem("Save all clusters", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        menu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        menu.add(this.setClusterMaxMenuItem);
    }

    public class PopupListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ExperimentClusterCentroidsViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ExperimentClusterCentroidsViewer.this.onSaveClusters();
            } else if (command.equals(ExperimentClusterCentroidsViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_EXPERIMENT_MAX);
                ExperimentClusterCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(true);
                ExperimentClusterCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(false);
                ExperimentClusterCentroidsViewer.this.repaint();
            } else if (command.equals(ExperimentClusterCentroidsViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                this.setAllYRanges(CentroidViewer.USE_CLUSTER_MAX);
                ExperimentClusterCentroidsViewer.this.setClusterMaxMenuItem.setEnabled(false);
                ExperimentClusterCentroidsViewer.this.setOverallMaxMenuItem.setEnabled(true);
                ExperimentClusterCentroidsViewer.this.repaint();
            }
        }

        private void setAllYRanges(int yRangeOption) {
            int numClusters = ExperimentClusterCentroidsViewer.this.getClusters().length;
            for (int i = 0; i < numClusters; ++i) {
                ExperimentClusterCentroidsViewer.this.centroidViewer.setClusterIndex(i);
                ExperimentClusterCentroidsViewer.this.centroidViewer.setYRangeOption(yRangeOption);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            ExperimentClusterCentroidsViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

