/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class ExperimentClusterCentroidViewer
extends JPanel
implements IViewer {
    public static final Color DEF_CLUSTER_COLOR = Color.lightGray;
    protected static final Color bColor = new Color(0, 0, 128);
    protected JMenuItem setOverallMaxMenuItem;
    protected JMenuItem setClusterMaxMenuItem;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String COLLAPSE_EXPAND = "collapse-expand-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    protected static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    protected Experiment experiment;
    protected IData data;
    protected IFramework framework;
    protected int clusterIndex = 0;
    protected int[][] clusters;
    protected float maxYValue;
    protected float maxClusterValue;
    protected float maxExperimentValue;
    protected float minValue;
    protected float maxValue;
    protected float midValue = 0.0f;
    protected int yRangeOption;
    public static int USE_EXPERIMENT_MAX = 0;
    public static int USE_CLUSTER_MAX = 1;
    protected boolean drawValues = true;
    protected boolean drawVariances = true;
    protected boolean drawCodes = true;
    public static Color missingColor = new Color(128, 128, 128);
    private boolean drawMarks = false;
    private boolean collapseExpand = true;
    protected boolean gradientColors;
    protected boolean isAntiAliasing = false;
    protected float[][] means;
    protected float[][] variances;
    protected float[][] codes;
    protected int numberOfGenes;
    public static BufferedImage posColorImage;
    public static BufferedImage negColorImage;
    protected boolean showRefLine = false;
    private boolean useDoubleGradient = true;
    private int exptID = 0;
    protected JPopupMenu popup;
    int validN;

    public ExperimentClusterCentroidViewer(Experiment e, ClusterWrapper clusters, Integer clusterIndex, float[][] means, float[][] variances, float[][] codes) {
        this(e, clusters.getClusters(), clusterIndex, means, variances, codes);
    }

    public ExperimentClusterCentroidViewer(Experiment e, int[][] clusters, Integer clusterIndex, float[][] means, float[][] variances, float[][] codes) {
        this.clusters = clusters;
        this.clusterIndex = clusterIndex;
        this.experiment = e;
        this.numberOfGenes = this.experiment.getNumberOfGenes();
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.means = means;
        this.variances = variances;
        this.codes = codes;
        this.maxExperimentValue = this.experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.resetSize();
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public ExperimentClusterCentroidViewer(IFramework framework, int mode) {
        this(framework.getData().getExperiment(), ExperimentClusterCentroidViewer.defSampsOrder(framework.getData().getExperiment().getNumberOfSamples()));
        this.means = this.getMeans((int[][])this.clusters).A;
        this.variances = this.getVariances((int[][])this.clusters, (FloatMatrix)this.getMeans((int[][])this.clusters)).A;
        this.setMode(mode);
        this.onSelected(framework);
        this.resetSize();
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    private static int[][] defSampsOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    private FloatMatrix getMeans(int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.experiment.getNumberOfGenes());
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.experiment.getNumberOfGenes());
        int n = cluster.length;
        int denom = 0;
        for (int i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.experiment.get(i, cluster[j]);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(int[][] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        int size = cluster.length;
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.experiment.get(column, cluster[i]);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), new Integer(this.clusterIndex), this.means, this.variances, this.codes});
    }

    public ExperimentClusterCentroidViewer(Experiment experiment, int[][] clusters) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.numberOfGenes = experiment.getNumberOfGenes();
        this.clusters = clusters;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.means = this.getMeans((int[][])clusters).A;
        this.variances = this.getVariances((int[][])clusters, (FloatMatrix)this.getMeans((int[][])clusters)).A;
        this.resetSize();
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public boolean checkGradient() {
        boolean temp = true;
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].length; ++j) {
                try {
                    if (this.data.getExperimentColor(this.clusters[i][j]) == null) continue;
                    temp = false;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return temp;
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midValue ? negColorImage.getRGB(255 - colorIndex, 0) : posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxValue - this.minValue;
            int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
            rgb = posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    public void setGradient(boolean g) {
        this.gradientColors = g;
    }

    public void setMeans(float[][] means) {
        this.means = means;
    }

    public void setVariances(float[][] variances) {
        this.variances = variances;
    }

    public void setCodes(float[][] codes) {
        this.codes = codes;
    }

    public void setDrawMarks(boolean draw) {
        this.drawMarks = draw;
    }

    public void setDrawVariances(boolean draw) {
        this.drawVariances = draw;
    }

    public void setDrawValues(boolean draw) {
        this.drawValues = draw;
    }

    public void setDrawCodes(boolean draw) {
        this.drawCodes = draw;
    }

    public void setAntiAliasing(boolean value) {
        this.isAntiAliasing = value;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.setData(framework.getData());
        this.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
        Object userObject = framework.getUserObject();
        if (userObject != null) {
            if (userObject instanceof CentroidUserObject) {
                this.setClusterIndex(((CentroidUserObject)userObject).getClusterIndex());
                this.setMode(((CentroidUserObject)userObject).getMode());
            } else {
                this.setClusterIndex((Integer)userObject);
            }
        }
        this.updateValues(this.getCluster());
        this.maxValue = framework.getDisplayMenu().getMaxRatioScale();
        this.minValue = framework.getDisplayMenu().getMinRatioScale();
        this.midValue = framework.getDisplayMenu().getMidRatioValue();
        posColorImage = framework.getDisplayMenu().getPositiveGradientImage();
        negColorImage = framework.getDisplayMenu().getNegativeGradientImage();
        this.gradientColors = framework.getDisplayMenu().getColorGradientState();
    }

    public void setClusters(int[][] mat) {
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
            }
        }
        this.means = this.getMeans((int[][])this.clusters).A;
        this.variances = this.getVariances((int[][])this.clusters, (FloatMatrix)this.getMeans((int[][])this.clusters)).A;
        this.repaint();
        this.updateUI();
    }

    public void setData(IData data) {
        this.data = data;
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
        this.updateValues(this.getCluster());
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getProbe(int row) {
        return this.experiment.getGeneIndexMappedToData(row);
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.setDrawVariances(true);
                this.setDrawValues(false);
                break;
            }
            case 1: {
                this.setDrawVariances(false);
                this.setDrawValues(true);
            }
        }
    }

    private void updateValues(int[] cluster) {
        this.maxClusterValue = this.calculateMaxValue(cluster);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getCluster(), this.experiment, 1);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getCluster(), this.experiment, 1);
        this.onDataChanged(this.data);
    }

    private void collapseExpand() {
        this.collapseExpand = !this.collapseExpand;
        this.resetSize();
    }

    private void resetSize() {
        int width = this.collapseExpand ? this.numberOfGenes * 10 + 100 : this.numberOfGenes + 100;
        this.setPreferredSize(new Dimension(width, this.getSize().height));
        this.repaint();
        this.updateUI();
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getCluster(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
    }

    public void setYRangeOption(int option) {
        this.yRangeOption = option != USE_EXPERIMENT_MAX && option != USE_CLUSTER_MAX ? USE_EXPERIMENT_MAX : option;
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle rect = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        this.paint((Graphics2D)g, rect, true);
    }

    public void subPaint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        super.paint(g);
    }

    public void paint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        int i;
        super.paint(g);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int left = rect.x;
        int top = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (width < 5 || height < 5) {
            return;
        }
        int zeroValue = top + Math.round((float)height / 2.0f);
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float factor = (float)height / (2.0f * this.maxYValue);
        float stepX = (float)width / (float)(this.numberOfGenes - 1);
        int stepsY = (int)this.maxYValue + 1;
        float fontHeight = g.getFontMetrics().getHeight() * 2;
        Rectangle bounds = g.getClipBounds();
        int geneBegin = (int)Math.max(((float)bounds.x - 100.0f) / stepX, 0.0f);
        int geneEnd = (int)Math.min((float)this.numberOfGenes, (float)geneBegin + (float)bounds.width / stepX + 100.0f);
        if (drawMarks) {
            FontMetrics metrics = g.getFontMetrics();
            for (int i2 = 1; i2 < stepsY; ++i2) {
                String str = String.valueOf(i2);
                int strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 - Math.round((float)i2 * factor));
                str = String.valueOf(-i2);
                strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 + Math.round((float)i2 * factor));
            }
            g.rotate(-1.5707963267948966);
            int max_name_width = this.getNamesWidth(metrics);
            for (int i3 = geneBegin; i3 < geneEnd; ++i3) {
                if (!this.collapseExpand) continue;
                g.drawString(this.data.getGeneName(i3), -height - top - 10 - max_name_width, left + Math.round((float)i3 * stepX) + 3);
            }
            g.rotate(1.5707963267948966);
        }
        if (this.drawVariances) {
            g.setColor(bColor);
            for (int i4 = geneBegin; i4 < geneEnd; ++i4) {
                if (Float.isNaN(this.means[this.clusterIndex][i4]) || Float.isNaN(this.variances[this.clusterIndex][i4]) || this.variances[this.clusterIndex][i4] < 0.0f) continue;
                g.drawLine(left + Math.round((float)i4 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i4] - this.variances[this.clusterIndex][i4]) * factor), left + Math.round((float)i4 * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i4] + this.variances[this.clusterIndex][i4]) * factor));
                g.drawLine(left + Math.round((float)i4 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i4] - this.variances[this.clusterIndex][i4]) * factor), left + Math.round((float)i4 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i4] - this.variances[this.clusterIndex][i4]) * factor));
                g.drawLine(left + Math.round((float)i4 * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i4] + this.variances[this.clusterIndex][i4]) * factor), left + Math.round((float)i4 * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i4] + this.variances[this.clusterIndex][i4]) * factor));
            }
        }
        if (this.drawValues) {
            Color color = null;
            float maxLineHeight = this.maxExperimentValue * factor / 20.0f;
            for (int sample = 0; sample < this.getCluster().length; ++sample) {
                for (int probe = geneBegin; probe < geneEnd - 1; ++probe) {
                    float fValue = this.experiment.get(probe, this.getCluster()[sample]);
                    float sValue = this.experiment.get(probe + 1, this.getCluster()[sample]);
                    if (Float.isNaN(fValue) || Float.isNaN(sValue)) continue;
                    if (!this.gradientColors) {
                        color = this.data.getExperimentColor(this.getCluster()[sample]);
                        color = color == null ? DEF_CLUSTER_COLOR : color;
                        g.setColor(color);
                        g.drawLine(left + Math.round((float)probe * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(probe + 1) * stepX), zeroValue - Math.round(sValue * factor));
                        continue;
                    }
                    float lineHeight = (sValue - fValue) * factor;
                    int intervalNumber = Math.abs(lineHeight) > maxLineHeight ? Math.abs((int)(lineHeight / maxLineHeight)) : 1;
                    float yInterval = lineHeight / (float)intervalNumber;
                    for (int i5 = 0; i5 < intervalNumber; ++i5) {
                        g.setColor(this.getColor(fValue + (float)i5 * yInterval / factor));
                        g.drawLine(left + Math.round((float)probe * stepX + (float)i5 / (float)intervalNumber * stepX), zeroValue - Math.round(fValue * factor + (float)i5 * yInterval), left + Math.round((float)probe * stepX + ((float)i5 + 1.0f) / (float)intervalNumber * stepX), zeroValue - Math.round(fValue * factor + ((float)i5 + 1.0f) * yInterval));
                    }
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            g.setColor(Color.gray);
            for (int i6 = geneBegin; i6 < geneEnd - 1; ++i6) {
                g.drawLine(left + Math.round((float)i6 * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i6] * factor), left + Math.round((float)(i6 + 1) * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i6 + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawLine(left, zeroValue, left + width, zeroValue);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            g.setColor(Color.magenta);
            for (int i7 = geneBegin; i7 < geneEnd - 1; ++i7) {
                if (Float.isNaN(this.means[this.clusterIndex][i7]) || Float.isNaN(this.means[this.clusterIndex][i7 + 1])) continue;
                g.drawLine(left + Math.round((float)i7 * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i7] * factor), left + Math.round((float)(i7 + 1) * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i7 + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        for (i = geneBegin + 1; i < geneEnd - 1; ++i) {
            g.drawLine(left + Math.round((float)i * stepX), top + height - 5, left + Math.round((float)i * stepX), top + height);
        }
        for (i = 1; i < stepsY; ++i) {
            g.drawLine(left, zeroValue - Math.round((float)i * factor), left + 5, zeroValue - Math.round((float)i * factor));
            g.drawLine(left, zeroValue + Math.round((float)i * factor), left + 5, zeroValue + Math.round((float)i * factor));
        }
        g.setColor(bColor);
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            g.setColor(bColor);
            for (i = geneBegin; i < geneEnd; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i])) continue;
                g.fillOval(left + Math.round((float)i * stepX) - 3, zeroValue - Math.round(this.means[this.clusterIndex][i] * factor) - 3, 6, 6);
            }
        }
        g.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            g.drawString("No Experiments In Cluster", left + 10, top + 20);
        } else if (this.getCluster().length == 1) {
            g.drawString("1 Experiment", left + 10, top + 20);
        } else {
            g.drawString(this.getCluster().length + " Experiments", left + 10, top + 20);
        }
    }

    @Override
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public void onDataChanged(IData data) {
        this.setData(data);
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.setAntiAliasing(menu.isAntiAliasing());
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        posColorImage = menu.getPositiveGradientImage();
        negColorImage = menu.getNegativeGradientImage();
        this.gradientColors = menu.getColorGradientState();
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    private float calculateMaxValue(int[] samples) {
        float max = 0.0f;
        int numGenes = this.experiment.getNumberOfGenes();
        for (int gene = 0; gene < numGenes; ++gene) {
            for (int sample = 0; sample < samples.length; ++sample) {
                float value = this.experiment.get(gene, samples[sample]);
                if (Float.isNaN(value)) continue;
                max = Math.max(max, Math.abs(value));
            }
        }
        return max;
    }

    protected int getNamesWidth(FontMetrics metrics) {
        int maxWidth = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            maxWidth = Math.max(maxWidth, metrics.stringWidth(this.data.getSampleName(this.experiment.getSampleIndex(i))));
        }
        return maxWidth;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Collapse/Expand Labels", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(COLLAPSE_EXPAND);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon((String)"lanuch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon((String)"delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        menu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        menu.add(this.setClusterMaxMenuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Genome Browser", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GENOME_BROWSER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public int getViewerType() {
        return 1;
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.numberOfGenes = this.experiment.getNumberOfGenes();
        this.maxExperimentValue = this.experiment.getMaxAbsValue();
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveAllExperimentClusters(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void broadcastGeneClusterToGenomeBrowser() {
        this.framework.broadcastGeneClusterToGenomeBrowser(this.getExperiment(), this.getCluster(), null);
    }

    public void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    protected JPopupMenu createJPopupMenu(PopupListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperimentCluster(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void broadcastClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), null, this.getCluster());
    }

    public void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getExperiment().getRows());
    }

    protected class PopupListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ExperimentClusterCentroidViewer.SAVE_CLUSTER_CMD)) {
                ExperimentClusterCentroidViewer.this.onSaveCluster();
            } else if (command.equals(ExperimentClusterCentroidViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ExperimentClusterCentroidViewer.this.onSaveClusters();
            } else if (command.equals(ExperimentClusterCentroidViewer.STORE_CLUSTER_CMD)) {
                ExperimentClusterCentroidViewer.this.storeCluster();
            } else if (command.equals(ExperimentClusterCentroidViewer.COLLAPSE_EXPAND)) {
                ExperimentClusterCentroidViewer.this.collapseExpand();
            } else if (command.equals(ExperimentClusterCentroidViewer.SET_DEF_COLOR_CMD)) {
                ExperimentClusterCentroidViewer.this.onSetDefaultColor();
            } else if (command.equals(ExperimentClusterCentroidViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                ExperimentClusterCentroidViewer.this.yRangeOption = USE_EXPERIMENT_MAX;
                ExperimentClusterCentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                ExperimentClusterCentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                ExperimentClusterCentroidViewer.this.repaint();
            } else if (command.equals(ExperimentClusterCentroidViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                ExperimentClusterCentroidViewer.this.yRangeOption = USE_CLUSTER_MAX;
                ExperimentClusterCentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                ExperimentClusterCentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                ExperimentClusterCentroidViewer.this.repaint();
            } else if (command.equals(ExperimentClusterCentroidViewer.LAUNCH_NEW_SESSION_CMD)) {
                ExperimentClusterCentroidViewer.this.launchNewSession();
            } else if (command.equals(ExperimentClusterCentroidViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                ExperimentClusterCentroidViewer.this.broadcastClusterGaggle();
            } else if (command.equals(ExperimentClusterCentroidViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                ExperimentClusterCentroidViewer.this.broadcastNamelistGaggle();
            } else if (command.equals(ExperimentClusterCentroidViewer.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                ExperimentClusterCentroidViewer.this.broadcastGeneClusterToGenomeBrowser();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ExperimentClusterCentroidViewer.this.getCluster() == null || ExperimentClusterCentroidViewer.this.getCluster().length == 0) {
                return;
            }
            ExperimentClusterCentroidViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

