/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class ClusterValidationGenerator {
    private static final long serialVersionUID = 1L;
    private JCheckBox useValidationBox;
    private JCheckBox internalValidationBox;
    private JCheckBox stabilityValidationBox;
    private JCheckBox biologicalValidationBox;
    private JCheckBox hierarchicalMethodBox;
    private JCheckBox kmeansMethodBox;
    private JCheckBox dianaMethodBox;
    private JCheckBox fannyMethodBox;
    private JCheckBox somMethodBox;
    private JCheckBox modelMethodBox;
    private JCheckBox sotaMethodBox;
    private JCheckBox pamMethodBox;
    private JCheckBox claraMethodBox;
    private JCheckBox agnesMethodBox;
    private JCheckBox clusterClusterBox;
    private JTextField lowClusterRange;
    private JTextField highClusterRange;
    private JPanel methodPanel;
    private JPanel linkageMethodPanel;
    private JPanel distanceMetricPanel;
    private JPanel annotationTypePanel;
    private JPanel validationTypePanel;
    private JPanel clusterRangePanel;
    private JPanel mainValidationPanel = new JPanel();
    private JPanel annotationPanel;
    private JComboBox distanceMetricCB;
    private JComboBox linkageMetricCB;
    private JComboBox chipNameBox;
    private JRadioButton bioCAnnotationRB;
    private JRadioButton localAnnotationRB;
    private JRadioButton clusterGenesCheckBox;
    private JRadioButton clusterSamplesCheckBox;
    private Listener listener;
    private AlgorithmDialog parentDialog;
    private ClusterRepository repository;
    private boolean standaloneModule;
    private String bioCAnnotation;
    private String title;
    private ClusterBrowser clusterBrowser;
    private JScrollPane clusterBrowerScrollPane;

    public ClusterValidationGenerator(AlgorithmDialog parent, ClusterRepository repository, String bioCAnnotation, String title) {
        this(parent, title, repository, bioCAnnotation, false);
    }

    public ClusterValidationGenerator(AlgorithmDialog parent, String title, ClusterRepository repository, String bioCAnnotation, boolean standaloneModule) {
        this.parentDialog = parent;
        this.repository = repository;
        this.standaloneModule = standaloneModule;
        this.bioCAnnotation = bioCAnnotation;
        this.title = title;
        this.createGUIComponents();
        this.resetVisibleComponents();
        this.addListeners();
        this.addGUIComponents();
        this.setChildrenBackground(this.mainValidationPanel);
    }

    private void setChildrenBackground(Component comp) {
        Component[] components = ((Container)comp).getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setChildrenBackground(components[i]);
            components[i].setBackground(Color.white);
        }
    }

    private void addGUIComponents() {
        int y = 0;
        if (!this.standaloneModule) {
            this.mainValidationPanel.add((Component)this.useValidationBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.mainValidationPanel.add((Component)this.clusterGenesCheckBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.clusterSamplesCheckBox, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.clusterClusterBox, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.clusterBrowerScrollPane, new GridBagConstraints(0, ++y, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.clusterRangePanel, new GridBagConstraints(0, ++y, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.validationTypePanel, new GridBagConstraints(0, ++y, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.annotationTypePanel, new GridBagConstraints(0, ++y, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.annotationPanel, new GridBagConstraints(0, ++y, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.methodPanel, new GridBagConstraints(0, ++y, 6, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.distanceMetricPanel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.mainValidationPanel.add((Component)this.linkageMethodPanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.resetVisibleComponents();
    }

    private void createGUIComponents() {
        this.listener = new Listener();
        this.mainValidationPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                try {
                    ClusterValidationGenerator.this.parentDialog.pack();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                try {
                    ClusterValidationGenerator.this.parentDialog.pack();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                try {
                    ClusterValidationGenerator.this.parentDialog.pack();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mainValidationPanel.setBackground(Color.white);
        Font font = new Font("Dialog", 1, 12);
        this.mainValidationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.title, 0, 0, font, Color.black));
        this.mainValidationPanel.setLayout(new GridBagLayout());
        this.useValidationBox = new JCheckBox("Use Validation (Requires MeV+R)");
        this.useValidationBox.setSelected(this.standaloneModule);
        this.clusterGenesCheckBox = new JRadioButton("Cluster Genes");
        this.clusterSamplesCheckBox = new JRadioButton("Cluster Samples");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.clusterGenesCheckBox);
        bg.add(this.clusterSamplesCheckBox);
        this.clusterGenesCheckBox.setSelected(true);
        this.clusterClusterBox = new JCheckBox("Perform Analysis on MeV Cluster");
        this.clusterBrowser = new ClusterBrowser(this.repository);
        this.clusterBrowerScrollPane = new JScrollPane(this.clusterBrowser);
        this.clusterBrowerScrollPane.setMaximumSize(new Dimension(this.clusterBrowerScrollPane.getWidth(), 240));
        this.clusterBrowerScrollPane.setPreferredSize(new Dimension(this.clusterBrowerScrollPane.getWidth(), 240));
        this.internalValidationBox = new JCheckBox("Internal Validation");
        this.stabilityValidationBox = new JCheckBox("Stability Validation");
        this.biologicalValidationBox = new JCheckBox("Biological Validation");
        this.validationTypePanel = new JPanel();
        this.validationTypePanel.add(this.internalValidationBox);
        this.validationTypePanel.add(this.stabilityValidationBox);
        this.validationTypePanel.add(this.biologicalValidationBox);
        this.validationTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Validation Type(s)", 0, 0, font, Color.black));
        JLabel clusterRange = new JLabel("Number of Clusters: ");
        this.lowClusterRange = new JTextField("2", 7);
        JLabel dashLabel = new JLabel(" - ");
        this.highClusterRange = new JTextField("6", 7);
        this.clusterRangePanel = new JPanel();
        this.clusterRangePanel.add(clusterRange);
        this.clusterRangePanel.add(this.lowClusterRange);
        this.clusterRangePanel.add(dashLabel);
        this.clusterRangePanel.add(this.highClusterRange);
        this.clusterRangePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Range", 0, 0, font, Color.black));
        this.hierarchicalMethodBox = new JCheckBox("HCL");
        this.kmeansMethodBox = new JCheckBox("K-Means");
        this.dianaMethodBox = new JCheckBox("DIANA");
        this.fannyMethodBox = new JCheckBox("FANNY");
        this.somMethodBox = new JCheckBox("SOM");
        this.modelMethodBox = new JCheckBox("MODEL");
        this.sotaMethodBox = new JCheckBox("SOTA");
        this.pamMethodBox = new JCheckBox("PAM");
        this.claraMethodBox = new JCheckBox("CLARA");
        this.agnesMethodBox = new JCheckBox("AGNES");
        this.methodPanel = new JPanel();
        this.methodPanel.add(this.hierarchicalMethodBox);
        this.methodPanel.add(this.kmeansMethodBox);
        this.methodPanel.add(this.somMethodBox);
        this.methodPanel.add(this.sotaMethodBox);
        this.methodPanel.add(this.dianaMethodBox);
        this.methodPanel.add(this.fannyMethodBox);
        this.methodPanel.add(this.modelMethodBox);
        this.methodPanel.add(this.pamMethodBox);
        this.methodPanel.add(this.claraMethodBox);
        this.methodPanel.add(this.agnesMethodBox);
        this.methodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Clustering Method(s)", 0, 0, font, Color.black));
        this.distanceMetricCB = new JComboBox<String>(new String[]{"euclidean", "correlation", "manhattan"});
        this.distanceMetricPanel = new JPanel();
        this.distanceMetricPanel.add(new JLabel("Distance Metric: "));
        this.distanceMetricPanel.add(this.distanceMetricCB);
        this.linkageMetricCB = new JComboBox<String>(new String[]{"ward", "single", "complete", "average"});
        this.linkageMetricCB.setSelectedItem("average");
        this.linkageMethodPanel = new JPanel();
        this.linkageMethodPanel.add(new JLabel("Linkage Metric: "));
        this.linkageMethodPanel.add(this.linkageMetricCB);
        this.annotationTypePanel = new JPanel();
        this.bioCAnnotationRB = new JRadioButton("Bioconductor Annotation");
        this.bioCAnnotationRB.setSelected(true);
        this.localAnnotationRB = new JRadioButton("Local Annotation");
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.bioCAnnotationRB);
        bg1.add(this.localAnnotationRB);
        this.annotationTypePanel.add(this.bioCAnnotationRB);
        this.annotationTypePanel.add(this.localAnnotationRB);
        this.chipNameBox = this.generateChipNameBox(this.bioCAnnotation);
        this.annotationPanel = new JPanel();
        this.annotationPanel.add(new JLabel("Chip Name: "));
        this.annotationPanel.add(this.chipNameBox);
        if (this.repository == null || this.repository.isEmpty()) {
            this.clusterClusterBox.setEnabled(false);
        }
    }

    private void addListeners() {
        this.useValidationBox.addActionListener(this.listener);
        this.agnesMethodBox.addActionListener(this.listener);
        this.hierarchicalMethodBox.addActionListener(this.listener);
        this.bioCAnnotationRB.addActionListener(this.listener);
        this.localAnnotationRB.addActionListener(this.listener);
        this.biologicalValidationBox.addActionListener(this.listener);
        this.clusterClusterBox.addActionListener(this.listener);
        this.clusterGenesCheckBox.addActionListener(this.listener);
        this.clusterSamplesCheckBox.addActionListener(this.listener);
    }

    private String[] getMeasuresArray() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.internalValidationBox.isSelected()) {
            al.add("internal");
        }
        if (this.stabilityValidationBox.isSelected()) {
            al.add("stability");
        }
        if (this.biologicalValidationBox.isSelected()) {
            al.add("biological");
        }
        String[] ret = new String[al.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)al.get(i);
        }
        return ret;
    }

    private JComboBox generateChipNameBox(String bioCAnnotation) {
        JComboBox<String> chipNameBox = new JComboBox<String>(this.getBioCAnnotationsArray());
        if (bioCAnnotation != null) {
            for (int i = 0; i < chipNameBox.getItemCount(); ++i) {
                if (!chipNameBox.getItemAt(i).toString().equals(bioCAnnotation) && !chipNameBox.getItemAt(i).toString().equals(bioCAnnotation + ".db")) continue;
                chipNameBox.setSelectedIndex(i);
            }
        }
        return chipNameBox;
    }

    private String[] getBioCAnnotationsArray() {
        ArrayList<String> bioCAnnotations = new ArrayList<String>();
        try {
            String urlString;
            String fullURL = urlString = "ftp://occams.dfci.harvard.edu/pub/bio/MeV_Etc/R_MeV_Support_devel/R2.11/win/attract/annotationSupported.txt";
            URL url = new URL(fullURL);
            URLConnection url_conn = url.openConnection();
            url_conn.setDoInput(true);
            url_conn.setUseCaches(true);
            BufferedReader inp = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
            String s = inp.readLine();
            while (s != null) {
                bioCAnnotations.add(s);
                s = inp.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading supported Bioconductor annotations");
        }
        String[] bioCAnnotationsArray = new String[bioCAnnotations.size()];
        for (int i = 0; i < bioCAnnotationsArray.length; ++i) {
            bioCAnnotationsArray[i] = (String)bioCAnnotations.get(i);
        }
        return bioCAnnotationsArray;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        ClusterValidationGenerator cvg = new ClusterValidationGenerator(null, null, "hgu133a", "asdasda");
        jf.add(cvg.getClusterValidationPanel());
        jf.setSize(800, 600);
        jf.setVisible(true);
    }

    public JPanel getClusterValidationPanel() {
        return this.mainValidationPanel;
    }

    private void resetVisibleComponents() {
        boolean vis = this.useValidationBox.isSelected();
        this.clusterGenesCheckBox.setVisible(vis);
        this.clusterSamplesCheckBox.setVisible(vis);
        this.clusterClusterBox.setVisible(vis && this.clusterGenesCheckBox.isSelected());
        this.internalValidationBox.setVisible(vis);
        this.stabilityValidationBox.setVisible(vis);
        this.biologicalValidationBox.setVisible(vis);
        this.clusterRangePanel.setVisible(vis);
        this.methodPanel.setVisible(vis);
        this.validationTypePanel.setVisible(vis);
        this.distanceMetricPanel.setVisible(vis);
        this.clusterBrowerScrollPane.setVisible(vis && this.clusterClusterBox.isSelected() && this.clusterGenesCheckBox.isSelected() && this.repository != null);
        this.annotationTypePanel.setVisible(vis && this.biologicalValidationBox.isSelected());
        this.annotationPanel.setVisible(vis && this.biologicalValidationBox.isSelected() && this.bioCAnnotationRB.isSelected());
        this.linkageMethodPanel.setVisible(vis && this.hierarchicalMethodBox.isSelected() || this.agnesMethodBox.isSelected());
        this.mainValidationPanel.validate();
        this.mainValidationPanel.updateUI();
    }

    public String getLinkageMethod() {
        return this.linkageMetricCB.getSelectedItem().toString();
    }

    public String getValidationDistanceMetric() {
        return this.distanceMetricCB.getSelectedItem().toString();
    }

    public String getBioCAnnotationString() {
        return this.chipNameBox.getSelectedItem().toString();
    }

    public boolean validateParameters() {
        boolean pass = true;
        String clusteringMethodMessage = "";
        String validTypeMessage = "";
        String numberFormatMessage = "";
        if (!this.useValidationBox.isSelected()) {
            return true;
        }
        if (this.getMethodsArray().length == 0) {
            this.methodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Clustering Method(s)", 0, 0, new Font("Dialog", 1, 12), Color.red));
            clusteringMethodMessage = "*Please select at least one clustering method.";
            pass = false;
        }
        if (this.getMeasuresArray().length == 0) {
            this.validationTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Validation Type(s)", 0, 0, new Font("Dialog", 1, 12), Color.red));
            validTypeMessage = "*Please select at least one validation type.";
            pass = false;
        }
        try {
            if (Integer.parseInt(this.lowClusterRange.getText()) < 2 || Integer.parseInt(this.highClusterRange.getText()) > 6 || Integer.parseInt(this.highClusterRange.getText()) - Integer.parseInt(this.lowClusterRange.getText()) < 0) {
                numberFormatMessage = "*Please enter a cluster range between 2 and 6, inclusive.";
                pass = false;
                this.clusterRangePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Range", 0, 0, new Font("Dialog", 1, 12), Color.red));
            }
        }
        catch (Exception e) {
            this.clusterRangePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Range", 0, 0, new Font("Dialog", 1, 12), Color.red));
            pass = false;
            numberFormatMessage = "*Please enter a cluster range using integers only.";
        }
        if (!pass) {
            JOptionPane.showMessageDialog(null, "Validation parameters are insufficient.\n" + validTypeMessage + "\n" + clusteringMethodMessage + "\n" + numberFormatMessage, "Error", 0);
        }
        return pass;
    }

    public void addValidationParameters(AlgorithmData validationData) {
        validationData.addStringArray("methodsArray", this.getMethodsArray());
        validationData.addIntArray("subCluster", this.getSubCluster());
        validationData.addParam("validate", String.valueOf(this.isValidate()));
        validationData.addParam("cluster-genes", String.valueOf(this.isClusterGenes()));
        validationData.addParam("cluster-samples", String.valueOf(this.isClusterSamples()));
        validationData.addParam("internal-validation", String.valueOf(this.isInternalV()));
        validationData.addParam("stability-validation", String.valueOf(this.isStabilityV()));
        validationData.addParam("biological-validation", String.valueOf(this.isBiologicalV()));
        validationData.addParam("cluster-range-low", String.valueOf(this.getLowClusterRange()));
        validationData.addParam("cluster-range-high", String.valueOf(this.getHighClusterRange()));
        validationData.addParam("validation-linkage", String.valueOf(this.getValidationLinkageMethod()));
        validationData.addParam("validation-distance", String.valueOf(this.getValidationDistanceMetric()));
        validationData.addParam("bioC-annotation", String.valueOf(this.getBioCAnnotationString()));
    }

    private int[] getSubCluster() {
        if (!this.clusterClusterBox.isSelected()) {
            return null;
        }
        try {
            return this.clusterBrowser.getSelectedCluster().getIndices();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getMethodsArray() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.hierarchicalMethodBox.isSelected()) {
            al.add("hierarchical");
        }
        if (this.kmeansMethodBox.isSelected()) {
            al.add("kmeans");
        }
        if (this.somMethodBox.isSelected()) {
            al.add("som");
        }
        if (this.dianaMethodBox.isSelected()) {
            al.add("diana");
        }
        if (this.fannyMethodBox.isSelected()) {
            al.add("fanny");
        }
        if (this.modelMethodBox.isSelected()) {
            al.add("model");
        }
        if (this.sotaMethodBox.isSelected()) {
            al.add("sota");
        }
        if (this.pamMethodBox.isSelected()) {
            al.add("pam");
        }
        if (this.claraMethodBox.isSelected()) {
            al.add("clara");
        }
        if (this.agnesMethodBox.isSelected()) {
            al.add("agnes");
        }
        String[] ret = new String[al.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)al.get(i);
        }
        return ret;
    }

    public String getClusterID() {
        if (!this.clusterClusterBox.isSelected()) {
            return "All genes";
        }
        return this.clusterBrowser.getSelectedCluster().getClusterLabel();
    }

    public boolean isValidate() {
        return this.useValidationBox.isSelected();
    }

    public boolean isInternalV() {
        return this.internalValidationBox.isSelected();
    }

    public boolean isStabilityV() {
        return this.stabilityValidationBox.isSelected();
    }

    public boolean isBiologicalV() {
        return this.biologicalValidationBox.isSelected();
    }

    public String getValidationLinkageMethod() {
        return this.getLinkageMethod();
    }

    public boolean isClusterGenes() {
        return this.clusterGenesCheckBox.isSelected();
    }

    public boolean isClusterSamples() {
        return this.clusterSamplesCheckBox.isSelected();
    }

    public int getLowClusterRange() {
        return Integer.parseInt(this.lowClusterRange.getText());
    }

    public int getHighClusterRange() {
        return Integer.parseInt(this.highClusterRange.getText());
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClusterValidationGenerator.this.resetVisibleComponents();
        }
    }
}

