/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.annotation.AnnoAttributeObj;
import org.tigr.microarray.mev.annotation.InsufficientArgumentsException;
import org.tigr.microarray.mev.annotation.PublicURL;
import org.tigr.microarray.mev.annotation.URLNotFoundException;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableSearchDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.BrowserLauncher;
import org.tigr.util.QSort;

public class ClusterTableViewer
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String STORE_SELECTED_ROWS_CMD = "store-selected-rows-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD = "launch-new-session-with-sel-rows-cmd";
    protected static final String SEARCH_CMD = "search-cmd";
    protected static final String CLEAR_ALL_CMD = "clear-all-cmd";
    protected static final String COPY_CMD = "copy-cells";
    protected static final String SELECT_ALL_CMD = "select-all-cmd";
    protected static final String SORT_ORIG_ORDER_CMD = "sort-orig-order-cmd";
    protected static final String TOGGLE_SCALE = "toggle-scale-cmd";
    protected static final String LINK_TO_URL_CMD = "link-to-url-cmd";
    protected static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    protected static final String BROADCAST_SELECTED_MATRIX_GAGGLE_CMD = "broadcast-selected-matrix-to-gaggle";
    protected static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    private JComponent header;
    private JPopupMenu popup;
    private Experiment experiment;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int xColumn;
    private int xRow;
    private int[][] clusters;
    private int[][] sortedClusters;
    private int[] samplesOrder;
    private int[] lastSelectedAnnotationIndices;
    private String[] auxTitles;
    private String[] fieldNames;
    private Object[][] auxData;
    private boolean[][] sortedAscending;
    private JTable clusterTable;
    private ClusterTableModel clusterModel;
    private ClusterTableSearchDialog searchDialog;
    private JMenuItem urlMenuItem;
    private int exptID = 0;
    private boolean useGlobalMinMax = false;
    protected LinkRenderer linkRenderer;
    float globalMin = Float.POSITIVE_INFINITY;
    float globalMax = Float.NEGATIVE_INFINITY;

    public ClusterTableViewer(IFramework framework) {
        this(framework.getData().getExperiment(), ClusterTableViewer.defGenesOrder(framework.getData().getExperiment().getNumberOfGenes()), framework.getData());
        this.framework = framework;
    }

    public ClusterTableViewer(Experiment experiment, int[][] clusters, IData data) {
        this(experiment, clusters, data, new String[0], new Object[0][0]);
    }

    public ClusterTableViewer(Experiment experiment, ClusterWrapper clusters, IData data, String[] auxTitles, Object[][] auxData) {
        this(experiment, clusters.getClusters(), data, auxTitles, auxData);
    }

    public ClusterTableViewer(Experiment experiment, int[][] clusters, IData data, String[] auxTitles, Object[][] auxData) {
        int i;
        int i2;
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        if (clusters == null) {
            clusters = new int[1][experiment.getNumberOfGenes()];
            for (i2 = 0; i2 < experiment.getNumberOfGenes(); ++i2) {
                clusters[0][i2] = i2;
            }
        }
        this.data = data;
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters;
        this.fieldNames = data.getFieldNames();
        this.auxTitles = auxTitles;
        this.setMinMax();
        if (this.auxTitles == null) {
            this.auxTitles = new String[0];
        }
        this.auxData = auxData;
        this.lastSelectedAnnotationIndices = new int[2];
        this.xColumn = -1;
        for (i2 = 0; i2 < this.lastSelectedAnnotationIndices.length; ++i2) {
            this.lastSelectedAnnotationIndices[1] = 0;
        }
        this.sortedClusters = new int[clusters.length][];
        for (i2 = 0; i2 < this.sortedClusters.length; ++i2) {
            this.sortedClusters[i2] = new int[clusters[i2].length];
        }
        for (i2 = 0; i2 < this.sortedClusters.length; ++i2) {
            for (int j = 0; j < this.sortedClusters[i2].length; ++j) {
                this.sortedClusters[i2][j] = clusters[i2][j];
            }
        }
        this.clusterModel = new ClusterTableModel();
        this.clusterTable = new JTable(this.clusterModel);
        this.clusterTable.setCellSelectionEnabled(true);
        this.clusterTable.setDefaultRenderer(Color.class, new ColorSparklineRenderer(true));
        this.clusterTable.setDefaultRenderer(float[].class, new ColorSparklineRenderer(true));
        this.linkRenderer = new LinkRenderer();
        this.clusterTable.setDefaultRenderer(AnnoAttributeObj.class, this.linkRenderer);
        TableColumn column = null;
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[clusters.length][this.clusterModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            for (int j = 0; j < this.sortedAscending[i].length; ++j) {
                this.sortedAscending[i][j] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
        this.clusterTable.addMouseListener(new LinkListener());
    }

    public JTable getTable() {
        return this.clusterTable;
    }

    private static int[][] defGenesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    public void setTableClusters(int[][] mat) {
        this.sortedClusters = new int[mat.length][mat[0].length];
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
                this.sortedClusters[i][j] = mat[i][j];
            }
        }
        this.clusterTable.clearSelection();
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters), this.data, this.auxTitles, this.auxData});
    }

    protected Object[][] getAuxData() {
        return this.auxData;
    }

    protected String[] getAuxTitles() {
        return this.auxTitles;
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    @Override
    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.gray);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.clusterTable, constraints);
        panel.add(this.clusterTable);
        return panel;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public void onClosed() {
    }

    @Override
    public void onDataChanged(IData data) {
        this.data = data;
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        Integer userObject = (Integer)framework.getUserObject();
        this.setClusterIndex(userObject == null ? 0 : userObject);
        this.clusterTable.clearSelection();
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    public int[] getSortedCluster() {
        return this.sortedClusters[this.clusterIndex];
    }

    private int getExperimentRow(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    protected int getProbe(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    private int getColumn(int column) {
        return this.samplesOrder[column];
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    private int[] getIDataRowIndices(int[] expIndices) {
        int[] dataIndices = new int[expIndices.length];
        for (int i = 0; i < expIndices.length; ++i) {
            dataIndices[i] = this.getMultipleArrayDataRow(i);
        }
        return dataIndices;
    }

    private int getMultipleArrayDataRow(int clusterArrayRow) {
        return this.experiment.getGeneIndexMappedToData(this.clusters[this.clusterIndex][clusterArrayRow]);
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(true);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    ClusterTableViewer.this.sortByColumn(column, !ClusterTableViewer.this.sortedAscending[ClusterTableViewer.this.getClusterIndex()][column], originalOrder);
                    boolean bl = ((ClusterTableViewer)ClusterTableViewer.this).sortedAscending[ClusterTableViewer.this.getClusterIndex()][column] = !ClusterTableViewer.this.sortedAscending[ClusterTableViewer.this.getClusterIndex()][column];
                    if (originalOrder) {
                        for (int i = 0; i < ClusterTableViewer.this.clusterModel.getColumnCount(); ++i) {
                            ((ClusterTableViewer)ClusterTableViewer.this).sortedAscending[ClusterTableViewer.this.getClusterIndex()][i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        if (originalOrder) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedClusters[this.clusterIndex][i] = this.getCluster()[i];
            }
            this.clusterTable.repaint();
            this.clusterTable.clearSelection();
            return;
        }
        int[] sortedIndices = new int[this.getCluster().length];
        if (column < 2) {
            double[] origArray = new double[this.getCluster().length];
            for (int i = 0; i < origArray.length; ++i) {
                Color currColor = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getCluster()[i])) == null ? Color.white : this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getCluster()[i]));
                origArray[i] = currColor.getRGB();
            }
            QSort sortArray = new QSort(origArray);
            int[] sortedPrimaryIndices = sortArray.getOrigIndx();
            for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                sortedIndices[i] = this.getCluster()[sortedPrimaryIndices[i]];
            }
        } else if (column < this.fieldNames.length + 2) {
            int i;
            Object[] sortFields = new SortableField[this.getCluster().length];
            for (i = 0; i < sortFields.length; ++i) {
                int currIndex = this.getCluster()[i];
                String currField = this.data.getElementAttribute(this.experiment.getGeneIndexMappedToData(this.getCluster()[i]), column - 2);
                sortFields[i] = new SortableField(currIndex, currField);
            }
            Arrays.sort(sortFields);
            for (i = 0; i < sortFields.length; ++i) {
                sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
            }
        } else {
            int obType = ClusterTableViewer.getObjectType(this.auxData[0][column - (this.fieldNames.length + 2)]);
            if (obType == 12 || obType == 11 || obType == 10) {
                double[] origArray = new double[this.getCluster().length];
                for (int i = 0; i < origArray.length; ++i) {
                    if (obType == 12) {
                        origArray[i] = (Double)this.auxData[this.getCluster()[i]][column - (this.fieldNames.length + 2)];
                        continue;
                    }
                    if (obType == 11) {
                        origArray[i] = ((Float)this.auxData[this.getCluster()[i]][column - (this.fieldNames.length + 2)]).doubleValue();
                        continue;
                    }
                    if (obType != 10) continue;
                    origArray[i] = ((Integer)this.auxData[this.getCluster()[i]][column - (this.fieldNames.length + 2)]).doubleValue();
                }
                QSort sortArray = new QSort(origArray);
                int[] sortedPrimaryIndices = sortArray.getOrigIndx();
                for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                    sortedIndices[i] = this.getCluster()[sortedPrimaryIndices[i]];
                }
            } else if (obType == 14) {
                int i;
                Object[] sortFields = new SortableField[this.getCluster().length];
                for (i = 0; i < sortFields.length; ++i) {
                    int currIndex = this.getCluster()[i];
                    String currField = ((Boolean)this.auxData[this.getCluster()[i]][column - (this.fieldNames.length + 2)]).toString();
                    sortFields[i] = new SortableField(currIndex, currField);
                }
                Arrays.sort(sortFields);
                for (i = 0; i < sortFields.length; ++i) {
                    sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
                }
            } else if (obType == 13) {
                int i;
                Object[] sortFields = new SortableField[this.getCluster().length];
                for (i = 0; i < sortFields.length; ++i) {
                    int currIndex = this.getCluster()[i];
                    String currField = (String)this.auxData[this.getCluster()[i]][column - (this.fieldNames.length + 2)];
                    sortFields[i] = new SortableField(currIndex, currField);
                }
                Arrays.sort(sortFields);
                for (i = 0; i < sortFields.length; ++i) {
                    sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
                }
            }
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedClusters[this.clusterIndex][i] = sortedIndices[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.removeRowSelectionInterval(0, this.clusterTable.getRowCount() - 1);
    }

    private static int[] getTypes(Object[][] objData) {
        int[] types = new int[objData[0].length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ClusterTableViewer.getObjectType(objData[0][i]);
        }
        return types;
    }

    private static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.clusterTable.getLocation().x + 100, this.clusterTable.getLocation().y + 100);
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void setClusterColor(Color color) {
        boolean success;
        if (color == null && !(success = this.framework.removeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 0))) {
            JOptionPane.showMessageDialog(null, "Cluster not deleted! Selected rows must exactly correspond to a cluster created in the current algorithm run", "Error", 0);
        }
    }

    public void storeCluster() {
        this.framework.storeSubCluster(this.getArrayMappedToData(), this.experiment, 0);
        this.onDataChanged(this.data);
    }

    public void storeSelectedRowsAsCluster() {
        if (this.getArrayMappedToSelectedIndices().length == 0) {
            JOptionPane.showMessageDialog(null, "No rows selected! Cluster will not be saved", "Error", 0);
        } else {
            this.framework.storeSubCluster(this.getArrayMappedToSelectedIndices(), this.experiment, 0);
            this.onDataChanged(this.data);
        }
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getArrayMappedToData(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    public void launchNewSessionWithSelectedRows() {
        this.framework.launchNewMAV(this.getArrayMappedToSelectedIndices(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    public void copyCells() {
        TransferHandler th = this.clusterTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.clusterTable, cb, 1);
        }
    }

    public void sortInOrigOrder() {
        int i;
        for (i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedClusters[this.clusterIndex][i] = this.getCluster()[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.clearSelection();
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            this.sortedAscending[this.getClusterIndex()][i] = false;
        }
    }

    private int[] getArrayMappedToData() {
        int[] clusterIndices = this.getCluster();
        if (clusterIndices == null || clusterIndices.length < 1) {
            return clusterIndices;
        }
        int[] dataIndices = new int[clusterIndices.length];
        for (int i = 0; i < clusterIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(clusterIndices[i]);
        }
        return dataIndices;
    }

    private int[] getArrayMappedToSelectedIndices() {
        int[] selectedRows = this.clusterTable.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return new int[0];
        }
        int[] dataIndices = new int[selectedRows.length];
        for (int i = 0; i < dataIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(this.getSortedCluster()[selectedRows[i]]);
        }
        return dataIndices;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store entire cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Store selected rows as cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_SELECTED_ROWS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete cluster composed of selected rows", GUIFactory.getIcon((String)"delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session with entire cluster", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session with selected rows", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Search...", GUIFactory.getIcon((String)"ClusterInformationResult.gif"));
        menuItem.setActionCommand(SEARCH_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(COPY_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SELECT_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(CLEAR_ALL_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Sort table in original gene order...", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(SORT_ORIG_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Toggle global/gene sparkline scale ", GUIFactory.getIcon((String)"TableViewerResult.gif"));
        menuItem.setActionCommand(TOGGLE_SCALE);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        this.urlMenuItem = new JMenuItem("Link to URL ...", GUIFactory.getIcon((String)"ClusterInformationResult.gif"));
        this.urlMenuItem.setActionCommand(LINK_TO_URL_CMD);
        this.urlMenuItem.addActionListener(listener);
        menu.add(this.urlMenuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Selected Rows as Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_SELECTED_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Genome Browser", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GENOME_BROWSER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    private void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
            } else {
                ExperimentUtil.saveAllGeneClustersWithAux(frame, this.getExperiment(), this.getData(), this.getClusters(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.clusterTable);
        try {
            if (this.auxTitles.length == 0) {
                ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
            } else {
                ExperimentUtil.saveGeneClusterWithAux(frame, this.getExperiment(), this.getData(), this.getCluster(), this.auxTitles, this.auxData);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void linkToURL() {
        JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this.clusterTable);
        ExperimentUtil.linkToURL(frame, this.getExperiment(), this.getData(), this.getArrayMappedToSelectedIndices()[0], ExperimentUtil.lastSelectedAnnotationIndices);
    }

    private void linkToURL2() {
        JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this.clusterTable);
        String colName = this.clusterTable.getColumnName(this.xColumn);
        ExperimentUtil.linkToURL(frame, this.getExperiment(), this.getData(), this.getArrayMappedToSelectedIndices()[0], colName, ExperimentUtil.lastSelectedAnnotationIndices);
    }

    private void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    private void toggleScale() {
        this.useGlobalMinMax = !this.useGlobalMinMax;
        this.clusterTable.repaint();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.experiment);
        oos.writeObject(this.clusters);
        oos.writeObject(this.header);
        oos.writeObject(this.popup);
        oos.writeInt(this.clusterIndex);
        oos.writeObject(this.sortedClusters);
        oos.writeObject(this.samplesOrder);
        oos.writeObject(this.auxTitles);
        oos.writeObject(this.fieldNames);
        oos.writeObject(this.auxData);
        oos.writeObject(this.sortedAscending);
        oos.writeObject(this.clusterTable);
        oos.writeObject(this.clusterModel);
        oos.writeObject(this.searchDialog);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int i;
        this.experiment = (Experiment)ois.readObject();
        this.clusters = (int[][])ois.readObject();
        this.header = (JComponent)ois.readObject();
        this.popup = (JPopupMenu)ois.readObject();
        this.clusterIndex = ois.readInt();
        this.sortedClusters = (int[][])ois.readObject();
        this.samplesOrder = (int[])ois.readObject();
        this.auxTitles = (String[])ois.readObject();
        this.fieldNames = (String[])ois.readObject();
        this.auxData = (Object[][])ois.readObject();
        this.sortedAscending = (boolean[][])ois.readObject();
        this.clusterTable = (JTable)ois.readObject();
        this.clusterModel = (ClusterTableModel)ois.readObject();
        this.searchDialog = (ClusterTableSearchDialog)ois.readObject();
        this.clusterTable.setDefaultRenderer(Color.class, new ColorSparklineRenderer(true));
        this.clusterTable.setDefaultRenderer(float[].class, new ColorSparklineRenderer(true));
        TableColumn column = null;
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[this.clusters.length][this.clusterModel.getColumnCount()];
        for (i = 0; i < this.sortedAscending.length; ++i) {
            for (int j = 0; j < this.sortedAscending[i].length; ++j) {
                this.sortedAscending[i][j] = false;
            }
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.searchDialog = new ClusterTableSearchDialog(JOptionPane.getFrameForComponent(this.clusterTable), this.clusterTable, false);
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    @Override
    public int getViewerType() {
        return 0;
    }

    protected void broadcastClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), this.getCluster(), null);
    }

    protected void broadcastSelectedClusterGaggle() {
        this.framework.broadcastGeneCluster(this.getExperiment(), this.getArrayMappedToSelectedIndices(), null);
    }

    protected void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getCluster());
    }

    public void broadcastGeneClusterToGenomeBrowser() {
        this.framework.broadcastGeneClusterToGenomeBrowser(this.getExperiment(), this.getCluster(), null);
    }

    private void setMinMax() {
        for (int i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            for (int j = 0; j < this.experiment.getNumberOfSamples(); ++j) {
                this.globalMin = this.experiment.getValues()[i][j] < this.globalMin ? this.experiment.getValues()[i][j] : this.globalMin;
                this.globalMax = this.experiment.getValues()[i][j] > this.globalMax ? this.experiment.getValues()[i][j] : this.globalMax;
            }
        }
    }

    public class LinkListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent event) {
            ClusterTableViewer.this.xRow = ClusterTableViewer.this.clusterTable.rowAtPoint(event.getPoint());
            ClusterTableViewer.this.xColumn = ClusterTableViewer.this.clusterTable.columnAtPoint(event.getPoint());
            Object value = ClusterTableViewer.this.clusterTable.getValueAt(ClusterTableViewer.this.xRow, ClusterTableViewer.this.xColumn);
            if (value != null && value instanceof AnnoAttributeObj && ((AnnoAttributeObj)value).getAttribCount() > 0 && !((AnnoAttributeObj)value).getAttributeAt(0).equals("NA")) {
                Cursor c = new Cursor(12);
                JOptionPane.getFrameForComponent(ClusterTableViewer.this.clusterTable).setCursor(c);
            } else {
                Cursor c = Cursor.getDefaultCursor();
                JOptionPane.getFrameForComponent(ClusterTableViewer.this.clusterTable).setCursor(c);
            }
            event.consume();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Cursor c = Cursor.getDefaultCursor();
            JOptionPane.getFrameForComponent(ClusterTableViewer.this.clusterTable).setCursor(c);
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            ClusterTableViewer.this.xRow = ClusterTableViewer.this.clusterTable.rowAtPoint(event.getPoint());
            ClusterTableViewer.this.xColumn = ClusterTableViewer.this.clusterTable.columnAtPoint(event.getPoint());
            Object value = ClusterTableViewer.this.clusterTable.getValueAt(ClusterTableViewer.this.xRow, ClusterTableViewer.this.xColumn);
            if (value != null && value instanceof AnnoAttributeObj && ((AnnoAttributeObj)value).getAttribCount() > 0 && !((AnnoAttributeObj)value).getAttributeAt(0).equals("NA")) {
                Cursor c = new Cursor(12);
                JOptionPane.getFrameForComponent(ClusterTableViewer.this.clusterTable).setCursor(c);
            } else {
                Cursor c = Cursor.getDefaultCursor();
                JOptionPane.getFrameForComponent(ClusterTableViewer.this.clusterTable).setCursor(c);
            }
            event.consume();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            ClusterTableViewer.this.xRow = ClusterTableViewer.this.clusterTable.rowAtPoint(event.getPoint());
            ClusterTableViewer.this.xColumn = ClusterTableViewer.this.clusterTable.columnAtPoint(event.getPoint());
            Object value = ClusterTableViewer.this.clusterTable.getValueAt(ClusterTableViewer.this.xRow, ClusterTableViewer.this.xColumn);
            if (value != null && value instanceof AnnoAttributeObj && ((AnnoAttributeObj)value).getAttribCount() > 0 && !((AnnoAttributeObj)value).getAttributeAt(0).equals("NA") && PublicURL.hasUrlForKey((String)((AnnoAttributeObj)value).getAttribName())) {
                String url = "http://www.tm4.org/search?" + ((AnnoAttributeObj)value).getAttributeAt(0);
                String[] attribvalue = new String[((AnnoAttributeObj)value).getAttribCount()];
                for (int i = 0; i < attribvalue.length; ++i) {
                    attribvalue[i] = ((AnnoAttributeObj)value).getAttributeAt(i).toString();
                }
                try {
                    if (((AnnoAttributeObj)value).getAttribName().equalsIgnoreCase("TGI_TC") || ((AnnoAttributeObj)value).getAttribName().equalsIgnoreCase("TGI_GC") || ((AnnoAttributeObj)value).getAttribName().equalsIgnoreCase("TGI_ORTH") || ((AnnoAttributeObj)value).getAttribName().equalsIgnoreCase("CHR_LOCATION")) {
                        String[] newString = new String[attribvalue.length + 1];
                        newString[0] = ClusterTableViewer.this.framework.getData().getChipAnnotation().getSpeciesName().toString();
                        for (int i = 0; i < attribvalue.length; ++i) {
                            newString[i + 1] = attribvalue[i];
                        }
                        url = PublicURL.getURL((String)((AnnoAttributeObj)value).getAttribName(), (String[])newString);
                    } else {
                        url = PublicURL.getURL((String)((AnnoAttributeObj)value).getAttribName(), (String[])attribvalue);
                    }
                    BrowserLauncher.openURL((String)url);
                }
                catch (InsufficientArgumentsException iae) {
                    iae.printStackTrace();
                }
                catch (URLNotFoundException unfe) {
                    unfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            event.consume();
        }
    }

    public class Sparkline
    extends JLabel {
        float[] values;
        float geneMin = Float.POSITIVE_INFINITY;
        float geneMax = Float.NEGATIVE_INFINITY;

        public Sparkline(float[] values) {
            this.values = values;
            for (int i = 0; i < values.length; ++i) {
                this.geneMin = values[i] < this.geneMin ? values[i] : this.geneMin;
                this.geneMax = values[i] > this.geneMax ? values[i] : this.geneMax;
            }
            this.setBackground(Color.blue);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            float min = ClusterTableViewer.this.useGlobalMinMax ? ClusterTableViewer.this.globalMin : this.geneMin;
            float max = ClusterTableViewer.this.useGlobalMinMax ? ClusterTableViewer.this.globalMax : this.geneMax;
            g.setColor(Color.blue);
            for (int i = 0; i < this.values.length - 1; ++i) {
                g.drawLine((int)((float)i / (float)(this.values.length - 1) * (float)this.getWidth()), (int)((float)this.getHeight() * (this.values[i] - max) / (min - max)), (int)((float)(i + 1) / (float)(this.values.length - 1) * (float)this.getWidth()), (int)((float)this.getHeight() * (this.values[i + 1] - max) / (min - max)));
            }
        }
    }

    public class LinkRenderer
    extends DefaultTableCellRenderer {
        @Override
        public void setValue(Object pValue) {
            if (pValue instanceof AnnoAttributeObj && PublicURL.hasUrlForKey((String)((AnnoAttributeObj)pValue).getAttribName())) {
                AnnoAttributeObj anno = (AnnoAttributeObj)pValue;
                if (anno != null && anno.getAttributeAt(0) != null && !anno.getAttributeAt(0).toString().equalsIgnoreCase("na")) {
                    String link = "<html>";
                    link = link + "<a href=\"\">" + anno.getAttributeAt(0);
                    for (int i = 1; i < anno.getAttribCount(); ++i) {
                        link = link + ", " + anno.getAttributeAt(i);
                    }
                    link = link + "</a>";
                    link = link + "</html>";
                    this.setText(link);
                } else {
                    this.setText("NA");
                }
            } else {
                this.setText(pValue.toString());
            }
        }
    }

    public class ColorSparklineRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorSparklineRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            if (color.getClass() == Color.class) {
                Color newColor = (Color)color;
                this.setBackground(newColor);
                if (this.isBordered) {
                    if (isSelected) {
                        if (this.selectedBorder == null) {
                            this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                        }
                        this.setBorder(this.selectedBorder);
                    } else {
                        if (this.unselectedBorder == null) {
                            this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                        }
                        this.setBorder(this.unselectedBorder);
                    }
                }
                return this;
            }
            return new Sparkline((float[])color);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ClusterTableViewer.SAVE_CLUSTER_CMD)) {
                ClusterTableViewer.this.onSaveCluster();
            } else if (command.equals(ClusterTableViewer.SAVE_ALL_CLUSTERS_CMD)) {
                ClusterTableViewer.this.onSaveClusters();
            } else if (command.equals(ClusterTableViewer.STORE_CLUSTER_CMD)) {
                ClusterTableViewer.this.storeCluster();
            } else if (command.equals(ClusterTableViewer.STORE_SELECTED_ROWS_CMD)) {
                ClusterTableViewer.this.storeSelectedRowsAsCluster();
            } else if (command.equals(ClusterTableViewer.SET_DEF_COLOR_CMD)) {
                ClusterTableViewer.this.onSetDefaultColor();
            } else if (command.equals(ClusterTableViewer.LAUNCH_NEW_SESSION_CMD)) {
                ClusterTableViewer.this.launchNewSession();
            } else if (command.equals(ClusterTableViewer.LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD)) {
                ClusterTableViewer.this.launchNewSessionWithSelectedRows();
            } else if (command.equals(ClusterTableViewer.SEARCH_CMD)) {
                ClusterTableViewer.this.searchTable();
            } else if (command.equals(ClusterTableViewer.CLEAR_ALL_CMD)) {
                ClusterTableViewer.this.clusterTable.clearSelection();
            } else if (command.equals(ClusterTableViewer.COPY_CMD)) {
                ClusterTableViewer.this.copyCells();
            } else if (command.equals(ClusterTableViewer.SELECT_ALL_CMD)) {
                ClusterTableViewer.this.clusterTable.selectAll();
            } else if (command.equals(ClusterTableViewer.SORT_ORIG_ORDER_CMD)) {
                ClusterTableViewer.this.sortInOrigOrder();
            } else if (command.equals(ClusterTableViewer.TOGGLE_SCALE)) {
                ClusterTableViewer.this.toggleScale();
            } else if (command.equals(ClusterTableViewer.LINK_TO_URL_CMD)) {
                ClusterTableViewer.this.linkToURL2();
            } else if (command.equals(ClusterTableViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                ClusterTableViewer.this.broadcastClusterGaggle();
            } else if (command.equals(ClusterTableViewer.BROADCAST_SELECTED_MATRIX_GAGGLE_CMD)) {
                ClusterTableViewer.this.broadcastSelectedClusterGaggle();
            } else if (command.equals(ClusterTableViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                ClusterTableViewer.this.broadcastNamelistGaggle();
            } else if (command.equals(ClusterTableViewer.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                ClusterTableViewer.this.broadcastGeneClusterToGenomeBrowser();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ClusterTableViewer.this.getCluster() == null || ClusterTableViewer.this.getCluster().length == 0) {
                ClusterTableViewer.this.xColumn = ClusterTableViewer.this.clusterTable.getSelectedColumn();
                return;
            }
            if (ClusterTableViewer.this.clusterTable.getSelectedRowCount() != 1) {
                ClusterTableViewer.this.urlMenuItem.setEnabled(false);
            } else {
                ClusterTableViewer.this.urlMenuItem.setEnabled(true);
            }
            ClusterTableViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, String field) {
            this.index = index;
            this.field = field;
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClusterTableModel
    extends AbstractTableModel {
        String[] columnNames;
        private String NO_ANNOTATION = "No Annotation Loaded";
        boolean hasAnnotation = true;

        public ClusterTableModel() {
            if (ClusterTableViewer.this.fieldNames.length + ClusterTableViewer.this.auxTitles.length == 0) {
                this.columnNames = new String[2];
                this.columnNames[1] = this.NO_ANNOTATION;
                this.hasAnnotation = false;
            } else {
                int counter;
                this.columnNames = new String[2 + ClusterTableViewer.this.fieldNames.length + ClusterTableViewer.this.auxTitles.length];
                for (counter = 2; counter < ClusterTableViewer.this.fieldNames.length + 2; ++counter) {
                    this.columnNames[counter] = ClusterTableViewer.this.fieldNames[counter - 2];
                }
                for (int i = counter; i < this.columnNames.length; ++i) {
                    this.columnNames[i] = ClusterTableViewer.this.auxTitles[i - counter];
                }
            }
            this.columnNames[0] = "Stored Color";
            this.columnNames[1] = "Expression line";
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ClusterTableViewer.this.getCluster().length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ClusterTableViewer.this.data.getProbeColor(ClusterTableViewer.this.experiment.getGeneIndexMappedToData(ClusterTableViewer.this.getSortedCluster()[row])) == null ? Color.white : ClusterTableViewer.this.data.getProbeColor(ClusterTableViewer.this.experiment.getGeneIndexMappedToData(ClusterTableViewer.this.getSortedCluster()[row]));
            }
            if (col == 1) {
                return ClusterTableViewer.this.data.getExperiment().getValues()[ClusterTableViewer.this.getSortedCluster()[row]];
            }
            if (!this.hasAnnotation) {
                return new Integer(row + 2);
            }
            if (col < ClusterTableViewer.this.fieldNames.length + 2) {
                return ClusterTableViewer.this.data.getElementAnnotationObject(ClusterTableViewer.this.experiment.getGeneIndexMappedToData(ClusterTableViewer.this.getSortedCluster()[row]), ClusterTableViewer.this.fieldNames[col - 2]);
            }
            return String.valueOf(ClusterTableViewer.this.auxData[ClusterTableViewer.this.getSortedCluster()[row]][col - (ClusterTableViewer.this.fieldNames.length + 2)]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

