/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class ClusterTableSearchDialog
extends JDialog {
    JTable table;
    String searchStr;
    int numRows;
    int numCols;
    int numClasses;
    Vector foundRowIndices;
    ButtonGroup searchButtonGroup;
    private JCheckBox matchCaseChkBox;
    private JRadioButton selectIncrButton;
    private JLabel jLabel2;
    private JLabel geneBarContainerLabel;
    private JButton findButton;
    private JPanel geneBarPanel;
    private JButton findNextButton;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JRadioButton selectAllButton;
    private JComboBox jComboBox1;
    private JButton closeButton;
    private ColumnNamesPanel colPanel;

    public ClusterTableSearchDialog(Frame parent, JTable table, boolean modal) {
        super(parent, modal);
        this.table = table;
        this.numRows = table.getRowCount();
        this.numCols = table.getColumnCount();
        this.foundRowIndices = new Vector();
        this.initComponents();
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon((String)"dialog_banner2.gif"));
        this.searchButtonGroup = new ButtonGroup();
        this.searchButtonGroup.add(this.selectAllButton);
        this.searchButtonGroup.add(this.selectIncrButton);
        this.setSize(300, 500);
        this.jComboBox1.setMaximumRowCount(10);
        this.searchStr = null;
        this.jComboBox1.setEditable(true);
        this.jComboBox1.insertItemAt(new String(""), 0);
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTableSearchDialog.this.updateRowCount();
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.runSearch();
                if (ClusterTableSearchDialog.this.foundRowIndices.size() > 0 && ClusterTableSearchDialog.this.selectIncrButton.isSelected()) {
                    ClusterTableSearchDialog.this.findNextButton.setEnabled(true);
                } else {
                    ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                }
            }
        });
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTableSearchDialog.this.updateRowCount();
                ClusterTableSearchDialog.this.findNext();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ClusterTableSearchDialog.this.foundRowIndices.removeAllElements();
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.selectAllButton.setSelected(true);
                ClusterTableSearchDialog.this.matchCaseChkBox.setSelected(true);
                ClusterTableSearchDialog.this.setVisible(false);
            }
        });
        this.jComboBox1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                ClusterTableSearchDialog.this.findNextButton.setEnabled(false);
                ClusterTableSearchDialog.this.findNextButton.repaint();
                ClusterTableSearchDialog.this.foundRowIndices.removeAllElements();
            }

            @Override
            public void focusLost(FocusEvent fe) {
            }
        });
    }

    private void updateRowCount() {
        this.numRows = this.table.getRowCount();
    }

    private boolean runSearch() {
        int[] colsToSearch = this.colPanel.getSelectedCols();
        ListSelectionModel lsm = this.table.getSelectionModel();
        this.foundRowIndices = new Vector();
        boolean selectAll = this.selectAllButton.isSelected();
        boolean found = false;
        this.table.clearSelection();
        this.searchStr = (String)this.jComboBox1.getSelectedItem();
        if (this.searchStr == null || colsToSearch.length == 0 || this.searchStr.equals("")) {
            return found;
        }
        this.jComboBox1.insertItemAt(this.searchStr, 0);
        if (this.matchCaseChkBox.isSelected()) {
            block0: for (int row = 0; row < this.numRows; ++row) {
                for (int i = 0; i < colsToSearch.length; ++i) {
                    if (((String)this.table.getModel().getValueAt(row, colsToSearch[i])).indexOf(this.searchStr) == -1) continue;
                    if (selectAll || !found) {
                        this.table.addRowSelectionInterval(row, row);
                        if (found) continue block0;
                        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
                        found = true;
                        continue block0;
                    }
                    this.foundRowIndices.add(new Integer(row));
                    continue block0;
                }
            }
        } else {
            String upperCaseStr = this.searchStr.toUpperCase();
            block2: for (int row = 0; row < this.numRows; ++row) {
                for (int i = 0; i < colsToSearch.length; ++i) {
                    if (((String)this.table.getModel().getValueAt(row, colsToSearch[i])).toUpperCase().indexOf(upperCaseStr) == -1) continue;
                    if (selectAll || !found) {
                        this.table.addRowSelectionInterval(row, row);
                        if (found) continue block2;
                        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
                        found = true;
                        continue block2;
                    }
                    this.foundRowIndices.add(new Integer(row));
                    continue block2;
                }
            }
        }
        return found;
    }

    public void findNext() {
        if (this.foundRowIndices.isEmpty()) {
            return;
        }
        int row = (Integer)this.foundRowIndices.remove(0);
        this.table.clearSelection();
        this.table.addRowSelectionInterval(row, row);
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        if (this.foundRowIndices.size() == 0) {
            this.findNextButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.colPanel = new ColumnNamesPanel();
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.matchCaseChkBox = new JCheckBox();
        this.selectAllButton = new JRadioButton();
        this.selectIncrButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.findButton = new JButton();
        this.findNextButton = new JButton();
        this.closeButton = new JButton();
        this.geneBarPanel = new JPanel();
        this.geneBarContainerLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Table Search");
        this.setName("Table Search");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ClusterTableSearchDialog.this.closeDialog(evt);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClusterTableSearchDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 80.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.colPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setText("Find what:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.matchCaseChkBox.setText("Match Case");
        this.matchCaseChkBox.setFocusPainted(false);
        this.matchCaseChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClusterTableSearchDialog.this.matchCaseChkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.getContentPane().add((Component)this.matchCaseChkBox, gridBagConstraints);
        this.selectAllButton.setSelected(true);
        this.selectAllButton.setText("Select All Rows Found");
        this.selectAllButton.setToolTipText("Select all finds at once.");
        this.selectAllButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectAllButton, gridBagConstraints);
        this.selectIncrButton.setText("Select Incrementally");
        this.selectIncrButton.setToolTipText("Move throgh finds sequentially.");
        this.selectIncrButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.selectIncrButton, gridBagConstraints);
        this.findButton.setText("Find");
        this.buttonPanel.add(this.findButton);
        this.findNextButton.setText("Find Next");
        this.findNextButton.setEnabled(false);
        this.buttonPanel.add(this.findNextButton);
        this.closeButton.setText("Close");
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.geneBarContainerLabel.setToolTipText("The Institute for Genomic Research");
        this.geneBarContainerLabel.setIconTextGap(0);
        this.geneBarContainerLabel.setIcon(GUIFactory.getIcon((String)"genebar2.gif"));
        this.geneBarPanel.add(this.geneBarContainerLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        this.getContentPane().add((Component)this.geneBarPanel, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.foundRowIndices.removeAllElements();
        this.findNextButton.setEnabled(false);
    }

    private void matchCaseChkBoxActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static void main(String[] args) {
        ClusterTableSearchDialog dialog = new ClusterTableSearchDialog(new Frame(), new JTable(), false);
        dialog.show();
    }

    private class ColumnNamesPanel
    extends JPanel {
        JCheckBox[] columnNameBoxes;
        JButton selectAllButton;
        JButton clearAllButton;

        ColumnNamesPanel() {
            int i;
            this.setBorder(new TitledBorder("Select fields to search"));
            this.setBackground(Color.white);
            String[] columnNames = new String[ClusterTableSearchDialog.this.table.getColumnCount() - 1];
            for (i = 0; i < columnNames.length; ++i) {
                columnNames[i] = ClusterTableSearchDialog.this.table.getColumnName(i + 1);
            }
            this.columnNameBoxes = new JCheckBox[columnNames.length];
            for (i = 0; i < this.columnNameBoxes.length; ++i) {
                this.columnNameBoxes[i] = new JCheckBox(columnNames[i], true);
                this.columnNameBoxes[i].setBackground(Color.white);
            }
            JPanel checkBoxPanel = this.createCheckBoxPanel();
            JScrollPane scroll = new JScrollPane(checkBoxPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.setHorizontalScrollBarPolicy(32);
            JButton selectAllButton = new JButton("Select All");
            JButton clearAllButton = new JButton("Clear All");
            selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < ColumnNamesPanel.this.columnNameBoxes.length; ++i) {
                        ColumnNamesPanel.this.columnNameBoxes[i].setSelected(true);
                    }
                }
            });
            clearAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < ColumnNamesPanel.this.columnNameBoxes.length; ++i) {
                        ColumnNamesPanel.this.columnNameBoxes[i].setSelected(false);
                    }
                }
            });
            GridBagConstraints constraints = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            ClusterTableSearchDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 10);
            gridbag.setConstraints(selectAllButton, constraints);
            this.add(selectAllButton);
            ClusterTableSearchDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(clearAllButton, constraints);
            this.add(clearAllButton);
            ClusterTableSearchDialog.this.buildConstraints(constraints, 0, 1, 2, 1, 100, 90);
            constraints.fill = 1;
            gridbag.setConstraints(scroll, constraints);
            this.add(scroll);
        }

        private JPanel createCheckBoxPanel() {
            JPanel panel1 = new JPanel();
            panel1.setBackground(Color.white);
            GridBagConstraints constraints = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            panel1.setLayout(gridbag);
            constraints.anchor = 17;
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                ClusterTableSearchDialog.this.buildConstraints(constraints, 0, i, 1, 1, 100, 0);
                gridbag.setConstraints(this.columnNameBoxes[i], constraints);
                panel1.add(this.columnNameBoxes[i]);
            }
            return panel1;
        }

        public int[] getSelectedCols() {
            Vector<Integer> selColsVector = new Vector<Integer>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                selColsVector.add(new Integer(i + 1));
            }
            int[] selCols = new int[selColsVector.size()];
            for (int i = 0; i < selCols.length; ++i) {
                selCols[i] = (Integer)selColsVector.get(i);
            }
            return selCols;
        }

        public String[] getSelectedColNames() {
            Vector<String> selColNamesVector = new Vector<String>();
            for (int i = 0; i < this.columnNameBoxes.length; ++i) {
                if (!this.columnNameBoxes[i].isSelected()) continue;
                selColNamesVector.add(ClusterTableSearchDialog.this.table.getColumnName(i + 1));
            }
            String[] selColNames = new String[selColNamesVector.size()];
            for (int i = 0; i < selColNames.length; ++i) {
                selColNames[i] = (String)selColNamesVector.get(i);
            }
            return selColNames;
        }
    }
}

