/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.util.FloatMatrix;

public class ClusterSelector
extends JPanel {
    JTable clusterTable;
    JTable clusterSamplesTable;
    ClusterRepository repository;
    JScrollPane pane;
    JScrollPane scrollPane;
    String clusterType = "Sample";
    ClusterTableModel model;
    FloatMatrix matrix;
    Boolean hasGraph;
    JComboBox[] groupComboBoxes;
    int numGroups;
    SampleTableModel clusterModel;
    JPanel tablePanel;
    String groupName = "Group";

    public ClusterSelector(ClusterRepository repository, int numGroups) {
        this(repository, numGroups, "Group");
    }

    public ClusterSelector(ClusterRepository repository, int numGroups, String groupName) {
        if (repository == null || repository.isEmpty()) {
            this.add((Component)new JLabel("Empty Cluster Repository"), "Center");
            return;
        }
        this.numGroups = numGroups;
        this.repository = repository;
        this.groupName = groupName;
        this.groupComboBoxes = new JComboBox[repository.getClusterSerialCounter()];
        for (int i = 0; i < repository.getClusterSerialCounter(); ++i) {
            this.groupComboBoxes[i] = new JComboBox();
            this.groupComboBoxes[i].addItem("Unassigned");
            this.groupComboBoxes[i].addItem("Group A");
            this.groupComboBoxes[i].addItem("Group B");
            this.groupComboBoxes[i].setSelectedIndex(0);
            this.groupComboBoxes[i].addActionListener(new Listener());
        }
        this.hasGraph = false;
        Font font = new Font("Dialog", 1, 12);
        this.tablePanel = new JPanel(new GridBagLayout());
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.clusterType + " Clusters", 0, 0, font, Color.black));
        this.tablePanel.add((Component)this.createClusterTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.clusterTable.getRowCount() > 0) {
            this.clusterTable.addRowSelectionInterval(0, 0);
        }
        JPanel insetPanel = new JPanel(new GridBagLayout());
        insetPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.clusterModel = new SampleTableModel();
        this.clusterSamplesTable = new JTable(this.clusterModel);
        this.clusterSamplesTable.addMouseListener(new TableListener());
        this.clusterSamplesTable.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.scrollPane = new JScrollPane(this.clusterSamplesTable);
        this.setTableBorderTitle(this.getSelectedCluster().getClusterLabel());
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setTableBorderTitle(String string) {
        Font font = new Font("Dialog", 1, 12);
        this.scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Label: " + string, 0, 0, font, Color.black));
    }

    public void setClusterType(String clusterType) {
        if (this.repository == null) {
            return;
        }
        this.clusterType = clusterType;
        Font font = new Font("Dialog", 1, 12);
        this.tablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), clusterType + " Clusters", 0, 0, font, Color.black));
    }

    public Cluster getSelectedCluster() {
        int serialNumber = ((ClusterTableModel)this.clusterTable.getModel()).getClusterSerialNumber(this.clusterTable.getSelectedRow());
        return this.repository.getCluster(serialNumber);
    }

    public ArrayList<Integer> getGroupSamples(String key) {
        ArrayList<Integer> groupsamps = new ArrayList<Integer>();
        int k = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList list = this.repository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                if (key.equals(this.clusterTable.getModel().getValueAt(k, 8))) {
                    Cluster cluster = list.getClusterAt(j);
                    for (int index = 0; index < cluster.getIndices().length; ++index) {
                        if (groupsamps.contains(cluster.getIndices()[index])) continue;
                        groupsamps.add(cluster.getIndices()[index]);
                    }
                }
                ++k;
            }
        }
        int[] groupA = new int[groupsamps.size()];
        for (int i = 0; i < groupsamps.size(); ++i) {
            groupA[i] = groupsamps.get(i);
        }
        return groupsamps;
    }

    private void setInitialColumnWidths() {
        String[] columnNames = this.model.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            this.setColumnWidth(columnNames[i]);
        }
    }

    private void setColumnWidth(String headerName) {
        int width = 10;
        if (headerName.equals("Serial #")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Source")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Factor")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Cluster Node")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Cluster Label")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 100;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Color")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 40;
            column.setWidth(width);
            column.setPreferredWidth(width);
            column.setMaxWidth(width);
        } else if (headerName.equals("Size")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Remarks")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 35;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Group Assignment")) {
            TableColumn column = this.clusterTable.getColumn(headerName);
            width = 120;
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
    }

    private JScrollPane createClusterTable() {
        Vector<String> header = new Vector<String>();
        header.add("Serial #");
        header.add("Source");
        header.add("Factor");
        header.add("Cluster Node");
        header.add("Cluster Label");
        header.add("Remarks");
        header.add("Size");
        header.add("Color");
        header.add("Group Assignment");
        Vector<Object> dataVector = new Vector<Object>();
        int clustersFound = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList list = this.repository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                Cluster cluster = list.getClusterAt(j);
                dataVector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                dataVector.add(new JLabel(String.valueOf(cluster.getSource())));
                dataVector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                dataVector.add(new JLabel(String.valueOf(cluster.getClusterID())));
                dataVector.add(cluster.getClusterLabel());
                dataVector.add(cluster.getClusterDescription());
                dataVector.add(new JLabel(String.valueOf(cluster.getSize())));
                dataVector.add(cluster.getClusterColor());
                dataVector.add("Unassigned");
                ++clustersFound;
            }
        }
        this.model = new ClusterTableModel(header, dataVector);
        this.clusterTable = new JTable(this.model);
        ClusterCellRenderer renderer = new ClusterCellRenderer();
        this.clusterTable.setDefaultRenderer(Color.class, renderer);
        this.clusterTable.setDefaultRenderer(JLabel.class, renderer);
        this.clusterTable.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.clusterTable.addMouseListener(new TableListener());
        this.clusterTable.setBackground(new Color(225, 225, 225));
        this.clusterTable.setBackground(new Color(225, 225, 225));
        this.clusterTable.setRowHeight(this.clusterTable.getRowHeight() + 10);
        this.clusterTable.setRowSelectionAllowed(true);
        this.clusterTable.getSelectionModel().setSelectionMode(0);
        String[] cbox = new String[this.numGroups + 1];
        cbox[0] = "Unassigned";
        for (int i = 0; i < this.numGroups; ++i) {
            cbox[i + 1] = this.groupName + " " + (i + 1);
        }
        this.clusterTable.getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(new JComboBox<String>(cbox)));
        this.setInitialColumnWidths();
        this.model.addTableModelListener(new TableListener());
        this.clusterTable.setRowHeight(30);
        this.pane = new JScrollPane(this.clusterTable);
        this.pane.setBackground(Color.white);
        this.validate();
        return this.pane;
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class TableListener
    extends MouseAdapter
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            ClusterSelector.this.clusterSamplesTable.repaint();
            ClusterSelector.this.clusterSamplesTable.updateUI();
            ClusterSelector.this.clusterSamplesTable.doLayout();
            ClusterSelector.this.scrollPane.updateUI();
            ClusterSelector.this.setTableBorderTitle(ClusterSelector.this.getSelectedCluster().getClusterLabel());
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }
    }

    public class ClusterCellRenderer
    implements TableCellRenderer {
        private JPanel colorPanel = new JPanel();
        private JLabel label;
        private JTextArea textArea;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ClusterSelector.this.clusterTable.isRowSelected(row)) {
                    this.label.setBackground(ClusterSelector.this.clusterTable.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextArea) {
                this.textArea = (JTextArea)obj;
                this.textArea.setBackground(new Color(225, 225, 225));
                if (ClusterSelector.this.clusterTable.isRowSelected(row)) {
                    this.textArea.setBackground(ClusterSelector.this.clusterTable.getSelectionBackground());
                }
                return this.textArea;
            }
            if (obj instanceof JComboBox) {
                return (JComboBox)obj;
            }
            if (obj instanceof String) {
                String[] str = new String[]{(String)obj};
                JComboBox<String> tempCombo = new JComboBox<String>(str);
                tempCombo.setAlignmentX(0.5f);
                tempCombo.setBackground(Color.white);
                return tempCombo;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;
        private Row[] rows;
        private int colToSort = 0;

        public ClusterTableModel(Vector<String> columnNames, Vector<Object> rowData) {
            this.initializeHeader(columnNames);
            this.initializeData(rowData);
            this.rows = new Row[this.rowData.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        private void initializeHeader(Vector<String> headerNames) {
            this.columnNames = new String[headerNames.size()];
            for (int i = 0; i < headerNames.size(); ++i) {
                this.columnNames[i] = headerNames.elementAt(i);
            }
        }

        private void initializeData(Vector<Object> data) {
            int cnt = 0;
            this.rowData = new Object[data.size() / this.columnNames.length][this.columnNames.length];
            while (cnt < data.size()) {
                for (int j = 0; j < this.columnNames.length; ++j) {
                    this.rowData[cnt / this.columnNames.length][j] = data.elementAt(cnt);
                    ++cnt;
                }
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[this.rows[row].index][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 8;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rowData[this.rows[row].index][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int col) {
            if (col == 7) {
                return Color.class;
            }
            if (col == 4 || col == 5) {
                return String.class;
            }
            return JLabel.class;
        }

        public int getClusterSerialNumber(int row) {
            if (this.isLegalRow(row)) {
                return Integer.parseInt(((JLabel)this.getValueAt(row, 0)).getText());
            }
            return -1;
        }

        public boolean isLegalRow(int row) {
            return row > -1 && row < this.getRowCount();
        }

        public boolean isLegalColumn(int col) {
            return col > -1 && col < this.getColumnCount();
        }

        public void sort(int c) {
            this.colToSort = c;
            Arrays.sort(this.rows);
            ClusterSelector.this.clusterTable.repaint();
        }

        public void sortBy(String key) {
            int col = this.getColumnIndex(key);
            if (col >= 0) {
                this.sort(col);
                this.colToSort = col;
            }
        }

        private int getColumnIndex(String key) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (this.columnNames[i] != key) continue;
                return i;
            }
            return 0;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void hide(String columnName) {
            ClusterSelector.this.clusterTable.removeColumn(ClusterSelector.this.clusterTable.getColumn(columnName));
        }

        public void addColumn(String columnName) {
            ClusterSelector.this.clusterTable.addColumn(new TableColumn(this.getColumnIndex(columnName)));
            this.moveColumnFromEnd(this.getColumnIndex(columnName));
        }

        public void addRow(Vector<Object> data) {
            int i;
            Object[][] newData = new Object[this.rowData.length + 1][this.rowData[0].length];
            for (i = 0; i < this.rowData.length; ++i) {
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[i][j] = this.rowData[i][j];
                }
            }
            for (i = 0; i < this.columnNames.length; ++i) {
                newData[newData.length - 1][i] = data.elementAt(i);
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            for (int i2 = 0; i2 < this.rows.length; ++i2) {
                newRows[i2] = this.rows[i2];
            }
            newRows[newRows.length - 1] = new Row();
            newRows[newRows.length - 1].index = newRows.length - 1;
            this.rows = newRows;
            this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
        }

        public void removeRow(int tableRow) {
            int row = this.rows[tableRow].index;
            Object[][] newData = new Object[this.rowData.length - 1][this.rowData[0].length];
            int currRow = -1;
            for (int i = 0; i < this.rowData.length; ++i) {
                if (i == row) continue;
                ++currRow;
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[currRow][j] = this.rowData[i][j];
                }
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            currRow = -1;
            for (int i = 0; i < this.rows.length; ++i) {
                if (i == row) continue;
                newRows[++currRow] = this.rows[i];
                newRows[currRow].index = currRow;
            }
            this.rows = newRows;
            this.fireTableRowsDeleted(row, row);
        }

        public void removeAllRows() {
            int numRows = this.rows.length;
            this.rowData = new Object[0][0];
            this.rows = new Row[0];
            this.fireTableRowsDeleted(0, numRows);
        }

        private void moveColumnFromEnd(int finalLocation) {
            for (int i = ClusterSelector.this.clusterTable.getColumnCount() - 1; i > finalLocation; --i) {
                ClusterSelector.this.clusterTable.moveColumn(i - 1, i);
            }
        }

        public int getSerialNumber(int row) {
            JLabel serialLabel = (JLabel)this.rowData[row][0];
            return Integer.parseInt(serialLabel.getText());
        }

        public void setClusterColor(int tableRow, Color clusterColor) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Color");
            this.setValueAt(clusterColor, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterLabel(int tableRow, String clusterLabel) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Cluster Label");
            this.setValueAt(clusterLabel, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterDescription(int tableRow, String clusterDescription) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Remarks");
            this.setValueAt(clusterDescription, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        private class Row
        implements Comparable<Object> {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            @Override
            public int compareTo(Object other) {
                Row otherRow = (Row)other;
                Object myObject = ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort];
                Object otherObject = ClusterTableModel.this.rowData[otherRow.index][ClusterTableModel.this.colToSort];
                if (ClusterSelector.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Serial #") || ClusterSelector.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Size")) {
                    Integer i = new Integer(((JLabel)ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort]).getText());
                    return i.compareTo(new Integer(((JLabel)otherObject).getText()));
                }
                if (myObject instanceof Comparable) {
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    class SampleTableModel
    extends AbstractTableModel {
        String[] columnNames;

        public SampleTableModel() {
            this.columnNames = new String[ClusterSelector.this.repository.getFramework().getData().getSampleAnnotationFieldNames().size()];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = (String)ClusterSelector.this.repository.getFramework().getData().getSampleAnnotationFieldNames().get(i);
            }
        }

        @Override
        public int getColumnCount() {
            return ClusterSelector.this.repository.getFramework().getData().getSampleAnnotationFieldNames().size();
        }

        @Override
        public int getRowCount() {
            if (ClusterSelector.this.getSelectedCluster() == null) {
                return 0;
            }
            return ClusterSelector.this.getSelectedCluster().getSize();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col >= 0) {
                try {
                    String before = ClusterSelector.this.repository.getFramework().getData().getCurrentSampleLabelKey();
                    ClusterSelector.this.repository.getFramework().getData().setSampleLabelKey((String)ClusterSelector.this.repository.getFramework().getData().getSampleAnnotationFieldNames().get(col));
                    String value = ClusterSelector.this.repository.getFramework().getData().getSampleName(ClusterSelector.this.repository.getFramework().getData().getExperiment().getSampleIndex(ClusterSelector.this.getSelectedCluster().getIndices()[row]));
                    ClusterSelector.this.repository.getFramework().getData().setSampleLabelKey(before);
                    return value;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "error";
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

