/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.tigr.graph.GraphCanvas;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterList;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.util.FloatMatrix;

public class ClusterBrowser
extends JPanel {
    JTable table;
    ClusterRepository repository;
    JScrollPane pane;
    String clusterTypeStr = "Gene";
    ClusterTableModel model;
    GraphCanvas profileDisplayPanel;
    FloatMatrix matrix;

    public ClusterBrowser(ClusterRepository repository) {
        this.repository = repository;
        if (repository == null || repository.isEmpty()) {
            this.add((Component)new JLabel("Empty Cluster Repository"), "Center");
            return;
        }
        if (!repository.isGeneClusterRepository()) {
            this.clusterTypeStr = "Sample";
        }
        Font font = new Font("Dialog", 1, 12);
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.clusterTypeStr + " Clusters", 0, 0, font, Color.black));
        tablePanel.add((Component)this.initializeTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.table.getRowCount() > 0) {
            this.table.addRowSelectionInterval(0, 0);
        }
        JPanel insetPanel = new JPanel(new GridBagLayout());
        insetPanel.setBorder(BorderFactory.createBevelBorder(1));
        JPanel graphPanel = new JPanel(new GridBagLayout());
        graphPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Cluster Graph", 0, 0, font, Color.black));
        insetPanel.add((Component)this.initializeGraph(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        graphPanel.add((Component)insetPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        graphPanel.setPreferredSize(new Dimension(100, 175));
        graphPanel.setMinimumSize(new Dimension(100, 175));
        this.setLayout(new GridBagLayout());
        this.add((Component)graphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Cluster getSelectedCluster() {
        int serialNumber = ((ClusterTableModel)this.table.getModel()).getClusterSerialNumber(this.table.getSelectedRow());
        return this.repository.getCluster(serialNumber);
    }

    private void setInitialColumnWidths() {
        String[] columnNames = this.model.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            this.setColumnWidth(columnNames[i]);
        }
    }

    private void setColumnWidth(String headerName) {
        int width = 10;
        if (headerName.equals("Serial #")) {
            TableColumn column = this.table.getColumn(headerName);
            width = 50;
            column.setWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Source")) {
            TableColumn column = this.table.getColumn(headerName);
            width = 100;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Color")) {
            TableColumn column = this.table.getColumn(headerName);
            width = 60;
            column.setWidth(width);
            column.setPreferredWidth(width);
        } else if (headerName.equals("Size")) {
            TableColumn column = this.table.getColumn(headerName);
            width = 50;
            column.setWidth(width);
            column.setMaxWidth(width);
            column.setMinWidth(width);
            column.setPreferredWidth(width);
        }
    }

    private GraphCanvas initializeGraph() {
        this.profileDisplayPanel = new GraphCanvas();
        this.profileDisplayPanel.setGraphBounds(0.0, 10.0, -3.0, 3.0);
        this.profileDisplayPanel.setGraphSpacing(20, 20, 20, 20);
        this.profileDisplayPanel.setXAxisValue(0.0);
        this.profileDisplayPanel.setYAxisValue(0.0);
        this.refreshGraph();
        return this.profileDisplayPanel;
    }

    private void refreshGraph() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        if (this.table.getRowCount() <= 0) {
            return;
        }
        int serialNumber = this.model.getClusterSerialNumber(index);
        Cluster cluster = this.repository.getCluster(serialNumber);
        this.matrix = cluster.getExperiment().getMatrix();
        if (this.clusterTypeStr.equals("Sample")) {
            this.matrix = this.matrix.transpose();
        }
        int[] indices = cluster.getExperimentIndices();
        Color clusterColor = cluster.getClusterColor();
        int xRange = this.matrix.getColumnDimension();
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        this.profileDisplayPanel.removeAllGraphElements();
        for (int j = 0; j < indices.length; ++j) {
            int currIndex = indices[j];
            max = Math.max(max, this.getMax(currIndex));
            min = Math.min(min, this.getMin(currIndex));
            float maxRange = Math.max(max, Math.abs(min));
            this.profileDisplayPanel.setGraphBounds(0.0, (double)(xRange - 1), (double)(-maxRange), (double)maxRange);
            for (int i = 0; i < xRange - 1; ++i) {
                if (Float.isNaN(this.matrix.get(currIndex, i)) || Float.isNaN(this.matrix.get(currIndex, i + 1))) continue;
                GraphLine gL = new GraphLine((double)i, (double)this.matrix.get(currIndex, i), (double)(i + 1), (double)this.matrix.get(currIndex, i + 1), clusterColor);
                this.profileDisplayPanel.addGraphElement((GraphElement)gL);
            }
        }
        this.profileDisplayPanel.repaint();
    }

    private float getMax(int index) {
        float max = Float.NEGATIVE_INFINITY;
        int cols = this.matrix.getColumnDimension();
        for (int i = 0; i < cols; ++i) {
            float val = this.matrix.get(index, i);
            if (Float.isNaN(val) || !(max < val)) continue;
            max = val;
        }
        return max;
    }

    private float getMin(int index) {
        float min = Float.POSITIVE_INFINITY;
        int cols = this.matrix.getColumnDimension();
        for (int i = 0; i < cols; ++i) {
            float val = this.matrix.get(index, i);
            if (Float.isNaN(val) || !(min > val)) continue;
            min = val;
        }
        return min;
    }

    private JScrollPane initializeTable() {
        Vector<String> headerVector = new Vector<String>();
        headerVector.add("Serial #");
        headerVector.add("Source");
        headerVector.add("Factor");
        headerVector.add("Cluster Node");
        headerVector.add("Cluster Label");
        headerVector.add("Remarks");
        headerVector.add("Size");
        headerVector.add("Color");
        Vector<Object> dataVector = new Vector<Object>();
        int row = 0;
        for (int i = 0; i < this.repository.size(); ++i) {
            ClusterList list = this.repository.getClusterList(i);
            for (int j = 0; j < list.size(); ++j) {
                Cluster cluster = list.getClusterAt(j);
                dataVector.add(new JLabel(String.valueOf(cluster.getSerialNumber())));
                dataVector.add(new JLabel(String.valueOf(cluster.getSource())));
                dataVector.add(new JLabel(String.valueOf(cluster.getAlgorithmName())));
                dataVector.add(new JLabel(String.valueOf(cluster.getClusterID())));
                dataVector.add(cluster.getClusterLabel());
                dataVector.add(cluster.getClusterDescription());
                dataVector.add(new JLabel(String.valueOf(cluster.getSize())));
                dataVector.add(cluster.getClusterColor());
                ++row;
            }
        }
        this.model = new ClusterTableModel(headerVector, dataVector);
        this.table = new JTable(this.model);
        ClusterCellRenderer renderer = new ClusterCellRenderer();
        this.table.setDefaultRenderer(Color.class, renderer);
        this.table.setDefaultRenderer(JLabel.class, renderer);
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 175));
        this.table.addMouseListener(new TableListener());
        this.table.setBackground(Color.white);
        this.table.setRowHeight(this.table.getRowHeight() + 10);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.setInitialColumnWidths();
        this.model.addTableModelListener(new TableListener());
        this.table.setRowHeight(30);
        this.pane = new JScrollPane(this.table);
        this.pane.setBackground(Color.white);
        this.validate();
        return this.pane;
    }

    public class TableListener
    extends MouseAdapter
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            ClusterBrowser.this.refreshGraph();
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            ClusterBrowser.this.refreshGraph();
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            ClusterBrowser.this.refreshGraph();
        }
    }

    public class ClusterCellRenderer
    implements TableCellRenderer {
        private JPanel colorPanel = new JPanel();
        private JLabel label;
        private JTextArea textArea;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean param, boolean param3, int row, int col) {
            if (obj instanceof Color) {
                this.colorPanel.setBackground((Color)obj);
                return this.colorPanel;
            }
            if (obj instanceof JLabel) {
                this.label = (JLabel)obj;
                this.label.setOpaque(true);
                this.label.setFont(new Font("Arial", 0, 12));
                this.label.setBackground(new Color(225, 225, 225));
                this.label.setForeground(Color.black);
                this.label.setHorizontalAlignment(0);
                if (ClusterBrowser.this.table.isRowSelected(row)) {
                    this.label.setBackground(ClusterBrowser.this.table.getSelectionBackground());
                }
                return this.label;
            }
            if (obj instanceof JTextArea) {
                this.textArea = (JTextArea)obj;
                if (ClusterBrowser.this.table.isRowSelected(row)) {
                    this.textArea.setBackground(ClusterBrowser.this.table.getSelectionBackground());
                }
                return this.textArea;
            }
            this.colorPanel.setBackground(Color.white);
            return this.colorPanel;
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] rowData;
        private Row[] rows;
        private int colToSort = 0;

        public ClusterTableModel(Vector columnNames, Vector rowData) {
            this.initializeHeader(columnNames);
            this.initializeData(rowData);
            this.rows = new Row[this.rowData.length];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        private void initializeHeader(Vector headerNames) {
            this.columnNames = new String[headerNames.size()];
            for (int i = 0; i < headerNames.size(); ++i) {
                this.columnNames[i] = (String)headerNames.elementAt(i);
            }
        }

        private void initializeData(Vector data) {
            int cnt = 0;
            this.rowData = new Object[data.size() / this.columnNames.length][this.columnNames.length];
            while (cnt < data.size()) {
                for (int j = 0; j < this.columnNames.length; ++j) {
                    this.rowData[cnt / this.columnNames.length][j] = data.elementAt(cnt);
                    ++cnt;
                }
            }
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData[this.rows[row].index][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 7;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.rowData[this.rows[row].index][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int col) {
            if (col == 7) {
                return Color.class;
            }
            if (col == 4 || col == 5) {
                return String.class;
            }
            return JLabel.class;
        }

        public int getClusterSerialNumber(int row) {
            if (this.isLegalRow(row)) {
                return Integer.parseInt(((JLabel)this.getValueAt(row, 0)).getText());
            }
            return -1;
        }

        public boolean isLegalRow(int row) {
            return row > -1 && row < this.getRowCount();
        }

        public boolean isLegalColumn(int col) {
            return col > -1 && col < this.getColumnCount();
        }

        public void sort(int c) {
            this.colToSort = c;
            Arrays.sort(this.rows);
            ClusterBrowser.this.table.repaint();
        }

        public void sortBy(String key) {
            int col = this.getColumnIndex(key);
            if (col >= 0) {
                this.sort(col);
                this.colToSort = col;
            }
        }

        private int getColumnIndex(String key) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (this.columnNames[i] != key) continue;
                return i;
            }
            return 0;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void hide(String columnName) {
            ClusterBrowser.this.table.removeColumn(ClusterBrowser.this.table.getColumn(columnName));
        }

        public void addColumn(String columnName) {
            ClusterBrowser.this.table.addColumn(new TableColumn(this.getColumnIndex(columnName)));
            this.moveColumnFromEnd(this.getColumnIndex(columnName));
        }

        public void addRow(Vector data) {
            int i;
            Object[][] newData = new Object[this.rowData.length + 1][this.rowData[0].length];
            for (i = 0; i < this.rowData.length; ++i) {
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[i][j] = this.rowData[i][j];
                }
            }
            for (i = 0; i < this.columnNames.length; ++i) {
                newData[newData.length - 1][i] = data.elementAt(i);
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            for (int i2 = 0; i2 < this.rows.length; ++i2) {
                newRows[i2] = this.rows[i2];
            }
            newRows[newRows.length - 1] = new Row();
            newRows[newRows.length - 1].index = newRows.length - 1;
            this.rows = newRows;
            this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
        }

        public void removeRow(int tableRow) {
            int row = this.rows[tableRow].index;
            Object[][] newData = new Object[this.rowData.length - 1][this.rowData[0].length];
            int currRow = -1;
            for (int i = 0; i < this.rowData.length; ++i) {
                if (i == row) continue;
                ++currRow;
                for (int j = 0; j < this.rowData[i].length; ++j) {
                    newData[currRow][j] = this.rowData[i][j];
                }
            }
            this.rowData = newData;
            Row[] newRows = new Row[this.rowData.length];
            currRow = -1;
            for (int i = 0; i < this.rows.length; ++i) {
                if (i == row) continue;
                newRows[++currRow] = this.rows[i];
                newRows[currRow].index = currRow;
            }
            this.rows = newRows;
            this.fireTableRowsDeleted(row, row);
        }

        public void removeAllRows() {
            int numRows = this.rows.length;
            this.rowData = new Object[0][0];
            this.rows = new Row[0];
            this.fireTableRowsDeleted(0, numRows);
        }

        private void moveColumnFromEnd(int finalLocation) {
            for (int i = ClusterBrowser.this.table.getColumnCount() - 1; i > finalLocation; --i) {
                ClusterBrowser.this.table.moveColumn(i - 1, i);
            }
        }

        public int getSerialNumber(int row) {
            JLabel serialLabel = (JLabel)this.rowData[row][0];
            return Integer.parseInt(serialLabel.getText());
        }

        public void setClusterColor(int tableRow, Color clusterColor) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Color");
            this.setValueAt(clusterColor, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterLabel(int tableRow, String clusterLabel) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Cluster Label");
            this.setValueAt(clusterLabel, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        public void setClusterDescription(int tableRow, String clusterDescription) {
            int row = this.rows[tableRow].index;
            int col = this.getColumnIndex("Remarks");
            this.setValueAt(clusterDescription, row, col);
            this.fireTableCellUpdated(tableRow, col);
        }

        private class Row
        implements Comparable {
            public int index;
            private String myString;
            private String otherString;

            private Row() {
            }

            public int compareTo(Object other) {
                Row otherRow = (Row)other;
                Object myObject = ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort];
                Object otherObject = ClusterTableModel.this.rowData[otherRow.index][ClusterTableModel.this.colToSort];
                if (ClusterBrowser.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Serial #") || ClusterBrowser.this.model.getColumnName(ClusterTableModel.this.colToSort).equals("Size")) {
                    Integer i = new Integer(((JLabel)ClusterTableModel.this.rowData[this.index][ClusterTableModel.this.colToSort]).getText());
                    return i.compareTo(new Integer(((JLabel)otherObject).getText()));
                }
                if (myObject instanceof Comparable) {
                    return ((Comparable)myObject).compareTo(otherObject);
                }
                if (myObject instanceof JLabel) {
                    this.myString = ((JLabel)myObject).getText();
                    this.otherString = ((JLabel)otherObject).getText();
                    return this.myString.compareTo(this.otherString);
                }
                return this.index - otherRow.index;
            }
        }
    }
}

