/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.FloatMatrix;

public class CentroidViewer
extends JPanel
implements IViewer {
    public static final Color DEF_CLUSTER_COLOR = Color.lightGray;
    protected static final Color bColor = new Color(0, 0, 128);
    protected JMenuItem setOverallMaxMenuItem;
    protected JMenuItem setClusterMaxMenuItem;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String SET_Y_TO_EXPERIMENT_MAX_CMD = "set-y-to-exp-max-cmd";
    protected static final String SET_Y_TO_CLUSTER_MAX_CMD = "set-y-to-cluster-max-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String TOGGLE_REF_LINE_CMD = "toggle-ref-line-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    protected Color centroidColor = Color.magenta;
    protected Experiment experiment;
    protected IFramework framework;
    protected IData data;
    protected int clusterIndex;
    protected int[][] clusters;
    protected float maxYValue;
    protected float maxClusterValue;
    protected float maxExperimentValue;
    protected boolean gradientToggle = true;
    protected int yRangeOption;
    public static int USE_EXPERIMENT_MAX = 0;
    public static int USE_CLUSTER_MAX = 1;
    protected boolean drawValues = true;
    protected boolean drawVariances = true;
    protected boolean drawCodes = true;
    private boolean drawMarks = true;
    protected boolean isAntiAliasing = false;
    protected boolean gradientColors;
    protected float[][] means;
    protected float[][] variances;
    protected float[][] codes;
    protected float minValue;
    protected float maxValue;
    protected float midValue = 0.0f;
    public static Color missingColor = new Color(128, 128, 128);
    public static BufferedImage posColorImage;
    public static BufferedImage negColorImage;
    public boolean useDoubleGradient = true;
    protected boolean drawReferenceBlock = false;
    protected int xref = 0;
    protected int yref = 0;
    protected int currExpRefLine;
    protected boolean showRefLine = false;
    private int exptID = 0;
    protected JPopupMenu popup;
    int validN;

    public CentroidViewer() {
    }

    public CentroidViewer(Experiment experiment, int[][] clusters, float[][] variances, float[][] means, float[][] codes) {
        this.experiment = experiment;
        this.clusters = clusters;
        this.setVariances(variances);
        this.setMeans(means);
        this.setCodes(codes);
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.addMouseMotionListener(new GraphListener());
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters)});
    }

    public CentroidViewer(Experiment experiment, ClusterWrapper clusters) {
        this(experiment, clusters.getClusters());
    }

    public CentroidViewer(Experiment experiment, int[][] clusters) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.clusters = clusters;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.maxExperimentValue = experiment.getMaxAbsValue();
        this.yRangeOption = USE_EXPERIMENT_MAX;
        this.addMouseMotionListener(new GraphListener());
        this.means = this.getMeans((int[][])clusters).A;
        this.variances = this.getVariances((int[][])clusters, (FloatMatrix)this.getMeans((int[][])clusters)).A;
        PopupListener listener = new PopupListener();
        this.popup = this.createJPopupMenu(listener);
        this.getContentComponent().addMouseListener(listener);
    }

    public CentroidViewer(IFramework framework, int mode) {
        this(framework.getData().getExperiment(), CentroidViewer.defGenesOrder(framework.getData().getExperiment().getNumberOfGenes()));
        this.means = this.getMeans((int[][])this.clusters).A;
        this.variances = this.getVariances((int[][])this.clusters, (FloatMatrix)this.getMeans((int[][])this.clusters)).A;
        this.setMode(mode);
        this.onSelected(framework);
    }

    public CentroidViewer(IFramework framework) {
        this(framework.getData().getExperiment(), CentroidViewer.defGenesOrder(framework.getData().getExperiment().getNumberOfGenes()));
        this.means = this.getMeans((int[][])this.clusters).A;
        this.variances = this.getVariances((int[][])this.clusters, (FloatMatrix)this.getMeans((int[][])this.clusters)).A;
        this.framework = framework;
        this.onSelected(framework);
    }

    private static int[][] defGenesOrder(int size) {
        int[][] order = new int[1][size];
        for (int i = 0; i < order[0].length; ++i) {
            order[0][i] = i;
        }
        return order;
    }

    private FloatMatrix getMeans(int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, this.experiment.getNumberOfSamples());
        for (int i = 0; i < clusters.length; ++i) {
            FloatMatrix mean = this.getMean(clusters[i]);
            means.A[i] = mean.A[0];
        }
        return means;
    }

    private FloatMatrix getMean(int[] cluster) {
        FloatMatrix mean = new FloatMatrix(1, this.experiment.getNumberOfSamples());
        int n = cluster.length;
        int denom = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            float currentMean = 0.0f;
            denom = 0;
            for (int j = 0; j < n; ++j) {
                float value = this.experiment.get(cluster[j], i);
                if (Float.isNaN(value)) continue;
                currentMean += value;
                ++denom;
            }
            mean.set(0, i, currentMean / (float)denom);
        }
        return mean;
    }

    private FloatMatrix getVariances(int[][] clusters, FloatMatrix means) {
        int rows = means.getRowDimension();
        int columns = means.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                variances.set(row, column, this.getSampleVariance(clusters[row], column, means.get(row, column)));
            }
        }
        return variances;
    }

    private float getSampleVariance(int[] cluster, int column, float mean) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(cluster, column, mean) / (float)(this.validN - 1));
    }

    private float getSampleNormalizedSum(int[] cluster, int column, float mean) {
        int size = cluster.length;
        float sum = 0.0f;
        this.validN = 0;
        for (int i = 0; i < size; ++i) {
            float value = this.experiment.get(cluster[i], column);
            if (Float.isNaN(value)) continue;
            sum = (float)((double)sum + Math.pow(value - mean, 2.0));
            ++this.validN;
        }
        return sum;
    }

    @Override
    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.maxExperimentValue = this.experiment.getMaxAbsValue();
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public void setMeans(float[][] means) {
        this.means = means;
    }

    public void toggleGradient() {
        this.gradientToggle = !this.gradientToggle;
    }

    public void setVariances(float[][] variances) {
        this.variances = variances;
    }

    public void setCodes(float[][] codes) {
        this.codes = codes;
    }

    public void setDrawMarks(boolean draw) {
        this.drawMarks = draw;
    }

    public void setDrawVariances(boolean draw) {
        this.drawVariances = draw;
    }

    public void setDrawValues(boolean draw) {
        this.drawValues = draw;
    }

    public void setDrawCodes(boolean draw) {
        this.drawCodes = draw;
    }

    public void setAntiAliasing(boolean value) {
        this.isAntiAliasing = value;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.setData(framework.getData());
        this.setAntiAliasing(framework.getDisplayMenu().isAntiAliasing());
        Object userObject = framework.getUserObject();
        if (userObject != null) {
            if (userObject instanceof CentroidUserObject) {
                this.setClusterIndex(((CentroidUserObject)userObject).getClusterIndex());
                this.setMode(((CentroidUserObject)userObject).getMode());
            } else {
                this.setMode((Integer)userObject);
            }
        }
        this.updateValues(this.getCluster());
        this.maxValue = framework.getDisplayMenu().getMaxRatioScale();
        this.minValue = framework.getDisplayMenu().getMinRatioScale();
        this.midValue = framework.getDisplayMenu().getMidRatioValue();
        posColorImage = framework.getDisplayMenu().getPositiveGradientImage();
        negColorImage = framework.getDisplayMenu().getNegativeGradientImage();
        this.useDoubleGradient = framework.getDisplayMenu().getUseDoubleGradient();
        this.setGradient(framework.getDisplayMenu().getColorGradientState());
        this.repaint();
    }

    public boolean checkGradient() {
        boolean temp = true;
        for (int i = 0; i < this.clusters.length; ++i) {
            for (int j = 0; j < this.clusters[i].length; ++j) {
                try {
                    if (this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.clusters[i][j])) == null) continue;
                    temp = false;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return temp;
    }

    public void setGradient(boolean g) {
        this.gradientColors = g;
        this.gradientToggle = g;
    }

    private Color getColor(float value) {
        int rgb;
        if (Float.isNaN(value)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float maximum = value < this.midValue ? this.minValue : this.maxValue;
            int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
            if (colorIndex < 0) {
                colorIndex = -colorIndex;
            }
            colorIndex = colorIndex > 255 ? 255 : colorIndex;
            rgb = value < this.midValue ? negColorImage.getRGB(255 - colorIndex, 0) : posColorImage.getRGB(colorIndex, 0);
        } else {
            float span = this.maxValue - this.minValue;
            int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
            rgb = posColorImage.getRGB(colorIndex, 0);
        }
        return new Color(rgb);
    }

    public void setData(IData data) {
        this.data = data;
    }

    public void setClusterIndex(int clusterIndex) {
        this.clusterIndex = clusterIndex;
        this.updateValues(this.getCluster());
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    protected int getProbe(int row) {
        return this.clusters[this.clusterIndex][row];
    }

    public void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.setDrawVariances(true);
                this.setDrawValues(false);
                break;
            }
            case 1: {
                this.setDrawVariances(false);
                this.setDrawValues(true);
            }
        }
    }

    private void updateValues(int[] cluster) {
        this.maxClusterValue = this.calculateMaxValue(cluster);
    }

    public void setClusterColor(Color color) {
        if (color == null) {
            this.framework.removeCluster(this.getArrayMappedToData(), this.experiment, 0);
        }
    }

    public void storeCluster() {
        this.framework.storeCluster(this.getArrayMappedToData(), this.experiment, 0);
        this.onDataChanged(this.data);
    }

    public void setClusters(int[][] mat) {
        this.clusters = new int[mat.length][mat[0].length];
        for (int i = 0; i < mat.length; ++i) {
            for (int j = 0; j < mat[i].length; ++j) {
                this.clusters[i][j] = mat[i][j];
            }
        }
        this.means = this.getMeans((int[][])this.clusters).A;
        this.variances = this.getVariances((int[][])this.clusters, (FloatMatrix)this.getMeans((int[][])this.clusters)).A;
        this.repaint();
        this.updateUI();
    }

    public void launchNewSession() {
        this.framework.launchNewMAV(this.getArrayMappedToData(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
    }

    private int[] getArrayMappedToData() {
        int[] clusterIndices = this.getCluster();
        if (clusterIndices == null || clusterIndices.length < 1) {
            return clusterIndices;
        }
        int[] dataIndices = new int[clusterIndices.length];
        for (int i = 0; i < clusterIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(clusterIndices[i]);
        }
        return dataIndices;
    }

    public void setYRangeOption(int option) {
        this.yRangeOption = option != USE_EXPERIMENT_MAX && option != USE_CLUSTER_MAX ? USE_EXPERIMENT_MAX : option;
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle rect = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        this.paint((Graphics2D)g, rect, true);
    }

    public void subPaint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        super.paint(g);
    }

    public void paint(Graphics2D g, Rectangle rect, boolean drawMarks) {
        int i;
        super.paint(g);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int left = rect.x;
        int top = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (width < 5 || height < 5) {
            return;
        }
        int zeroValue = top + Math.round((float)height / 2.0f);
        int numberOfSamples = this.experiment.getNumberOfSamples();
        if (this.yRangeOption == USE_EXPERIMENT_MAX) {
            this.maxYValue = this.maxExperimentValue;
        } else if (this.yRangeOption == USE_CLUSTER_MAX) {
            this.maxYValue = this.maxClusterValue;
        }
        if (this.maxYValue == 0.0f) {
            this.maxYValue = 1.0f;
        }
        float factor = (float)height / (2.0f * this.maxYValue);
        float stepX = (float)width / (float)(numberOfSamples - 1);
        int stepsY = (int)this.maxYValue + 1;
        if (this.drawVariances) {
            g.setColor(bColor);
            for (i = 0; i < numberOfSamples; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i]) || Float.isNaN(this.variances[this.clusterIndex][i]) || this.variances[this.clusterIndex][i] < 0.0f) continue;
                g.drawLine(left + Math.round((float)i * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i] - this.variances[this.clusterIndex][i]) * factor), left + Math.round((float)i * stepX), zeroValue - Math.round((this.means[this.clusterIndex][i] + this.variances[this.clusterIndex][i]) * factor));
                g.drawLine(left + Math.round((float)i * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i] - this.variances[this.clusterIndex][i]) * factor), left + Math.round((float)i * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i] - this.variances[this.clusterIndex][i]) * factor));
                g.drawLine(left + Math.round((float)i * stepX) - 3, zeroValue - Math.round((this.means[this.clusterIndex][i] + this.variances[this.clusterIndex][i]) * factor), left + Math.round((float)i * stepX) + 3, zeroValue - Math.round((this.means[this.clusterIndex][i] + this.variances[this.clusterIndex][i]) * factor));
            }
        }
        if (this.drawValues) {
            boolean coloredClusters = false;
            Color color = null;
            float maxLineHeight = this.maxExperimentValue * factor / 20.0f;
            boolean R = false;
            boolean G = false;
            boolean B = false;
            for (int sample = 0; sample < numberOfSamples - 1; ++sample) {
                for (int probe = 0; probe < this.getCluster().length; ++probe) {
                    float fValue = this.experiment.get(this.getProbe(probe), sample);
                    float sValue = this.experiment.get(this.getProbe(probe), sample + 1);
                    if (Float.isNaN(fValue) || Float.isNaN(sValue)) continue;
                    if (!this.gradientColors) {
                        color = this.data.getProbeColor(this.experiment.getGeneIndexMappedToData(this.getProbe(probe)));
                        color = color == null ? DEF_CLUSTER_COLOR : color;
                        g.setColor(color);
                        g.drawLine(left + Math.round((float)sample * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(sample + 1) * stepX), zeroValue - Math.round(sValue * factor));
                        continue;
                    }
                    float lineHeight = (sValue - fValue) * factor;
                    int intervalNumber = Math.abs(lineHeight) > maxLineHeight ? Math.abs((int)(lineHeight / maxLineHeight)) : 1;
                    float yInterval = lineHeight / (float)intervalNumber;
                    for (int i2 = 0; i2 < intervalNumber; ++i2) {
                        g.setColor(this.getColor(fValue + (float)i2 * yInterval / factor));
                        g.drawLine(left + Math.round((float)sample * stepX + (float)i2 / (float)intervalNumber * stepX), zeroValue - Math.round(fValue * factor + (float)i2 * yInterval), left + Math.round((float)sample * stepX + ((float)i2 + 1.0f) / (float)intervalNumber * stepX), zeroValue - Math.round(fValue * factor + ((float)i2 + 1.0f) * yInterval));
                    }
                }
            }
        }
        if (this.drawCodes && this.codes != null && this.clusters[this.clusterIndex].length > 0) {
            g.setColor(Color.blue);
            for (i = 0; i < numberOfSamples - 1; ++i) {
                g.drawLine(left + Math.round((float)i * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i] * factor), left + Math.round((float)(i + 1) * stepX), zeroValue - Math.round(this.codes[this.clusterIndex][i + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawLine(left, zeroValue, left + width, zeroValue);
        if (this.getCluster() != null && this.getCluster().length > 0) {
            g.setColor(this.centroidColor);
            for (i = 0; i < numberOfSamples - 1; ++i) {
                if (Float.isNaN(this.means[this.clusterIndex][i]) || Float.isNaN(this.means[this.clusterIndex][i + 1])) continue;
                g.drawLine(left + Math.round((float)i * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i] * factor), left + Math.round((float)(i + 1) * stepX), zeroValue - Math.round(this.means[this.clusterIndex][i + 1] * factor));
            }
        }
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        for (i = 1; i < numberOfSamples - 1; ++i) {
            g.drawLine(left + Math.round((float)i * stepX), top + height - 5, left + Math.round((float)i * stepX), top + height);
            g.drawLine(left + Math.round((float)i * stepX), top, left + Math.round((float)i * stepX), top + 5);
        }
        for (i = 1; i < stepsY; ++i) {
            g.drawLine(left, zeroValue - Math.round((float)i * factor), left + 5, zeroValue - Math.round((float)i * factor));
            g.drawLine(left, zeroValue + Math.round((float)i * factor), left + 5, zeroValue + Math.round((float)i * factor));
        }
        g.setColor(bColor);
        if (drawMarks) {
            FontMetrics metrics = g.getFontMetrics();
            for (int i3 = 1; i3 < stepsY; ++i3) {
                String str = String.valueOf(i3);
                int strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 - Math.round((float)i3 * factor));
                str = String.valueOf(-i3);
                strWidth = metrics.stringWidth(str);
                g.drawString(str, left - 10 - strWidth, zeroValue + 5 + Math.round((float)i3 * factor));
            }
            g.rotate(-1.5707963267948966);
            int max_name_width = this.getNamesWidth(metrics);
            for (int i4 = 0; i4 < numberOfSamples; ++i4) {
                g.drawString(this.data.getSampleName(this.experiment.getSampleIndex(i4)), -height - top - 10 - max_name_width, left + Math.round((float)i4 * stepX) + 3);
            }
            g.rotate(1.5707963267948966);
        }
        if (this.getCluster() != null && this.getCluster().length > 0 && this.drawVariances) {
            g.setColor(bColor);
            for (int i5 = 0; i5 < numberOfSamples; ++i5) {
                if (Float.isNaN(this.means[this.clusterIndex][i5])) continue;
                g.fillOval(left + Math.round((float)i5 * stepX) - 3, zeroValue - Math.round(this.means[this.clusterIndex][i5] * factor) - 3, 6, 6);
            }
        }
        if (this.showRefLine && this.drawReferenceBlock) {
            Composite initComposite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g.setColor(Color.yellow);
            g.fillRect(this.xref - 3, 20, 7, height);
            g.setComposite(initComposite);
            g.setColor(Color.blue);
            g.drawLine(this.xref, 20, this.xref, height + 20);
            this.framework.setStatusText("Sample= " + this.data.getSampleName(this.experiment.getSampleIndex(this.currExpRefLine)) + ",   mean = " + this.means[this.clusterIndex][this.currExpRefLine] + ",   sd = " + this.variances[this.clusterIndex][this.currExpRefLine]);
        }
        g.setColor(bColor);
        if (this.getCluster() == null || this.getCluster().length == 0) {
            g.drawString("No Genes", left + 10, top + 20);
        } else {
            g.drawString(this.getCluster().length + " Genes", left + 10, top + 20);
        }
    }

    @Override
    public JComponent getHeaderComponent() {
        return null;
    }

    @Override
    public void onDataChanged(IData data) {
        this.setData(data);
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
        this.setAntiAliasing(menu.isAntiAliasing());
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        posColorImage = menu.getPositiveGradientImage();
        negColorImage = menu.getNegativeGradientImage();
        this.setGradient(menu.getColorGradientState());
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.repaint();
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    private float calculateMaxValue(int[] probes) {
        float max = 0.0f;
        int samples = this.experiment.getNumberOfSamples();
        for (int sample = 0; sample < samples; ++sample) {
            for (int probe = 0; probe < probes.length; ++probe) {
                float value = this.experiment.get(probes[probe], sample);
                if (Float.isNaN(value)) continue;
                max = Math.max(max, Math.abs(value));
            }
        }
        return max;
    }

    protected int getNamesWidth(FontMetrics metrics) {
        int maxWidth = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            maxWidth = Math.max(maxWidth, metrics.stringWidth(this.data.getSampleName(this.experiment.getSampleIndex(i))));
        }
        return maxWidth;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Store cluster", GUIFactory.getIcon((String)"new16.gif"));
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon((String)"launch_new_mav.gif"));
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Delete public cluster", GUIFactory.getIcon((String)"delete16.gif"));
        menuItem.setActionCommand(SET_DEF_COLOR_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save all clusters...", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        this.setOverallMaxMenuItem = new JMenuItem("Set Y to overall max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setOverallMaxMenuItem.setActionCommand(SET_Y_TO_EXPERIMENT_MAX_CMD);
        this.setOverallMaxMenuItem.addActionListener(listener);
        this.setOverallMaxMenuItem.setEnabled(false);
        menu.add(this.setOverallMaxMenuItem);
        this.setClusterMaxMenuItem = new JMenuItem("Set Y to cluster max...", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.setClusterMaxMenuItem.setActionCommand(SET_Y_TO_CLUSTER_MAX_CMD);
        this.setClusterMaxMenuItem.addActionListener(listener);
        menu.add(this.setClusterMaxMenuItem);
        menuItem = new JMenuItem("Toggle reference line...");
        menuItem.setActionCommand(TOGGLE_REF_LINE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_NAMELIST_GAGGLE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Matrix to Genome Browser", GUIFactory.getIcon((String)"gaggle_icon_16.gif"));
        menuItem.setActionCommand(BROADCAST_MATRIX_GENOME_BROWSER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public int getViewerType() {
        return 0;
    }

    protected void onSaveClusters() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getClusters());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save clusters!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSaveCluster() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        try {
            ExperimentUtil.saveExperiment(frame, this.getExperiment(), this.getData(), this.getCluster());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(frame, "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    protected void onSetDefaultColor() {
        this.setClusterColor(null);
    }

    protected JPopupMenu createJPopupMenu(PopupListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    private void onSetColor() {
        Frame frame = JOptionPane.getFrameForComponent(this.getContentComponent());
        Color newColor = JColorChooser.showDialog(frame, "Choose color", DEF_CLUSTER_COLOR);
        if (newColor != null) {
            this.setClusterColor(newColor);
        }
    }

    public void broadcastClusterGaggle() {
        int[] temp = this.getCluster();
        Experiment e = this.getExperiment();
        if (temp == null) {
            System.out.println("getCluster returns null");
        }
        if (e == null) {
            System.out.println("getExperiment returns null");
        }
        if (this.framework == null) {
            System.out.println(this.toString() + ": framework is null");
        }
        this.framework.broadcastGeneCluster(this.getExperiment(), this.getCluster(), null);
    }

    public void broadcastNamelistGaggle() {
        this.framework.broadcastNamelist(this.getExperiment(), this.getCluster());
    }

    public void broadcastGeneClusterToGenomeBrowser() {
        this.framework.broadcastGeneClusterToGenomeBrowser(this.getExperiment(), this.getCluster(), null);
    }

    public class PopupListener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(CentroidViewer.SAVE_CLUSTER_CMD)) {
                CentroidViewer.this.onSaveCluster();
            } else if (command.equals(CentroidViewer.SAVE_ALL_CLUSTERS_CMD)) {
                CentroidViewer.this.onSaveClusters();
            } else if (command.equals(CentroidViewer.STORE_CLUSTER_CMD)) {
                CentroidViewer.this.storeCluster();
            } else if (command.equals(CentroidViewer.SET_DEF_COLOR_CMD)) {
                CentroidViewer.this.onSetDefaultColor();
            } else if (command.equals(CentroidViewer.SET_Y_TO_EXPERIMENT_MAX_CMD)) {
                CentroidViewer.this.yRangeOption = USE_EXPERIMENT_MAX;
                CentroidViewer.this.setClusterMaxMenuItem.setEnabled(true);
                CentroidViewer.this.setOverallMaxMenuItem.setEnabled(false);
                CentroidViewer.this.repaint();
            } else if (command.equals(CentroidViewer.SET_Y_TO_CLUSTER_MAX_CMD)) {
                CentroidViewer.this.yRangeOption = USE_CLUSTER_MAX;
                CentroidViewer.this.setClusterMaxMenuItem.setEnabled(false);
                CentroidViewer.this.setOverallMaxMenuItem.setEnabled(true);
                CentroidViewer.this.repaint();
            } else if (command.equals(CentroidViewer.LAUNCH_NEW_SESSION_CMD)) {
                CentroidViewer.this.launchNewSession();
            } else if (command.equals(CentroidViewer.TOGGLE_REF_LINE_CMD)) {
                CentroidViewer.this.showRefLine = !CentroidViewer.this.showRefLine;
                CentroidViewer.this.repaint();
            } else if (command.equals(CentroidViewer.BROADCAST_MATRIX_GAGGLE_CMD)) {
                CentroidViewer.this.broadcastClusterGaggle();
            } else if (command.equals(CentroidViewer.BROADCAST_NAMELIST_GAGGLE_CMD)) {
                CentroidViewer.this.broadcastNamelistGaggle();
            } else if (command.equals(CentroidViewer.BROADCAST_MATRIX_GENOME_BROWSER_CMD)) {
                CentroidViewer.this.broadcastGeneClusterToGenomeBrowser();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || CentroidViewer.this.getCluster() == null || CentroidViewer.this.getCluster().length == 0) {
                return;
            }
            CentroidViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public class GraphListener
    extends MouseAdapter
    implements MouseMotionListener {
        int x = 0;
        int y = 0;

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            if (!CentroidViewer.this.showRefLine) {
                CentroidViewer.this.framework.setStatusText("TIGR MultiExperiment Viewer");
                return;
            }
            int newX = me.getX();
            int newY = me.getY();
            int numberOfSamples = CentroidViewer.this.experiment.getNumberOfSamples();
            if (newX < 40 || newX > CentroidViewer.this.getWidth() - 40 || numberOfSamples <= 1) {
                CentroidViewer.this.drawReferenceBlock = false;
                CentroidViewer.this.framework.setStatusText("TIGR MultiExperiment Viewer");
                CentroidViewer.this.repaint();
                return;
            }
            CentroidViewer.this.drawReferenceBlock = true;
            CentroidViewer.this.currExpRefLine = Math.round((float)(numberOfSamples - 1) * (((float)newX - 40.0f) / ((float)CentroidViewer.this.getWidth() - 80.0f)));
            CentroidViewer.this.xref = newX;
            CentroidViewer.this.yref = newY;
            CentroidViewer.this.repaint();
        }
    }
}

