/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.util.FloatMatrix;

public class CentroidExperimentHeader
extends JPanel {
    private String vectorString;
    private CentroidVectorPanel centroidVectorPanel;
    private int[][] clusters;
    protected int clusterIndex = 0;
    private int currHeight;
    private int currWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private ExperimentHeader expHeader;
    private BufferedImage posColorImage;
    private BufferedImage negColorImage;
    private boolean useDoubleGradient = true;
    private FloatMatrix centroidData;
    private FloatMatrix mainCentroidData;

    public CentroidExperimentHeader(JComponent expHeader, FloatMatrix centroidData, int[][] clusters, String vectorString) {
        this.setLayout(new GridBagLayout());
        this.centroidData = centroidData;
        this.setBackground(Color.white);
        this.clusters = clusters;
        this.expHeader = (ExperimentHeader)expHeader;
        this.mainCentroidData = centroidData;
        this.centroidVectorPanel = new CentroidVectorPanel(centroidData, this.insets);
        this.add((Component)expHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centroidVectorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.vectorString = vectorString;
        this.currHeight = 0;
        this.currWidth = 0;
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new CentroidExperimentHeaderPersistenceDelegate();
    }

    public JComponent getExpHeader() {
        return this.expHeader;
    }

    public FloatMatrix getCentroidData() {
        return this.centroidData;
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    public String getVectorString() {
        return this.vectorString;
    }

    public void setExperiment(Experiment e) {
        this.expHeader.setExperiment(e);
    }

    private CentroidExperimentHeader() {
    }

    public int getCurrWidth() {
        return this.currWidth;
    }

    public int getCurrHeight() {
        return this.currHeight + this.expHeader.getHeight();
    }

    public void setClusterIndex(int index) {
        this.clusterIndex = index;
        this.centroidVectorPanel.setCurrentCluster(index);
    }

    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public void updateSize(Dimension size) {
        this.centroidVectorPanel.updateSize(size);
    }

    public void setCurrentCluster(int cluster) {
        this.clusterIndex = cluster;
        this.centroidVectorPanel.setCurrentCluster(cluster);
    }

    public void setDrawBorders(boolean draw) {
        this.centroidVectorPanel.setDrawBorders(draw);
    }

    public void setValues(float minValue, float maxValue) {
        this.centroidVectorPanel.setValues(minValue, maxValue);
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.centroidVectorPanel.setValues(minValue, midValue, maxValue);
    }

    public void setNegAndPosColorImages(BufferedImage neg, BufferedImage pos) {
        this.negColorImage = neg;
        this.posColorImage = pos;
    }

    public void setMissingColor(Color color) {
        this.centroidVectorPanel.setMissingColor(color);
    }

    public void setAntiAliasing(boolean value) {
        this.centroidVectorPanel.setAntiAliasing(value);
    }

    public class CentroidVectorPanel
    extends JPanel {
        private FloatMatrix codes;
        private int cluster;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private float midValue = 0.0f;
        private Dimension elementSize = new Dimension(20, 5);
        private boolean drawBorders = true;
        private boolean isAntiAliasing = false;
        private Color missingColor = new Color(128, 128, 128);
        private Insets insets = new Insets(0, 0, 0, 0);

        private CentroidVectorPanel(FloatMatrix codes, Insets insets) {
            this.setBackground(Color.white);
            this.codes = codes;
            this.insets = insets;
        }

        private CentroidVectorPanel() {
        }

        public void setMissingColor(Color color) {
            this.missingColor = color;
        }

        public void setCurrentCluster(int cluster) {
            this.cluster = cluster;
        }

        public void setDrawBorders(boolean draw) {
            this.drawBorders = draw;
        }

        public void setAntiAliasing(boolean value) {
            this.isAntiAliasing = value;
        }

        public void setValues(float minValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
        }

        public void setValues(float minValue, float midValue, float maxValue) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.midValue = midValue;
        }

        public int getCurrWidth() {
            return CentroidExperimentHeader.this.currWidth;
        }

        public void setLeftInset(int leftMargin) {
            this.insets.left = leftMargin;
        }

        public int getCurrHeight() {
            return CentroidExperimentHeader.this.currHeight;
        }

        public void updateSize(Dimension size) {
            this.elementSize = new Dimension(size);
            this.setFont(new Font("monospaced", 0, size.height));
            Graphics2D g = (Graphics2D)this.getGraphics();
            int strWidth = 0;
            if (g != null) {
                if (this.isAntiAliasing) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                FontMetrics metrics = g.getFontMetrics();
                strWidth = metrics.stringWidth(CentroidExperimentHeader.this.vectorString) + 10;
            }
            int width = size.width * this.codes.getColumnDimension() + strWidth + this.insets.left + 10;
            int height = size.height + 10;
            CentroidExperimentHeader.this.currWidth = width;
            CentroidExperimentHeader.this.currHeight = height;
            this.setMinimumSize(new Dimension(width, height));
            this.setPreferredSize(new Dimension(width, height));
            this.setSize(width, height);
            this.validate();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (CentroidExperimentHeader.this.getCluster().length < 1) {
                return;
            }
            if (this.isAntiAliasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            int samples = this.codes.getColumnDimension();
            for (int i = 0; i < samples; ++i) {
                this.fillRectAt(g, i, this.getColor(this.codes.get(this.cluster, i)));
                if (!this.drawBorders) continue;
                this.drawRectAt(g, i, Color.black);
            }
            g.setColor(Color.black);
            g.drawString(CentroidExperimentHeader.this.vectorString, this.elementSize.width * samples + 10 + this.insets.left, this.elementSize.height);
        }

        private void fillRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.fillRect(sample * this.elementSize.width + this.insets.left, 0, this.elementSize.width, this.elementSize.height);
        }

        private void drawRectAt(Graphics g, int sample, Color color) {
            g.setColor(color);
            g.drawRect(sample * this.elementSize.width + this.insets.left, 0, this.elementSize.width - 1, this.elementSize.height - 1);
        }

        private Color getColor(float value) {
            int rgb;
            if (Float.isNaN(value)) {
                return this.missingColor;
            }
            if (CentroidExperimentHeader.this.useDoubleGradient) {
                float maximum = value < this.midValue ? this.minValue : this.maxValue;
                int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
                if (colorIndex < 0) {
                    colorIndex = -colorIndex;
                }
                colorIndex = colorIndex > 255 ? 255 : colorIndex;
                rgb = value < this.midValue ? CentroidExperimentHeader.this.negColorImage.getRGB(255 - colorIndex, 0) : CentroidExperimentHeader.this.posColorImage.getRGB(colorIndex, 0);
            } else {
                float span = this.maxValue - this.minValue;
                int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
                rgb = CentroidExperimentHeader.this.posColorImage.getRGB(colorIndex, 0);
            }
            return new Color(rgb);
        }
    }

    private static class CentroidExperimentHeaderPersistenceDelegate
    extends PersistenceDelegate {
        private CentroidExperimentHeaderPersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object o, Encoder encoder) {
            CentroidExperimentHeader oldInstance = (CentroidExperimentHeader)o;
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{oldInstance.getExpHeader(), oldInstance.getCentroidData(), oldInstance.getClusters(), oldInstance.getVectorString()});
        }

        public void initialize(Class type, Object oldInstance, Object newInstance, Encoder encoder) {
        }
    }
}

