/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class BoxChartViewer
extends JPanel
implements IViewer {
    private static final long serialVersionUID = 1L;
    private JDialog scaleDialog;
    private boolean scaleChanged;
    private int[][] clusters;
    private String[] clusterNames;
    private Color[] clusterColors;
    private int[] geneIndices;
    private Experiment experiment;
    private IFramework framework;
    private int exptID = 0;
    private int clusterCount;
    Color unselected = new Color(200, 200, 255);
    Color selectedRegion = new Color(170, 170, 255);
    private int chartHeight = 250;
    private int chartTopHeight = 75;
    private int chartIncrement = 100;
    private int chartleft = 100;
    private int chartGap = 120;
    private boolean showGridlines = false;
    private boolean autoScale = true;
    private boolean aggregateGeneCluster = false;
    private float fixedTop = 12.0f;
    private float fixedBottom = 0.0f;
    protected JPopupMenu popup;
    private JComboBox geneCB;
    private JComboBox geneAnnotationCB;
    private JComboBox geneClusterCB;
    private JComboBox chartTypeCB;
    private JComboBox geneOrClusterCB;
    private float[][] expressionAverages;
    private float[][] expressionSDs;
    private float[][] expressionMedian;
    private float[][] expressionQ1;
    private float[][] expressionQ3;
    private float[][] expressionIQR;
    private float[][] expressionLowerWhisker;
    private float[][] expressionUpperWhisker;
    private float[][][] upperOutliers;
    private float[][][] lowerOutliers;
    private boolean isSingleGene;
    private boolean isBoxPlot;
    private JMenuItem menuItemAuto;
    private JMenuItem menuItemSetScale;
    private JMenuItem menuItemFixScale;
    private JLabel annotLabel;
    private JLabel geneIDlabel;
    private JMenuItem aggGenClusterMenuItem;
    private JCheckBox aggregateCheckBox;
    private JScrollBar jScrollBar = new JScrollBar();
    private int multigeneCount;
    private String[] chartTitles;
    private JPanel header;
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String ZOOM_IN = "zoom-in";
    protected static final String ZOOM_OUT = "zoom-out";
    protected static final String SAVE_DATA_CMD = "save-cluster-cmd";
    protected static final String TOGGLE_GRIDLINES_CMD = "toggle-gridlines-cmd";
    protected static final String AUTOSCALE_CMD = "auto-scale-cmd";
    protected static final String SET_SCALE_CMD = "set-scale-cmd";
    protected static final String FIX_SCALE_CMD = "fix-scale-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    public static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    public static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    private static final String AGG_GENE_CLUSTER_CMD = "aggregate-gene-cluster";
    private String sn = "";
    private boolean inAnalysis;
    private String geneClusterLabel;
    private String[] sampleClusterNames;

    public BoxChartViewer(IFramework fm, Cluster[] clusterArray) {
        this.inAnalysis = false;
        this.framework = fm;
        this.experiment = this.framework.getData().getExperiment();
        this.setClusters(clusterArray);
        this.populateGeneListComboBoxes();
        this.generateSettingsComponents();
        this.createComponentLayout();
        this.init();
    }

    public BoxChartViewer(IFramework fm, int[][] sampleArray, int[] geneArray, String geneClusterLabel, String[] sampleClusterNames) {
        this.sampleClusterNames = sampleClusterNames;
        this.inAnalysis = true;
        this.framework = fm;
        this.geneClusterLabel = geneClusterLabel;
        this.experiment = this.framework.getData().getExperiment();
        this.setClusters(sampleArray);
        this.geneIndices = geneArray;
        this.populateGeneListComboBoxes();
        this.generateSettingsComponents();
        this.createComponentLayout();
        this.init();
    }

    private void setClusters(int[][] sampleArray) {
        if (sampleArray == null || ((int[][])sampleArray).length == 0) {
            sampleArray = new int[1][];
        }
        this.clusterCount = ((int[][])sampleArray).length;
        this.clusterNames = new String[this.clusterCount];
        this.clusterColors = new Color[this.clusterCount];
        this.clusters = new int[this.clusterCount][];
        for (int i = 0; i < this.clusterCount; ++i) {
            if (sampleArray[i] == null) {
                int numSamps = this.experiment.getNumberOfSamples();
                this.clusters[i] = new int[numSamps];
                for (int j = 0; j < numSamps; ++j) {
                    this.clusters[i][j] = j;
                }
                this.clusterColors[i] = Color.white;
                this.clusterNames[i] = "All Samples";
                continue;
            }
            this.clusters[i] = sampleArray[i];
            this.clusterColors[i] = this.createClusterColor(i);
            this.clusterNames[i] = this.sampleClusterNames == null || this.sampleClusterNames[i].length() < 1 ? "(Group " + (i + 1) + ")" : this.sampleClusterNames[i];
        }
    }

    private Color createClusterColor(int i) {
        if (i == 0) {
            return Color.green;
        }
        if (i == 1) {
            return Color.blue;
        }
        if (i == 2) {
            return Color.red;
        }
        if (i == 3) {
            return Color.yellow;
        }
        if (i == 4) {
            return Color.orange;
        }
        return new Color((int)Math.random() * 255, (int)Math.random() * 255, (int)Math.random() * 255);
    }

    private void init() {
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.setBackground(Color.white);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    private void createComponentLayout() {
        this.header = new JPanel();
        this.header.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.gridx = 0;
        this.header.add((Component)new JLabel("  Chart Type: "), gbc);
        ++gbc.gridx;
        this.header.add((Component)this.chartTypeCB, gbc);
        if (!this.inAnalysis) {
            this.header.add((Component)new JLabel("  Gene Range: "), gbc);
            ++gbc.gridx;
            ++gbc.gridx;
            this.header.add((Component)this.geneOrClusterCB, gbc);
            ++gbc.gridx;
            this.header.add((Component)this.annotLabel, gbc);
            ++gbc.gridx;
            this.header.add((Component)this.geneAnnotationCB, gbc);
            ++gbc.gridx;
            this.header.add((Component)this.geneClusterCB, gbc);
            ++gbc.gridx;
            this.header.add((Component)this.geneIDlabel, gbc);
            ++gbc.gridx;
            this.header.add((Component)this.geneCB, gbc);
        }
        ++gbc.gridx;
        this.header.add((Component)this.aggregateCheckBox, gbc);
        gbc.gridx = 0;
    }

    private void generateSettingsComponents() {
        String[] chartTypes = new String[]{"Box Plot", "Bar Graph"};
        this.chartTypeCB = new JComboBox<String>(chartTypes);
        this.chartTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.isBoxPlot = BoxChartViewer.this.chartTypeCB.getSelectedIndex() == 0;
                BoxChartViewer.this.repaint();
            }
        });
        String[] geneOrCluster = new String[]{"Single Gene", "Gene Cluster"};
        this.geneOrClusterCB = new JComboBox<String>(geneOrCluster);
        this.geneOrClusterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BoxChartViewer.this.geneOrClusterCB.getSelectedIndex() == 0) {
                    BoxChartViewer.this.annotLabel.setText("  Annotation Field: ");
                    BoxChartViewer.this.aggGenClusterMenuItem.setEnabled(false);
                    BoxChartViewer.this.geneClusterCB.setVisible(false);
                    BoxChartViewer.this.aggregateCheckBox.setVisible(false);
                    BoxChartViewer.this.geneAnnotationCB.setVisible(true);
                    BoxChartViewer.this.geneIDlabel.setVisible(true);
                    BoxChartViewer.this.geneCB.setVisible(true);
                    BoxChartViewer.this.isSingleGene = true;
                } else {
                    if (BoxChartViewer.this.framework.getClusterRepository(0) == null || BoxChartViewer.this.framework.getClusterRepository(0).isEmpty()) {
                        JOptionPane.showMessageDialog(null, "The Gene Cluster Repository is empty\nPlease create a Gene Cluster to continue...", "Error", 2);
                        BoxChartViewer.this.geneOrClusterCB.setSelectedIndex(0);
                        BoxChartViewer.this.isSingleGene = true;
                        return;
                    }
                    BoxChartViewer.this.annotLabel.setText("  Select Cluster: ");
                    BoxChartViewer.this.aggGenClusterMenuItem.setEnabled(true);
                    BoxChartViewer.this.geneClusterCB.setVisible(true);
                    BoxChartViewer.this.aggregateCheckBox.setVisible(true);
                    BoxChartViewer.this.geneAnnotationCB.setVisible(false);
                    BoxChartViewer.this.geneIDlabel.setVisible(false);
                    BoxChartViewer.this.geneCB.setVisible(false);
                    BoxChartViewer.this.isSingleGene = false;
                }
                BoxChartViewer.this.repaint();
            }
        });
        this.aggregateCheckBox = new JCheckBox("Aggregate Gene Cluster");
        this.aggregateCheckBox.setSelected(this.inAnalysis);
        this.aggregateCheckBox.setBackground(Color.white);
        this.aggregateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.aggregateGeneCluster = !BoxChartViewer.this.aggregateGeneCluster;
                if (BoxChartViewer.this.aggregateGeneCluster) {
                    BoxChartViewer.this.aggGenClusterMenuItem.setText("Un-aggregate Gene Cluster");
                } else {
                    BoxChartViewer.this.aggGenClusterMenuItem.setText("Aggregate Gene Cluster");
                }
                BoxChartViewer.this.repaint();
            }
        });
        this.aggregateGeneCluster = this.aggregateCheckBox.isSelected();
        this.geneIDlabel = new JLabel("  Gene ID: ");
        this.annotLabel = new JLabel("  Annotation Field: ");
        boolean bl = this.isBoxPlot = this.chartTypeCB.getSelectedIndex() == 0;
        if (this.inAnalysis) {
            this.aggregateCheckBox.setVisible(true);
            this.isSingleGene = false;
        } else {
            this.aggregateCheckBox.setVisible(false);
            this.isSingleGene = this.geneOrClusterCB.getSelectedIndex() == 0;
        }
    }

    private void populateGeneListComboBoxes() {
        this.geneClusterCB = new JComboBox();
        this.geneClusterCB.removeAllItems();
        for (int i = 0; i < this.framework.getClusterRepository(0).size() && this.framework.getClusterRepository(0).getCluster(i + 1) != null; ++i) {
            Cluster cluster = this.framework.getClusterRepository(0).getCluster(i + 1);
            this.geneClusterCB.addItem("Cluster #: " + cluster.getSerialNumber() + ", " + cluster.getClusterLabel());
        }
        this.geneClusterCB.setVisible(false);
        this.geneClusterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.repaint();
            }
        });
        this.geneAnnotationCB = new JComboBox<String>(this.framework.getData().getAllFilledAnnotationFields());
        this.geneAnnotationCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BoxChartViewer.this.chartTypeCB.getSelectedIndex() > 1) {
                    return;
                }
                BoxChartViewer.this.geneCB.removeAllItems();
                int selected = Math.max(BoxChartViewer.this.geneAnnotationCB.getSelectedIndex(), 0);
                int numGenes = BoxChartViewer.this.framework.getData().getAnnotationList(BoxChartViewer.this.framework.getData().getAllFilledAnnotationFields()[selected]).length;
                StringExt[] stringext = new StringExt[numGenes];
                String[] geneNames = BoxChartViewer.this.framework.getData().getAnnotationList(BoxChartViewer.this.framework.getData().getAllFilledAnnotationFields()[selected]);
                for (int i = 0; i < numGenes; ++i) {
                    stringext[i] = new StringExt(geneNames[i]);
                }
                DefaultComboBoxModel<StringExt> cbm = new DefaultComboBoxModel<StringExt>(stringext);
                BoxChartViewer.this.geneCB.setModel(cbm);
            }
        });
        this.geneCB = new JComboBox<String>(this.framework.getData().getAnnotationList(this.framework.getData().getAllFilledAnnotationFields()[0]));
        this.geneCB.setMaximumSize(new Dimension(150, this.geneCB.getHeight()));
        this.geneCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.repaint();
            }
        });
    }

    public void setClusters(Cluster[] clusterArray) {
        if (clusterArray == null || clusterArray.length == 0) {
            clusterArray = new Cluster[1];
        }
        this.clusterCount = clusterArray.length;
        this.clusterNames = new String[this.clusterCount];
        this.clusterColors = new Color[this.clusterCount];
        this.clusters = new int[this.clusterCount][];
        for (int i = 0; i < this.clusterCount; ++i) {
            if (clusterArray[i] == null) {
                int numSamps = this.experiment.getNumberOfSamples();
                this.clusters[i] = new int[numSamps];
                for (int j = 0; j < numSamps; ++j) {
                    this.clusters[i][j] = j;
                }
                this.clusterColors[i] = Color.white;
                this.clusterNames[i] = "All Samples";
                continue;
            }
            this.clusters[i] = clusterArray[i].getIndices();
            this.clusterColors[i] = clusterArray[i].getClusterColor();
            this.clusterNames[i] = clusterArray[i].getClusterLabel();
            if (this.clusterNames[i].length() >= 1) continue;
            this.clusterNames[i] = "(Cluster " + (i + 1) + ")";
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.clusterCount == 0) {
            return;
        }
        boolean ismultigene = !this.isSingleGene;
        Graphics2D g2 = (Graphics2D)g;
        this.multigeneCount = 1;
        Cluster cluster = null;
        if (ismultigene) {
            try {
                if (!this.inAnalysis) {
                    int begin = this.geneClusterCB.getSelectedItem().toString().indexOf(":");
                    int end = this.geneClusterCB.getSelectedItem().toString().indexOf(",");
                    this.sn = this.geneClusterCB.getSelectedItem().toString().substring(begin + 2, end);
                    cluster = this.framework.getClusterRepository(0).getCluster(Integer.parseInt(this.sn));
                    this.geneIndices = cluster.getIndices();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Gene Cluster Problem");
                return;
            }
            if (this.geneIndices == null || this.geneIndices.length < 1) {
                return;
            }
            this.multigeneCount = this.aggregateGeneCluster ? 1 : this.geneIndices.length;
        }
        int chartTop = this.chartTopHeight;
        this.lowerOutliers = new float[this.multigeneCount][][];
        this.upperOutliers = new float[this.multigeneCount][][];
        this.expressionSDs = new float[this.multigeneCount][];
        this.expressionAverages = new float[this.multigeneCount][];
        this.expressionMedian = new float[this.multigeneCount][];
        this.expressionQ1 = new float[this.multigeneCount][];
        this.expressionQ3 = new float[this.multigeneCount][];
        this.expressionIQR = new float[this.multigeneCount][];
        this.expressionLowerWhisker = new float[this.multigeneCount][];
        this.expressionUpperWhisker = new float[this.multigeneCount][];
        this.chartTitles = new String[this.multigeneCount];
        int maxString = 0;
        for (int i = 0; i < this.clusterNames.length; ++i) {
            maxString = Math.max(maxString, g.getFontMetrics().stringWidth(this.clusterNames[i]));
        }
        this.chartGap = maxString + 50;
        Rectangle bounds = g.getClipBounds();
        int indexBegin = (int)Math.max((float)(-3 + bounds.y / (this.chartHeight + this.chartGap)), 0.0f);
        int indexEnd = Math.min(this.multigeneCount, 3 + (bounds.y + bounds.height) / (this.chartHeight + this.chartGap));
        for (int multigeneIndex = indexBegin; multigeneIndex < indexEnd; ++multigeneIndex) {
            float bottomgridline;
            float topgridline;
            int j;
            int i;
            if (ismultigene) {
                if (this.aggregateGeneCluster) {
                    this.getChartData(this.geneIndices, multigeneIndex);
                    this.chartTitles[multigeneIndex] = this.inAnalysis ? this.geneClusterLabel : cluster.getClusterLabel();
                } else {
                    this.getChartData(this.geneIndices[multigeneIndex], multigeneIndex);
                    this.chartTitles[multigeneIndex] = this.framework.getData().getElementAnnotation(this.geneIndices[multigeneIndex], this.framework.getData().getFieldNames()[0])[0];
                }
            } else {
                this.getChartData(this.geneCB.getSelectedIndex(), multigeneIndex);
                this.chartTitles[multigeneIndex] = this.geneCB.getSelectedItem().toString();
            }
            float maxHeight = 0.0f;
            float minHeight = Float.POSITIVE_INFINITY;
            for (i = 0; i < this.clusterCount; ++i) {
                if (this.isBoxPlot) {
                    for (j = 0; j < this.upperOutliers[multigeneIndex][i].length; ++j) {
                        maxHeight = Math.max(this.upperOutliers[multigeneIndex][i][j], maxHeight);
                    }
                    maxHeight = Math.max(this.expressionUpperWhisker[multigeneIndex][i], maxHeight);
                    continue;
                }
                maxHeight = Math.max(this.expressionAverages[multigeneIndex][i] + this.expressionSDs[multigeneIndex][i], maxHeight);
            }
            for (i = 0; i < this.clusterCount; ++i) {
                if (this.isBoxPlot) {
                    for (j = 0; j < this.lowerOutliers[multigeneIndex][i].length; ++j) {
                        minHeight = Math.min(this.lowerOutliers[multigeneIndex][i][j], minHeight);
                    }
                    minHeight = Math.min(this.expressionLowerWhisker[multigeneIndex][i], minHeight);
                    continue;
                }
                minHeight = 0.0f;
            }
            maxHeight += 1.0f;
            if (this.autoScale) {
                topgridline = (int)maxHeight + (int)maxHeight % 2;
                bottomgridline = (int)minHeight - (int)minHeight % 2 - 2;
                if (!this.isBoxPlot) {
                    bottomgridline = 0.0f;
                }
                this.fixedTop = topgridline;
                this.fixedBottom = bottomgridline;
            } else {
                topgridline = this.fixedTop;
                bottomgridline = this.fixedBottom;
                if (!this.isBoxPlot) {
                    bottomgridline = 0.0f;
                }
            }
            float gridrange = topgridline - bottomgridline;
            g2.setColor(Color.black);
            g2.drawLine(this.chartleft - 5, this.chartHeight + chartTop, this.chartleft + this.clusterCount * this.chartIncrement, this.chartHeight + chartTop);
            g2.drawLine(this.chartleft, chartTop, this.chartleft, this.chartHeight + chartTop + 5);
            g2.setColor(Color.gray);
            g2.drawLine(this.chartleft - 7, chartTop, this.chartleft, chartTop);
            g2.drawLine(this.chartleft - 5, chartTop + this.chartHeight / 4, this.chartleft, chartTop + this.chartHeight / 4);
            g2.drawLine(this.chartleft - 7, chartTop + this.chartHeight / 2, this.chartleft, chartTop + this.chartHeight / 2);
            g2.drawLine(this.chartleft - 5, chartTop + 3 * this.chartHeight / 4, this.chartleft, chartTop + 3 * this.chartHeight / 4);
            if (this.showGridlines) {
                g2.setColor(Color.gray);
                g2.drawLine(this.chartleft, chartTop, this.chartleft + this.chartIncrement * this.clusterCount, chartTop);
                g2.drawLine(this.chartleft, chartTop + this.chartHeight / 4, this.chartleft + this.chartIncrement * this.clusterCount, chartTop + this.chartHeight / 4);
                g2.drawLine(this.chartleft, chartTop + this.chartHeight / 2, this.chartleft + this.chartIncrement * this.clusterCount, chartTop + this.chartHeight / 2);
                g2.drawLine(this.chartleft, chartTop + 3 * this.chartHeight / 4, this.chartleft + this.chartIncrement * this.clusterCount, chartTop + 3 * this.chartHeight / 4);
            }
            g2.setColor(Color.black);
            g2.drawString(Float.toString(bottomgridline + gridrange), this.chartleft - 40, chartTop + 3);
            g2.drawString(Float.toString(bottomgridline + gridrange * 3.0f / 4.0f), this.chartleft - 40, chartTop + 3 + this.chartHeight / 4);
            g2.drawString(Float.toString(bottomgridline + gridrange / 2.0f), this.chartleft - 40, chartTop + 3 + this.chartHeight / 2);
            g2.drawString(Float.toString(bottomgridline + gridrange / 4.0f), this.chartleft - 40, chartTop + 3 + 3 * this.chartHeight / 4);
            g2.drawString(Float.toString(bottomgridline), this.chartleft - 40, chartTop + 3 + this.chartHeight);
            Font font = g2.getFont();
            g2.setFont(new Font("Helvetica", 1, 16));
            g2.drawString(this.chartTitles[multigeneIndex], this.chartleft + this.chartIncrement / 2, chartTop - 15);
            g2.setFont(font);
            g2.rotate(-1.5707963267948966);
            g2.drawString("Expression", -(chartTop + 3 + 2 * this.chartHeight / 3), this.chartleft - 60);
            g2.rotate(1.5707963267948966);
            for (int i2 = 0; i2 < this.clusterCount; ++i2) {
                int xorigin = (int)((0.25f + (float)i2) * (float)this.chartIncrement) + this.chartleft;
                int yorigin = this.chartHeight + chartTop;
                int barWidth = this.chartIncrement / 2;
                int barHeight = (int)(this.expressionAverages[multigeneIndex][i2] * (float)this.chartHeight / gridrange);
                int errorBarHeight = (int)(this.expressionSDs[multigeneIndex][i2] * (float)this.chartHeight / gridrange);
                int boxBottom = (int)((-bottomgridline + this.expressionQ1[multigeneIndex][i2]) * (float)this.chartHeight / gridrange);
                int boxTop = (int)((-bottomgridline + this.expressionQ3[multigeneIndex][i2]) * (float)this.chartHeight / gridrange);
                int boxMedian = (int)((-bottomgridline + this.expressionMedian[multigeneIndex][i2]) * (float)this.chartHeight / gridrange);
                int boxLowerWhisker = (int)((-bottomgridline + this.expressionLowerWhisker[multigeneIndex][i2]) * (float)this.chartHeight / gridrange);
                int boxUpperWhisker = (int)((-bottomgridline + this.expressionUpperWhisker[multigeneIndex][i2]) * (float)this.chartHeight / gridrange);
                g2.setColor(Color.gray);
                g2.drawLine(xorigin + 3 * barWidth / 2, yorigin, xorigin + 3 * barWidth / 2, yorigin + 5);
                g2.setColor(Color.black);
                g2.rotate(-1.5707963267948966);
                g2.drawString(this.clusterNames[i2], -(yorigin + 5) - g.getFontMetrics().stringWidth(this.clusterNames[i2]), xorigin + barWidth / 2);
                g2.rotate(1.5707963267948966);
                if (!this.isBoxPlot) {
                    g2.setColor(this.clusterColors[i2]);
                    g2.fillRect(xorigin, yorigin - barHeight, barWidth, barHeight);
                    g2.setColor(Color.black);
                    g2.drawRect(xorigin, yorigin - barHeight, barWidth, barHeight);
                    g2.drawLine(xorigin + barWidth / 2, yorigin - barHeight - errorBarHeight, xorigin + barWidth / 2, yorigin - barHeight);
                    g2.drawLine(xorigin + barWidth / 4, yorigin - barHeight - errorBarHeight, xorigin + 3 * barWidth / 4, yorigin - barHeight - errorBarHeight);
                    continue;
                }
                if (this.isBoxPlot) {
                    int j2;
                    g2.setColor(this.clusterColors[i2]);
                    g2.fillRect(xorigin, yorigin - boxTop, barWidth, boxTop - boxBottom);
                    g2.setColor(Color.black);
                    g2.drawRect(xorigin, yorigin - boxTop, barWidth, boxTop - boxBottom);
                    g2.drawLine(xorigin, yorigin - boxMedian, xorigin + barWidth, yorigin - boxMedian);
                    g2.drawLine(xorigin + barWidth / 2, yorigin - boxTop, xorigin + barWidth / 2, yorigin - boxUpperWhisker);
                    g2.drawLine(xorigin + barWidth / 2, yorigin - boxBottom, xorigin + barWidth / 2, yorigin - boxLowerWhisker);
                    g2.drawLine(xorigin + barWidth / 4, yorigin - boxUpperWhisker, xorigin + 3 * barWidth / 4, yorigin - boxUpperWhisker);
                    g2.drawLine(xorigin + barWidth / 4, yorigin - boxLowerWhisker, xorigin + 3 * barWidth / 4, yorigin - boxLowerWhisker);
                    int circleWidth = 6;
                    for (j2 = 0; j2 < this.upperOutliers[multigeneIndex][i2].length; ++j2) {
                        g2.drawOval(xorigin + barWidth / 2 - circleWidth / 2, yorigin - (int)((-bottomgridline + this.upperOutliers[multigeneIndex][i2][j2]) * (float)this.chartHeight / gridrange) - circleWidth / 2, circleWidth, circleWidth);
                    }
                    for (j2 = 0; j2 < this.lowerOutliers[multigeneIndex][i2].length; ++j2) {
                        g2.drawOval(xorigin + barWidth / 2 - circleWidth / 2, yorigin - (int)((-bottomgridline + this.lowerOutliers[multigeneIndex][i2][j2]) * (float)this.chartHeight / gridrange) - circleWidth / 2, circleWidth, circleWidth);
                    }
                    continue;
                }
                System.out.println("unknown chart type");
            }
            chartTop = this.chartTopHeight + (multigeneIndex + 1) * (this.chartHeight + this.chartGap);
        }
        this.jScrollBar.setUnitIncrement(this.chartHeight + this.chartGap);
        int viewerHeight = this.chartTopHeight + this.multigeneCount * (this.chartHeight + this.chartGap);
        this.setSize(new Dimension(this.getWidth(), viewerHeight));
        this.setPreferredSize(new Dimension(this.getWidth(), viewerHeight));
    }

    private void getChartData(int geneIndex, int multigeneIndex) {
        int[] indices = new int[]{geneIndex};
        this.getChartData(indices, multigeneIndex);
    }

    private void getChartData(int[] geneIndices, int multigeneIndex) {
        try {
            this.lowerOutliers[multigeneIndex] = new float[this.clusterCount][];
            this.upperOutliers[multigeneIndex] = new float[this.clusterCount][];
            this.expressionSDs[multigeneIndex] = new float[this.clusterCount];
            this.expressionAverages[multigeneIndex] = new float[this.clusterCount];
            this.expressionMedian[multigeneIndex] = new float[this.clusterCount];
            this.expressionQ1[multigeneIndex] = new float[this.clusterCount];
            this.expressionQ3[multigeneIndex] = new float[this.clusterCount];
            this.expressionIQR[multigeneIndex] = new float[this.clusterCount];
            this.expressionLowerWhisker[multigeneIndex] = new float[this.clusterCount];
            this.expressionUpperWhisker[multigeneIndex] = new float[this.clusterCount];
            for (int i = 0; i < this.clusterCount; ++i) {
                int j;
                int k;
                int j2;
                float average = 0.0f;
                float sum = 0.0f;
                int membership = 0;
                for (j2 = 0; j2 < this.clusters[i].length; ++j2) {
                    for (k = 0; k < geneIndices.length; ++k) {
                        average += this.experiment.get(geneIndices[k], this.clusters[i][j2]);
                        ++membership;
                    }
                }
                this.expressionAverages[multigeneIndex][i] = average /= (float)membership;
                for (j2 = 0; j2 < this.clusters[i].length; ++j2) {
                    for (k = 0; k < geneIndices.length; ++k) {
                        sum += (float)Math.pow(this.experiment.get(geneIndices[k], this.clusters[i][j2]) - average, 2.0);
                    }
                }
                this.expressionSDs[multigeneIndex][i] = (float)Math.sqrt(sum /= (float)membership);
                float[] expression = new float[this.clusters[i].length * geneIndices.length];
                int expindex = 0;
                for (int j3 = 0; j3 < this.clusters[i].length; ++j3) {
                    for (int k2 = 0; k2 < geneIndices.length; ++k2) {
                        expression[expindex++] = this.experiment.get(geneIndices[k2], this.clusters[i][j3]);
                    }
                }
                Arrays.sort(expression);
                this.expressionMedian[multigeneIndex][i] = this.getMedian(expression);
                float[] lower = new float[expression.length / 2];
                float[] upper = new float[expression.length / 2];
                for (int j4 = 0; j4 < lower.length; ++j4) {
                    lower[j4] = expression[j4];
                    upper[upper.length - 1 - j4] = expression[expression.length - 1 - j4];
                }
                this.expressionQ1[multigeneIndex][i] = this.getMedian(lower);
                this.expressionQ3[multigeneIndex][i] = this.getMedian(upper);
                this.expressionIQR[multigeneIndex][i] = this.expressionQ3[multigeneIndex][i] - this.expressionQ1[multigeneIndex][i];
                this.expressionLowerWhisker[multigeneIndex][i] = this.expressionQ1[multigeneIndex][i] - 1.5f * this.expressionIQR[multigeneIndex][i];
                this.expressionUpperWhisker[multigeneIndex][i] = this.expressionQ3[multigeneIndex][i] + 1.5f * this.expressionIQR[multigeneIndex][i];
                int upperCount = 0;
                int lowerCount = 0;
                for (int index = 0; index < expression.length; ++index) {
                    if (expression[index] < this.expressionLowerWhisker[multigeneIndex][i]) {
                        ++lowerCount;
                    }
                    if (!(expression[index] > this.expressionUpperWhisker[multigeneIndex][i])) continue;
                    ++upperCount;
                }
                this.lowerOutliers[multigeneIndex][i] = new float[lowerCount];
                this.upperOutliers[multigeneIndex][i] = new float[upperCount];
                for (j = 0; j < this.lowerOutliers[multigeneIndex][i].length; ++j) {
                    this.lowerOutliers[multigeneIndex][i][j] = expression[j];
                }
                for (j = 0; j < this.upperOutliers[multigeneIndex][i].length; ++j) {
                    this.upperOutliers[multigeneIndex][i][j] = expression[expression.length - 1 - j];
                }
            }
        }
        catch (Exception e) {
            System.out.println("data problem");
            e.printStackTrace();
            for (int i = 0; i < this.clusterCount; ++i) {
                this.expressionAverages[multigeneIndex][i] = (float)Math.random();
                this.expressionSDs[multigeneIndex][i] = (float)Math.random() / 10.0f;
            }
        }
    }

    private float getMedian(float[] expression) {
        return (expression[expression.length / 2] + expression[(expression.length - 1) / 2]) / 2.0f;
    }

    @Override
    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }

    @Override
    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    @Override
    public void onSelected(IFramework framework) {
        this.geneClusterCB.removeAllItems();
        for (int i = 0; i < framework.getClusterRepository(0).size() && framework.getClusterRepository(0).getCluster(i + 1) != null; ++i) {
            Cluster cluster = framework.getClusterRepository(0).getCluster(i + 1);
            this.geneClusterCB.addItem("Cluster #: " + cluster.getSerialNumber() + ", " + cluster.getClusterLabel());
        }
    }

    @Override
    public void onDataChanged(IData data) {
    }

    @Override
    public void onMenuChanged(IDisplayMenu menu) {
    }

    @Override
    public void onDeselected() {
    }

    @Override
    public void onClosed() {
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public int[][] getClusters() {
        return this.clusters;
    }

    @Override
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public int getViewerType() {
        return -1;
    }

    @Override
    public void setExperiment(Experiment e) {
    }

    @Override
    public int getExperimentID() {
        return this.exptID;
    }

    @Override
    public void setExperimentID(int id) {
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])this.clusters)});
    }

    private void saveData() {
        JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                Date currDate = new Date(System.currentTimeMillis());
                String dateString = currDate.toString();
                String userName = System.getProperty("user.name");
                pw.println("# MeV");
                pw.println("# User: " + userName + " Save Date: " + dateString);
                pw.println("#");
                pw.println("# " + this.clusterCount + " Clusters");
                pw.println("# Annotation Field: " + this.geneAnnotationCB.getSelectedItem());
                for (int j = 0; j < this.multigeneCount; ++j) {
                    int i;
                    if (this.isSingleGene) {
                        pw.println("Gene: " + this.geneCB.getSelectedItem());
                    } else if (this.aggregateGeneCluster) {
                        pw.println("Gene Cluster: " + this.chartTitles[j]);
                    } else {
                        pw.println("Gene: " + this.chartTitles[j]);
                    }
                    pw.print("\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.clusterNames[i] + "\t");
                    }
                    pw.println();
                    pw.print("Genes Present\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.clusters[i].length + "\t");
                    }
                    pw.println();
                    pw.print("Expression Mean\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionAverages[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Expression Median\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionMedian[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Expression Standard Deviation\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionSDs[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Expression Q1\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionQ1[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Expression Q3\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionQ3[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Expression IQR\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionIQR[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Upper Whisker\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionUpperWhisker[j][i] + "\t");
                    }
                    pw.println();
                    pw.print("Lower Whisker\t");
                    for (i = 0; i < this.clusterCount; ++i) {
                        pw.print(this.expressionLowerWhisker[j][i] + "\t");
                    }
                    pw.println();
                    pw.println();
                }
                pw.flush();
                pw.close();
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private boolean setScale() {
        this.scaleDialog = new JDialog();
        this.scaleDialog.setTitle("Enter Y-Axis Limits");
        this.scaleDialog.setLocation(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        this.scaleChanged = false;
        GridBagLayout gbl = new GridBagLayout();
        this.scaleDialog.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        JTextField upper = new JTextField("" + this.fixedTop);
        JTextField lower = new JTextField("" + this.fixedBottom);
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.scaleChanged = true;
                BoxChartViewer.this.scaleDialog.dispose();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxChartViewer.this.scaleChanged = false;
                BoxChartViewer.this.scaleDialog.dispose();
            }
        });
        upper.setPreferredSize(new Dimension(40, 20));
        lower.setPreferredSize(new Dimension(40, 20));
        lower.setEnabled(this.isBoxPlot);
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.scaleDialog.add((Component)new JLabel("Upper Limit: "), gbc);
        ++gbc.gridx;
        this.scaleDialog.add((Component)upper, gbc);
        --gbc.gridx;
        ++gbc.gridy;
        this.scaleDialog.add((Component)new JLabel("Lower Limit: "), gbc);
        ++gbc.gridx;
        this.scaleDialog.add((Component)lower, gbc);
        ++gbc.gridy;
        this.scaleDialog.add((Component)button, gbc);
        --gbc.gridx;
        this.scaleDialog.add((Component)cancel, gbc);
        this.scaleDialog.pack();
        this.scaleDialog.setModal(true);
        this.scaleDialog.setVisible(true);
        if (this.scaleChanged) {
            try {
                float ft = Float.parseFloat(upper.getText());
                float fb = Float.parseFloat(lower.getText());
                if (ft - fb <= 0.0f) {
                    JOptionPane.showMessageDialog(null, "<html>Error -- Upper limit must be greater than lower limit</html>", "Validation Error", 0);
                    return this.setScale();
                }
                this.fixedTop = ft;
                this.fixedBottom = fb;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "<html>Error -- Invalid inputs</html>", "Input Error", 0);
                return this.setScale();
            }
        }
        return false;
    }

    protected JPopupMenu createJPopupMenu(ActionListener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        JMenuItem menuItem = new JMenuItem("Zoom In", GUIFactory.getIcon((String)"zoom_in.gif"));
        menuItem.setActionCommand(ZOOM_IN);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Zoom Out", GUIFactory.getIcon((String)"zoom_out.gif"));
        menuItem.setActionCommand(ZOOM_OUT);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Data", GUIFactory.getIcon((String)"save16.gif"));
        menuItem.setActionCommand(SAVE_DATA_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Toggle Gridlines", GUIFactory.getIcon((String)"empty16.gif"));
        menuItem.setActionCommand(TOGGLE_GRIDLINES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        this.menuItemAuto = new JMenuItem("Autoscale Y-Axis", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.menuItemAuto.setActionCommand(AUTOSCALE_CMD);
        this.menuItemAuto.addActionListener(listener);
        this.menuItemAuto.setEnabled(false);
        menu.add(this.menuItemAuto);
        this.menuItemSetScale = new JMenuItem("Set Y-Axis", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.menuItemSetScale.setActionCommand(SET_SCALE_CMD);
        this.menuItemSetScale.addActionListener(listener);
        menu.add(this.menuItemSetScale);
        this.menuItemFixScale = new JMenuItem("Fix Y-Axis to Global Range", GUIFactory.getIcon((String)"Y_range_expand.gif"));
        this.menuItemFixScale.setActionCommand(FIX_SCALE_CMD);
        this.menuItemFixScale.addActionListener(listener);
        menu.add(this.menuItemFixScale);
        this.aggGenClusterMenuItem = new JMenuItem("Aggregate Gene Cluster", GUIFactory.getIcon((String)"empty16.gif"));
        this.aggGenClusterMenuItem.setActionCommand(AGG_GENE_CLUSTER_CMD);
        this.aggGenClusterMenuItem.setEnabled(false);
        this.aggGenClusterMenuItem.addActionListener(listener);
        menu.add(this.aggGenClusterMenuItem);
    }

    public void setScrollBar(JScrollBar jsb) {
        this.jScrollBar = jsb;
        this.jScrollBar.setUnitIncrement(this.chartHeight + this.chartGap);
    }

    public static void main(String[] args) {
        System.exit(0);
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(BoxChartViewer.ZOOM_IN)) {
                BoxChartViewer.this.chartHeight = BoxChartViewer.this.chartHeight * 3 / 2;
                BoxChartViewer.this.chartIncrement = BoxChartViewer.this.chartIncrement * 3 / 2;
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.ZOOM_OUT)) {
                BoxChartViewer.this.chartHeight = BoxChartViewer.this.chartHeight * 2 / 3;
                BoxChartViewer.this.chartIncrement = BoxChartViewer.this.chartIncrement * 2 / 3;
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.SAVE_DATA_CMD)) {
                BoxChartViewer.this.saveData();
            }
            if (command.equals(BoxChartViewer.TOGGLE_GRIDLINES_CMD)) {
                BoxChartViewer.this.showGridlines = !BoxChartViewer.this.showGridlines;
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.SET_SCALE_CMD)) {
                BoxChartViewer.this.setScale();
                if (BoxChartViewer.this.scaleChanged) {
                    BoxChartViewer.this.menuItemAuto.setEnabled(true);
                    BoxChartViewer.this.autoScale = false;
                }
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.FIX_SCALE_CMD)) {
                float min = Float.MAX_VALUE;
                float max = Float.MIN_VALUE;
                for (int i = 0; i < BoxChartViewer.this.experiment.getNumberOfGenes(); ++i) {
                    for (int j = 0; j < BoxChartViewer.this.experiment.getNumberOfSamples(); ++j) {
                        if (min > BoxChartViewer.this.experiment.get(i, j)) {
                            min = BoxChartViewer.this.experiment.get(i, j);
                        }
                        if (!(max < BoxChartViewer.this.experiment.get(i, j))) continue;
                        max = BoxChartViewer.this.experiment.get(i, j);
                    }
                }
                BoxChartViewer.this.fixedTop = (int)max + 1;
                BoxChartViewer.this.fixedBottom = (int)min;
                BoxChartViewer.this.menuItemAuto.setEnabled(true);
                BoxChartViewer.this.autoScale = false;
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.AGG_GENE_CLUSTER_CMD)) {
                BoxChartViewer.this.aggregateGeneCluster = !BoxChartViewer.this.aggregateGeneCluster;
                if (BoxChartViewer.this.aggregateGeneCluster) {
                    BoxChartViewer.this.aggGenClusterMenuItem.setText("Un-aggregate Gene Cluster");
                    BoxChartViewer.this.aggregateCheckBox.setSelected(true);
                } else {
                    BoxChartViewer.this.aggGenClusterMenuItem.setText("Aggregate Gene Cluster");
                    BoxChartViewer.this.aggregateCheckBox.setSelected(false);
                }
                BoxChartViewer.this.repaint();
            }
            if (command.equals(BoxChartViewer.AUTOSCALE_CMD)) {
                BoxChartViewer.this.menuItemAuto.setEnabled(false);
                BoxChartViewer.this.autoScale = true;
                BoxChartViewer.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
            if (event.isPopupTrigger()) {
                return;
            }
            BoxChartViewer.this.repaint();
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BoxChartViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
                BoxChartViewer.this.repaint();
            }
        }
    }

    private class StringExt {
        String string;

        public StringExt(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

