/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui;

import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.util.FloatMatrix;

public class Experiment {
    public static int exptCount = 1;
    private FloatMatrix matrix;
    private int[] columns;
    private int[] rowMapping;
    private int id;

    public Experiment(int[] columns, int[] rows, int id, FloatMatrix fm) {
        this(null, columns, rows);
        this.matrix = fm;
    }

    public Experiment(FloatMatrix columns, FloatMatrix rows, int id, FloatMatrix fm) {
        this(null, Cluster.getIndices((FloatMatrix)columns), Cluster.getIndices((FloatMatrix)rows));
        this.matrix = fm;
    }

    public Experiment(FloatMatrix matrix, int[] columns) {
        this(matrix, columns, Experiment.makeDefaultRowMapping(matrix.getRowDimension()));
    }

    public Experiment(FloatMatrix matrix, int[] columns, int[] rows) {
        ++exptCount;
        this.matrix = matrix;
        this.columns = columns;
        this.rowMapping = rows;
        if (new Integer(this.id).equals(null)) {
            this.id = exptCount;
        }
    }

    public int[] getRows() {
        return this.rowMapping;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public int getId() {
        return this.id;
    }

    public void fillMatrix(FloatMatrix fm) {
        this.matrix = fm;
    }

    private static int[] makeDefaultRowMapping(int numberOfRows) {
        int[] rowMap = new int[numberOfRows];
        for (int i = 0; i < numberOfRows; ++i) {
            rowMap[i] = i;
        }
        return rowMap;
    }

    public int[] getRowMappingArrayCopy() {
        int[] copyArray = new int[this.rowMapping.length];
        System.arraycopy(this.rowMapping, 0, copyArray, 0, copyArray.length);
        return copyArray;
    }

    public int[] getColumnIndicesCopy() {
        int[] copyArray = new int[this.columns.length];
        System.arraycopy(this.columns, 0, copyArray, 0, copyArray.length);
        return copyArray;
    }

    public Experiment copy() {
        int[] columns = new int[this.columns.length];
        System.arraycopy(this.columns, 0, columns, 0, this.columns.length);
        return new Experiment(this.matrix.copy(), columns, this.getRowMappingArrayCopy());
    }

    public float get(int i, int j) {
        return this.matrix.get(i, j);
    }

    public float[][] getValues() {
        return this.matrix.A;
    }

    public FloatMatrix getMatrix() {
        return this.matrix;
    }

    public int getSampleIndex(int column) {
        return this.columns[column];
    }

    public int getGeneIndexMappedToData(int row) {
        if (row >= 0 && row < this.rowMapping.length) {
            return this.rowMapping[row];
        }
        return -1;
    }

    public int getNumberOfGenes() {
        return this.matrix.getRowDimension();
    }

    public int getNumberOfSamples() {
        return this.matrix.getColumnDimension();
    }

    public float[] getMinAndMax() {
        float val = 0.0f;
        int rows = this.matrix.getRowDimension();
        int cols = this.matrix.getColumnDimension();
        float[] minMax = new float[]{Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                val = this.matrix.get(row, col);
                if (Float.isNaN(val)) continue;
                if (val < minMax[0]) {
                    minMax[0] = val;
                }
                if (!(val > minMax[1])) continue;
                minMax[1] = val;
            }
        }
        return minMax;
    }

    public float getMaxAbsValue() {
        float[] minMax = this.getMinAndMax();
        return Math.max(Math.abs(minMax[0]), Math.abs(minMax[1]));
    }
}

