/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.tigr.util.swing.ImageFileFilter;
import org.tigr.util.swing.Utils;

public class TIFFFileFilter
extends FileFilter
implements ImageFileFilter {
    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(f);
        if (extension != null) {
            return extension.equals("tiff");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "TIFF image files (*.tiff)";
    }

    @Override
    public ImageEncodeParam getImageEncodeParam() {
        TIFFEncodeParam param = new TIFFEncodeParam();
        param.setCompression(1);
        return param;
    }

    @Override
    public String getFileFormat() {
        return "TIFF";
    }
}

