/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ProgressBar
extends JDialog {
    private Frame parent;
    private String title;
    private Color barColor1;
    private Color barColor2;
    private Color textColor;
    private int units = 0;
    private int value = 0;
    private Applet progressBarApplet;
    private Font progressBarFont;
    private JPanel drawingArea;

    public ProgressBar(Frame parent, String title, Color barColor1, Color barColor2, Color textColor, int units) {
        super(parent, title, false);
        this.parent = parent;
        this.title = title;
        this.barColor1 = barColor1;
        this.barColor2 = barColor2;
        this.textColor = textColor;
        this.units = units;
        this.progressBarApplet = new Applet();
        this.progressBarFont = new Font("monospaced", 1, 20);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressBar.this.hide();
                ProgressBar.this.dispose();
            }
        });
        this.drawingArea = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                ProgressBar.this.OnPaint(g);
            }
        };
        this.drawingArea.setPreferredSize(new Dimension(210, 50));
        this.getContentPane().add((Component)this.drawingArea, null);
        this.setSize(210, 50);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension barSize = this.getSize();
        this.setLocation((screenSize.width - barSize.width) / 2, (screenSize.height - barSize.height) / 2);
        this.pack();
        this.show();
        this.requestFocus();
        this.toFront();
    }

    public void OnPaint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.barColor1, 200.0f, 0.0f, this.barColor2);
        g2.setPaint(gp);
        g2.fillRect(5, 5, this.value * 200 / this.units, 40);
        g2.setColor(this.textColor);
        g2.drawRect(5, 5, 200, 40);
        g2.setFont(this.progressBarFont);
        g2.drawString("" + this.value * 100 / this.units + "%", 90, 32);
    }

    public ProgressBar(Frame parent, String title, int units) {
        this(parent, title, new Color(200, 200, 200), new Color(200, 200, 200), Color.black, units);
    }

    public ProgressBar(Frame parent, String title, Color barColor, Color textColor, int units) {
        this(parent, title, barColor, barColor, Color.black, units);
    }

    public void drawProgressBar() {
        if (this.value < this.units) {
            this.show();
        }
    }

    public void increment(int increment) {
        if (this.value < this.units) {
            this.value += increment;
            this.repaint();
        }
        if (this.value >= this.units) {
            this.hide();
            this.dispose();
        }
    }

    public void set(int newvalue) {
        this.value = newvalue;
        this.repaint();
    }
}

