/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileTransferPanel
extends JPanel {
    private static final String FILE_ADD_CMD = "file-add";
    private static final String FILE_DEL_CMD = "file-del";
    private static final String FILE_ALL_ADD_CMD = "file-all-add";
    private static final String FILE_ALL_DEL_CMD = "file-all-del";
    private static final String FILE_CHOOSE = "file-choose";
    private JList availList;
    private JList choosedList;
    private DefaultListModel availModel;
    private DefaultListModel choosedModel;
    private JButton addButton;
    private JButton delButton;
    private JButton addAllButton;
    private JButton delAllButton;
    private FileFilter[] fileFilters;
    private File directory;

    public FileTransferPanel(String currentDirectory, FileFilter[] fileFilters) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new BevelBorder(0));
        this.fileFilters = fileFilters;
        Listener listener = new Listener();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        JPanel dirPanel = this.createDirPanel(currentDirectory);
        this.add((Component)dirPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)new JLabel("Available:"), gbc);
        gbc.gridx = 2;
        this.add((Component)new JLabel("Chosen:"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.availList = this.createList(listener);
        this.availModel = (DefaultListModel)this.availList.getModel();
        JScrollPane scroller = new JScrollPane(this.availList);
        scroller.setPreferredSize(new Dimension(100, 100));
        this.add((Component)scroller, gbc);
        gbc.gridx = 2;
        this.choosedList = this.createList(listener);
        this.choosedModel = (DefaultListModel)this.choosedList.getModel();
        scroller = new JScrollPane(this.choosedList);
        scroller.setPreferredSize(new Dimension(100, 100));
        this.add((Component)scroller, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        JPanel btnsPanel = this.createBtnsPanel(listener);
        this.add((Component)btnsPanel, gbc);
        this.updateDirectory(new File(currentDirectory));
    }

    public File[] getFiles() {
        Object[] list = new File[this.choosedModel.size()];
        this.choosedModel.copyInto(list);
        return list;
    }

    public int getFilesNumber() {
        return this.choosedModel.size();
    }

    private void updateDirectory(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        if (this.directory != null && this.directory.equals(directory)) {
            return;
        }
        this.directory = directory;
        this.availModel.clear();
        this.choosedModel.clear();
        FileSystemView fileSystem = FileSystemView.getFileSystemView();
        File[] list = fileSystem.getFiles(directory, true);
        for (int i = 0; i < list.length; ++i) {
            if (!this.accept(list[i])) continue;
            this.availModel.addElement(list[i]);
        }
        this.updateButtons();
    }

    private boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (this.fileFilters == null) {
            return true;
        }
        for (int i = 0; i < this.fileFilters.length; ++i) {
            if (!this.fileFilters[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    private void addAction() {
        int i;
        int[] indices = this.availList.getSelectedIndices();
        for (i = 0; i < indices.length; ++i) {
            this.choosedModel.addElement(this.availModel.elementAt(indices[i]));
        }
        for (i = 0; i < indices.length; ++i) {
            this.availModel.remove(indices[i] - i);
        }
    }

    private void delAction() {
        int i;
        int[] indices = this.choosedList.getSelectedIndices();
        for (i = 0; i < indices.length; ++i) {
            this.availModel.addElement(this.choosedModel.elementAt(indices[i]));
        }
        for (i = 0; i < indices.length; ++i) {
            this.choosedModel.remove(indices[i] - i);
        }
    }

    private void addAllAction() {
        int SIZE = this.availModel.size();
        for (int i = 0; i < SIZE; ++i) {
            this.choosedModel.addElement(this.availModel.elementAt(i));
        }
        this.availModel.clear();
    }

    private void delAllAction() {
        int SIZE = this.choosedModel.size();
        for (int i = 0; i < SIZE; ++i) {
            this.availModel.addElement(this.choosedModel.elementAt(i));
        }
        this.choosedModel.clear();
    }

    private JList createList(Listener listener) {
        JList<Object> list = new JList<Object>(new DefaultListModel());
        list.setCellRenderer(new ListRenderer());
        list.addListSelectionListener(listener);
        list.addMouseListener(listener);
        return list;
    }

    private JPanel createDirPanel(String currentDirectory) {
        return new DirectoryPanel(currentDirectory);
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        this.addButton = this.createButton("Add", FILE_ADD_CMD, listener);
        this.delButton = this.createButton("Del", FILE_DEL_CMD, listener);
        this.addAllButton = this.createButton("Add All", FILE_ALL_ADD_CMD, listener);
        this.delAllButton = this.createButton("Del All", FILE_ALL_DEL_CMD, listener);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.addButton, gbc);
        ++gbc.gridy;
        panel.add((Component)this.delButton, gbc);
        ++gbc.gridy;
        panel.add((Component)this.addAllButton, gbc);
        ++gbc.gridy;
        panel.add((Component)this.delAllButton, gbc);
        return panel;
    }

    private JButton createButton(String text, String command, ActionListener listener) {
        JButton button = new JButton(text);
        button.setEnabled(false);
        button.setActionCommand(command);
        button.addActionListener(listener);
        return button;
    }

    private void updateButtons() {
        if (this.availModel.isEmpty()) {
            this.addButton.setEnabled(false);
            this.addAllButton.setEnabled(false);
        } else {
            this.addAllButton.setEnabled(true);
            if (this.availList.isSelectionEmpty()) {
                this.addButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(true);
            }
        }
        if (this.choosedModel.isEmpty()) {
            this.delButton.setEnabled(false);
            this.delAllButton.setEnabled(false);
        } else {
            this.delAllButton.setEnabled(true);
            if (this.choosedList.isSelectionEmpty()) {
                this.delButton.setEnabled(false);
            } else {
                this.delButton.setEnabled(true);
            }
        }
    }

    private class DirectoryPanel
    extends JPanel
    implements ActionListener {
        private JTextField textField;

        public DirectoryPanel(String currentDirectory) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            this.add((Component)new JLabel("Directory:"), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 10;
            this.textField = new JTextField(currentDirectory, 30);
            this.textField.setEditable(false);
            this.add((Component)this.textField, gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            JButton chooseBtn = new JButton("Choose...");
            chooseBtn.setActionCommand(FileTransferPanel.FILE_CHOOSE);
            chooseBtn.addActionListener(this);
            this.add((Component)chooseBtn, gbc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(FileTransferPanel.FILE_CHOOSE)) {
                this.chooseDirectory();
            }
        }

        private void chooseDirectory() {
            JFileChooser filechooser = new JFileChooser();
            filechooser.setCurrentDirectory(new File(this.textField.getText()));
            filechooser.setDialogTitle("Choose a directory");
            filechooser.setFileSelectionMode(1);
            int ret = filechooser.showOpenDialog(this);
            if (ret == 0) {
                File dir = filechooser.getSelectedFile();
                this.textField.setText(dir.getPath());
                FileTransferPanel.this.updateDirectory(dir);
            }
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            this.setText(file.getName());
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            Object source = e.getSource();
            if (source == FileTransferPanel.this.availList) {
                FileTransferPanel.this.addAction();
            } else if (source == FileTransferPanel.this.choosedList) {
                FileTransferPanel.this.delAction();
            }
            FileTransferPanel.this.updateButtons();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(FileTransferPanel.FILE_ADD_CMD)) {
                FileTransferPanel.this.addAction();
            } else if (command.equals(FileTransferPanel.FILE_DEL_CMD)) {
                FileTransferPanel.this.delAction();
            } else if (command.equals(FileTransferPanel.FILE_ALL_ADD_CMD)) {
                FileTransferPanel.this.addAllAction();
            } else if (command.equals(FileTransferPanel.FILE_ALL_DEL_CMD)) {
                FileTransferPanel.this.delAllAction();
            }
            FileTransferPanel.this.updateButtons();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FileTransferPanel.this.updateButtons();
        }
    }
}

