/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.tigr.util.swing.FileTransferPanel;

public class FileTransferDialog
extends JDialog {
    private int result;
    private FileTransferPanel transferPanel;

    public FileTransferDialog(JFrame parent, String currentDirectory, FileFilter[] fileFilters) {
        super(parent, "Select Files", true);
        Listener listener = new Listener();
        this.transferPanel = new FileTransferPanel(currentDirectory, fileFilters);
        JPanel btnsPanel = this.createBtnsPanel(listener);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)this.transferPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        content.add((Component)btnsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public File[] getFiles() {
        return this.transferPanel.getFiles();
    }

    private JPanel createBtnsPanel(ActionListener listener) {
        GridLayout gridLayout = new GridLayout();
        JPanel panel = new JPanel(gridLayout);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(listener);
        panel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(listener);
        gridLayout.setHgap(4);
        panel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        return panel;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                FileTransferDialog.this.result = 0;
                FileTransferDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                FileTransferDialog.this.result = 2;
                FileTransferDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FileTransferDialog.this.result = -1;
            FileTransferDialog.this.dispose();
        }
    }
}

