/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.tigr.util.awt.GBA;

public class TransferDialog
extends JDialog {
    private List availableList;
    private List selectedList;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel availableLabel;
    private JLabel selectedLabel;
    private EventListener eventListener;
    private ActionListener listeners;
    private String[] selectedItems;
    private GBA gba = new GBA();

    public TransferDialog(JFrame parentFrame, String title, boolean modal, Vector availableVector, Vector selectedVector) {
        super(parentFrame, title, modal);
        int i;
        this.eventListener = new EventListener();
        this.addWindowListener(this.eventListener);
        Container cc = this.getContentPane();
        cc.setLayout(new GridBagLayout());
        this.selectedItems = new String[0];
        this.availableList = new List();
        this.availableList.setMultipleMode(true);
        try {
            for (i = 0; i < availableVector.size(); ++i) {
                this.availableList.add((String)availableVector.elementAt(i));
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.selectedList = new List();
        this.selectedList.setMultipleMode(true);
        try {
            for (i = 0; i < selectedVector.size(); ++i) {
                this.selectedList.add((String)selectedVector.elementAt(i));
            }
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        this.addButton = new JButton("Add (->)");
        this.addButton.addActionListener(this.eventListener);
        this.addAllButton = new JButton("Add All (=>>)");
        this.addAllButton.addActionListener(this.eventListener);
        this.removeAllButton = new JButton("Remove All (<<=)");
        this.removeAllButton.addActionListener(this.eventListener);
        this.removeButton = new JButton("Remove (<-)");
        this.removeButton.addActionListener(this.eventListener);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.eventListener);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this.eventListener);
        this.availableLabel = new JLabel("Available");
        this.selectedLabel = new JLabel("Selected");
        this.gba.add(cc, this.availableList, 0, 0, 1, 6, 1, 1, 1, 10, new Insets(5, 5, 5, 0), 0, 0);
        this.gba.add(cc, this.selectedList, 2, 0, 1, 6, 1, 1, 1, 10, new Insets(5, 0, 5, 5), 0, 0);
        this.gba.add(cc, this.addButton, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.addAllButton, 1, 1, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.removeAllButton, 1, 2, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.removeButton, 1, 3, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.cancelButton, 1, 4, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.okButton, 1, 6, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.availableLabel, 0, 6, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(cc, this.selectedLabel, 2, 6, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
    }

    public boolean hasSelectedItems() {
        return this.selectedItems.length >= 1;
    }

    public String[] getSelectedItems() {
        return this.selectedItems;
    }

    public void addActionListener(ActionListener al) {
        this.listeners = AWTEventMulticaster.add(this.listeners, al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, al);
    }

    static /* synthetic */ String[] access$902(TransferDialog x0, String[] x1) {
        x0.selectedItems = x1;
        return x1;
    }

    private class EventListener
    implements ActionListener,
    WindowListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == TransferDialog.this.addButton) {
                String[] chosen = TransferDialog.this.availableList.getSelectedItems();
                for (int i = 0; i < chosen.length; ++i) {
                    TransferDialog.this.availableList.remove(chosen[i]);
                    TransferDialog.this.selectedList.add(chosen[i]);
                }
            } else if (event.getSource() == TransferDialog.this.addAllButton) {
                String[] available = TransferDialog.this.availableList.getItems();
                for (int i = 0; i < available.length; ++i) {
                    TransferDialog.this.availableList.remove(available[i]);
                    TransferDialog.this.selectedList.add(available[i]);
                }
            } else if (event.getSource() == TransferDialog.this.removeAllButton) {
                String[] selected = TransferDialog.this.selectedList.getItems();
                for (int i = 0; i < selected.length; ++i) {
                    TransferDialog.this.selectedList.remove(selected[i]);
                    TransferDialog.this.availableList.add(selected[i]);
                }
            } else if (event.getSource() == TransferDialog.this.removeButton) {
                String[] chosen = TransferDialog.this.selectedList.getSelectedItems();
                for (int i = 0; i < chosen.length; ++i) {
                    TransferDialog.this.selectedList.remove(chosen[i]);
                    TransferDialog.this.availableList.add(chosen[i]);
                }
            } else if (event.getSource() == TransferDialog.this.cancelButton) {
                TransferDialog.this.dispose();
            } else if (event.getSource() == TransferDialog.this.okButton) {
                String[] selected = TransferDialog.this.selectedList.getItems();
                TransferDialog.access$902(TransferDialog.this, selected);
                TransferDialog.this.dispose();
                if (TransferDialog.this.listeners != null) {
                    TransferDialog.this.listeners.actionPerformed(new ActionEvent(this, event.getID(), event.getActionCommand()));
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            TransferDialog.this.dispose();
        }

        @Override
        public void windowOpened(WindowEvent event) {
        }

        @Override
        public void windowClosed(WindowEvent event) {
        }

        @Override
        public void windowIconified(WindowEvent event) {
        }

        @Override
        public void windowDeiconified(WindowEvent event) {
        }

        @Override
        public void windowActivated(WindowEvent event) {
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
        }
    }
}

