/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.util.awt.GBA;

public class ProgressDialog
extends JDialog {
    protected JFrame parent;
    protected String title;
    protected Container contentPane;
    protected GBA gba;
    protected JPanel labelPanel;
    protected JPanel mainPanel;
    protected JLabel[] labels;
    protected Vector timers;

    public ProgressDialog(JFrame parent, String title, boolean modal, int labelCount) {
        super(parent, title, modal);
        this.parent = parent;
        this.title = title;
        this.labels = new JLabel[labelCount];
        this.mainPanel = new JPanel(new GridBagLayout());
        this.contentPane = this.getContentPane();
        this.gba = new GBA();
        this.timers = new Vector();
        this.initializeGUI();
    }

    public void initializeGUI() {
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.contentPane.setLayout(new GridBagLayout());
        this.contentPane.setBackground(Color.white);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(Color.white);
        this.labelPanel.setBorder(BorderFactory.createBevelBorder(1));
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel(this.title);
            this.labels[i].setBackground(Color.white);
            this.gba.add(this.labelPanel, this.labels[i], 0, i, 1, 1, 1, 0, 2, 10);
        }
        this.gba.add(this.mainPanel, this.labelPanel, 0, 0, 1, 1, 1, 1, 1, 10);
        this.gba.add(this.contentPane, new HeaderImagePanel(), 0, 0, 1, 1, 1, 0, 1, 17);
        this.gba.add(this.contentPane, this.mainPanel, 0, 1, 1, 1, 1, 1, 1, 10);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = this.getSize();
        this.setLocation((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        this.setResizable(false);
        this.pack();
        this.setSize(405, 350);
    }

    public JPanel getLabelPanel() {
        return this.labelPanel;
    }

    public void setMainPanel(JPanel panel) {
        this.gba.add(this.mainPanel, panel, 0, 0, 1, 1, 1, 1, 1, 10);
        this.repaint();
    }

    public void setMessage(int labelIndex, String message) {
        this.setMessage(labelIndex, message, Color.black);
    }

    public void setMessage(int labelIndex, String message, Color color) {
        if (labelIndex >= this.labels.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        JLabel label = this.labels[labelIndex];
        if (label != null) {
            label.setForeground(color);
            label.setText(message);
            label.repaint();
        }
    }

    public void dismiss() {
        this.setVisible(false);
        for (int i = 0; i < this.timers.size(); ++i) {
            ((TimerThread)this.timers.elementAt(i)).setRunning(false);
        }
        this.dispose();
    }

    public void setTimerLabel(int labelIndex, String preString, String postString, int ms) {
        TimerThread timerThread = new TimerThread(labelIndex, preString, postString, ms);
        timerThread.setPriority(1);
        this.timers.addElement(timerThread);
        timerThread.start();
    }

    public static void main(String[] args) {
        ProgressDialog d = new ProgressDialog(new JFrame(), "Test Progress Dialog", true, 5);
        d.show();
        System.exit(0);
    }

    public class FillPanel
    extends JPanel {
        GradientPaint gp;
        Color backgroundColor = new Color(25, 25, 169);
        Color fadeColor = new Color(140, 220, 240);

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            this.gp = new GradientPaint(0.0f, dim.height / 2, this.backgroundColor, dim.width, dim.height / 2, this.fadeColor);
            g2.setPaint(this.gp);
            g2.fillRect(0, 0, dim.width, dim.height);
            g2.setColor(Color.black);
        }
    }

    public class HeaderImagePanel
    extends JPanel {
        public HeaderImagePanel() {
            JLabel iconLabel;
            this.setLayout(new GridBagLayout());
            URL url = HeaderImagePanel.class.getResource("/org/tigr/microarray/mev/cluster/gui/impl/images/dialog_banner2.gif");
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                iconLabel = new JLabel(icon);
            } else {
                iconLabel = new JLabel();
            }
            iconLabel.setOpaque(false);
            iconLabel.setAlignmentX(0.0f);
            FillPanel fillPanel = new FillPanel();
            fillPanel.setBackground(Color.blue);
            this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)fillPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private class TimerThread
    extends Thread {
        public boolean running = true;
        private int labelIndex;
        private String preString;
        private String postString;
        private int ms;

        public TimerThread(int labelIndex, String preString, String postString, int ms) {
            this.labelIndex = labelIndex;
            this.preString = preString;
            this.postString = postString;
            this.ms = ms;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                while (this.running) {
                    long currentTime = System.currentTimeMillis();
                    long seconds = (long)((float)(currentTime - startTime) / 1000.0f);
                    ProgressDialog.this.setMessage(this.labelIndex, this.preString + seconds + this.postString);
                    TimerThread.sleep(this.ms);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setRunning(boolean value) {
            this.running = value;
        }
    }
}

