/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.tigr.util.awt.Drawable;
import org.tigr.util.awt.GBA;

public class ProgressBar
extends JDialog {
    private JFrame parent;
    private String title;
    private Color barColor1;
    private Color barColor2;
    private Color textColor;
    private int units = 0;
    private int value = 0;
    private Font progressBarFont;
    private ProgressBarCanvas canvas;
    private Container contentPane;
    private GBA gba;

    public ProgressBar(JFrame parent, String title, Color barColor1, Color barColor2, Color textColor, int units) {
        super(parent, title, false);
        this.parent = parent;
        this.title = title;
        this.barColor1 = barColor1;
        this.barColor2 = barColor2;
        this.textColor = textColor;
        this.units = units;
        this.progressBarFont = new Font("monospaced", 1, 20);
        this.contentPane = this.getContentPane();
        this.gba = new GBA();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressBar.this.hide();
            }
        });
        this.canvas = new ProgressBarCanvas(200, 50, 5, 5, 5, 5);
        this.contentPane.setLayout(new GridBagLayout());
        this.gba.add(this.contentPane, this.canvas, 0, 0, 1, 1, 1, 1, 1, 10);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension barSize = this.getSize();
        this.setLocation((screenSize.width - barSize.width) / 2, (screenSize.height - barSize.height) / 2);
        this.setResizable(true);
        this.pack();
        this.show();
        this.requestFocus();
    }

    public ProgressBar(JFrame parent, String title, int units) {
        this(parent, title, Color.green, Color.green, Color.black, units);
    }

    public void drawProgressBar() {
        if (this.value < this.units) {
            this.setVisible(true);
        }
    }

    public void increment(int increment) {
        if (this.value < this.units) {
            this.value += increment;
            if (this.value * 100 / this.units != (this.value - increment) * 100 / this.units) {
                this.canvas.paint(this.canvas.getGraphics());
            }
        }
        if (this.value >= this.units) {
            this.complete();
        }
    }

    public void complete() {
        this.hide();
        this.dispose();
    }

    private class ProgressBarCanvas
    extends Drawable {
        private int width;
        private int height;
        private int preXSpacing;
        private int postXSpacing;
        private int preYSpacing;
        private int postYSpacing;

        public ProgressBarCanvas(int width, int height, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing) {
            super(0, preXSpacing + width + postXSpacing, 0, preYSpacing + height + postYSpacing);
            this.width = width;
            this.height = height;
            this.preXSpacing = preXSpacing;
            this.postXSpacing = postXSpacing;
            this.preYSpacing = preYSpacing;
            this.postYSpacing = postYSpacing;
            this.setPreferredSize(new Dimension(preXSpacing + width + postXSpacing, preYSpacing + height + postYSpacing));
            this.setBackground(Color.white);
        }

        @Override
        public void controlPaint(Graphics g1D) {
            Graphics2D g = (Graphics2D)g1D;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(new GradientPaint(0.0f, 0.0f, ProgressBar.this.barColor1, this.width, 0.0f, ProgressBar.this.barColor2));
            g.fillRect(this.preXSpacing, this.preYSpacing, ProgressBar.this.value * this.width / ProgressBar.this.units, this.height);
            this.drawRect(g, this.preXSpacing, this.preYSpacing, this.width, this.height, ProgressBar.this.textColor);
            this.drawString(g, "" + ProgressBar.this.value * 100 / ProgressBar.this.units + "%", 90, 36, ProgressBar.this.textColor, ProgressBar.this.progressBarFont);
        }
    }
}

