/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.JPanel;

public abstract class Drawable
extends JPanel {
    protected int startX;
    protected int stopX;
    protected int startY;
    protected int stopY;

    public Drawable(int startX, int stopX, int startY, int stopY) {
        this.startX = startX;
        this.stopX = stopX;
        this.startY = startY;
        this.stopY = stopY;
        this.setDoubleBuffered(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.controlPaint(g);
    }

    public void setCursor(int cursor) {
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public void drawPoint(Graphics2D g, Point point, Color color) {
        this.drawPoint(g, point.x, point.y, color);
    }

    public void drawPoint(Graphics2D g, int x, int y, Color color) {
        g.setColor(color);
        g.drawLine(x, y, x, y);
    }

    public void drawPoint(Graphics2D g, Point point) {
        this.drawPoint(g, point, this.getBackground());
    }

    public void drawPoint(Graphics2D g, int x, int y) {
        this.drawPoint(g, x, y, this.getBackground());
    }

    public void drawLine(Graphics2D g, int x1, int y1, int x2, int y2, Color color) {
        g.setColor(color);
        g.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        this.drawLine(g, x1, y1, x2, y2, this.getBackground());
    }

    public final void drawRect(Graphics2D g, int x, int y, int width, int height, Color color) {
        g.setColor(color);
        g.drawRect(x, y, width, height);
    }

    public final void fillRect(Graphics2D g, int x, int y, int width, int height, Color color) {
        g.setColor(color);
        g.fillRect(x, y, width, height);
    }

    public void drawString(Graphics2D g, String string, int x, int y, Color color, Font font) {
        g.setFont(font);
        g.setColor(color);
        g.drawString(string, x, y);
    }

    public void drawString(Graphics2D g, String string, int x, int y, Color color) {
        g.setColor(color);
        g.drawString(string, x, y);
    }

    public abstract void controlPaint(Graphics var1);
}

