/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.awt;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.GBA;

public class BoundariesDialog
extends ActionInfoDialog {
    private JFrame parent;
    JLabel lowerxLabel;
    JLabel upperxLabel;
    JLabel loweryLabel;
    JLabel upperyLabel;
    JTextField lowerxTextField;
    JTextField upperxTextField;
    JTextField loweryTextField;
    JTextField upperyTextField;
    JButton okButton;
    JButton cancelButton;
    Font boundariesDialogFont;
    GBA gba;

    public BoundariesDialog(JFrame parent, double lowerx, double upperx, double lowery, double uppery) {
        super(parent, true);
        try {
            this.parent = parent;
            this.gba = new GBA();
            this.lowerxLabel = new JLabel("Lower X: (" + lowerx + ")");
            this.upperxLabel = new JLabel("Upper X: (" + upperx + ")");
            this.loweryLabel = new JLabel("Lower Y: (" + lowery + ")");
            this.upperyLabel = new JLabel("Upper Y: (" + uppery + ")");
            this.lowerxTextField = new JTextField(12);
            this.lowerxTextField.setText("" + lowerx);
            this.upperxTextField = new JTextField(12);
            this.upperxTextField.setText("" + upperx);
            this.loweryTextField = new JTextField(12);
            this.loweryTextField.setText("" + lowery);
            this.upperyTextField = new JTextField(12);
            this.upperyTextField.setText("" + uppery);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new EventListener());
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new EventListener());
            this.contentPane.setLayout(new GridBagLayout());
            this.gba.add(this.contentPane, this.upperyLabel, 1, 0, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.lowerxLabel, 0, 1, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.upperyTextField, 1, 1, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.upperxLabel, 2, 1, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.lowerxTextField, 0, 2, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.loweryLabel, 1, 2, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.upperxTextField, 2, 2, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.cancelButton, 0, 3, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.loweryTextField, 1, 3, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.gba.add(this.contentPane, this.okButton, 2, 3, 1, 1, 1, 1, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.pack();
            this.setResizable(false);
            this.setTitle("Set Graph Boundaries");
            this.okButton.grabFocus();
            this.setLocation(300, 300);
        }
        catch (Exception e) {
            System.out.println("Exception (DatabaseLoginDialog.const()): " + e);
        }
    }

    class EventListener
    implements ActionListener,
    KeyListener {
        EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == BoundariesDialog.this.okButton) {
                String lowerx = BoundariesDialog.this.lowerxTextField.getText();
                String upperx = BoundariesDialog.this.upperxTextField.getText();
                String lowery = BoundariesDialog.this.loweryTextField.getText();
                String uppery = BoundariesDialog.this.upperyTextField.getText();
                BoundariesDialog.this.hide();
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put(new String("lowerx"), lowerx);
                hash.put(new String("upperx"), upperx);
                hash.put(new String("lowery"), lowery);
                hash.put(new String("uppery"), uppery);
                BoundariesDialog.this.fireEvent(new ActionInfoEvent(this, hash));
                BoundariesDialog.this.dispose();
            } else if (event.getSource() == BoundariesDialog.this.cancelButton) {
                BoundariesDialog.this.dispose();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                String lowerx = BoundariesDialog.this.lowerxTextField.getText();
                String upperx = BoundariesDialog.this.upperxTextField.getText();
                String lowery = BoundariesDialog.this.loweryTextField.getText();
                String uppery = BoundariesDialog.this.upperyTextField.getText();
                BoundariesDialog.this.hide();
                Hashtable<String, String> hash = new Hashtable<String, String>();
                hash.put(new String("lowerx"), lowerx);
                hash.put(new String("upperx"), upperx);
                hash.put(new String("lowery"), lowery);
                hash.put(new String("uppery"), uppery);
                BoundariesDialog.this.fireEvent(new ActionInfoEvent(this, hash));
                BoundariesDialog.this.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }
}

