/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class Query {
    private String queryString;
    private static final int SYBASE = 0;
    private static final int MYSQL = 1;

    public Query(String queryString) {
        this.queryString = queryString;
    }

    public Vector execute(Connection c) throws SQLException {
        return this.execute(c, true);
    }

    public Vector execute(Connection c, boolean returnHeadings) throws SQLException {
        Vector<String[]> resultVector = null;
        Statement s = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int columnCount = 0;
        resultVector = new Vector<String[]>();
        s = c.createStatement();
        boolean isQuery = s.execute(this.queryString);
        if (isQuery) {
            int i;
            rs = s.getResultSet();
            rsmd = rs.getMetaData();
            columnCount = rsmd.getColumnCount();
            if (returnHeadings) {
                String[] columnLabels = new String[columnCount];
                for (i = 0; i < columnCount; ++i) {
                    columnLabels[i] = rsmd.getColumnLabel(i + 1);
                }
                if (columnLabels.length > 0) {
                    resultVector.addElement(columnLabels);
                }
            }
            while (rs.next()) {
                String[] rowResults = new String[columnCount];
                for (i = 0; i < columnCount; ++i) {
                    try {
                        if (rs.getObject(i + 1).toString().trim() == null) {
                            rowResults[i] = "null";
                            continue;
                        }
                        rowResults[i] = rs.getObject(i + 1).toString().trim();
                        continue;
                    }
                    catch (NullPointerException npe) {
                        rowResults[i] = "null";
                    }
                }
                resultVector.addElement(rowResults);
            }
        } else {
            if (returnHeadings) {
                resultVector.addElement(new String[]{"Rows affected"});
            }
            resultVector.addElement(new String[]{"" + s.getUpdateCount()});
        }
        for (SQLWarning w = c.getWarnings(); w != null; w = w.getNextWarning()) {
            System.out.println("SQLWarning: " + w.getMessage() + ": " + w.getSQLState());
        }
        if (rs != null) {
            rs.close();
        }
        s.close();
        return resultVector;
    }

    public Vector executeQuery(Connection c) throws SQLException {
        return this.executeQuery(c, true);
    }

    public Vector executeQuery(Connection c, boolean returnHeadings) throws SQLException {
        int i;
        Vector<String[]> resultVector = null;
        Statement s = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        int columnCount = 0;
        resultVector = new Vector<String[]>();
        s = c.createStatement();
        rs = s.executeQuery(this.queryString);
        rsmd = rs.getMetaData();
        columnCount = rsmd.getColumnCount();
        if (returnHeadings) {
            String[] columnLabels = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                columnLabels[i] = rsmd.getColumnLabel(i + 1);
            }
            if (columnLabels.length > 0) {
                resultVector.addElement(columnLabels);
            }
        }
        while (rs.next()) {
            String[] rowResults = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                try {
                    if (rs.getObject(i + 1).toString().trim() == null) {
                        rowResults[i] = "null";
                        continue;
                    }
                    rowResults[i] = rs.getObject(i + 1).toString().trim();
                    continue;
                }
                catch (NullPointerException npe) {
                    rowResults[i] = "null";
                }
            }
            resultVector.addElement(rowResults);
        }
        for (SQLWarning w = c.getWarnings(); w != null; w = w.getNextWarning()) {
            System.out.println("SQLWarning: " + w.getMessage() + ": " + w.getSQLState());
        }
        if (rs != null) {
            rs.close();
        }
        s.close();
        return resultVector;
    }

    public int executeUpdate(Connection c) throws SQLException {
        int updateCount = 0;
        Statement s = c.createStatement();
        updateCount = s.executeUpdate(this.queryString);
        for (SQLWarning w = c.getWarnings(); w != null; w = w.getNextWarning()) {
            System.out.println("SQLWarning: " + w.getMessage() + ": " + w.getSQLState());
        }
        s.close();
        return updateCount;
    }

    public static Vector resultsToList(Vector results) {
        Vector<String> resultVector = new Vector<String>();
        for (int i = 0; i < results.size(); ++i) {
            String[] rowResults = (String[])results.elementAt(i);
            resultVector.addElement(rowResults[0]);
        }
        return resultVector;
    }

    public void setQueryStatement(String code) {
        this.queryString = code;
    }

    public static Vector resultsToVectors(Vector results) {
        Vector resultVector = new Vector();
        for (int i = 0; i < results.size(); ++i) {
            Vector<String> newResults = new Vector<String>();
            String[] rowResults = (String[])results.elementAt(i);
            for (int j = 0; j < rowResults.length; ++j) {
                newResults.addElement(rowResults[j]);
            }
            resultVector.addElement(newResults);
        }
        return resultVector;
    }

    public String toString() {
        return this.queryString;
    }

    public static void beginTransaction(Connection c, int dbSys) throws SQLException {
        c.setAutoCommit(false);
        Statement stmt = c.createStatement();
        if (dbSys == 1) {
            stmt.execute("BEGIN");
        } else if (dbSys == 0) {
            stmt.execute("SET CHAINED OFF");
            stmt.execute("BEGIN TRANSACTION");
        } else {
            System.out.println("Error: No DBMS found.");
        }
    }

    public static void endTransaction(Connection c) throws SQLException {
        c.commit();
        c.setAutoCommit(true);
    }

    public static void abortTransaction(Connection c) throws SQLException {
        c.rollback();
        c.setAutoCommit(true);
    }
}

