/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.util.Vector;

public class QSort {
    private int[] origIndx;
    private float[] sorted;
    private double[] sortedDouble;
    private int[] NaNIndices;
    private int[] negInfinityIndices;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    private boolean ascending;

    public QSort(float[] origA) {
        int i;
        float[] copyA = new float[origA.length];
        this.ascending = true;
        Vector<Integer> NaNIndicesVector = new Vector<Integer>();
        Vector<Integer> negInfinityIndicesVector = new Vector<Integer>();
        for (i = 0; i < copyA.length; ++i) {
            copyA[i] = origA[i];
            if (Float.isNaN(origA[i])) {
                NaNIndicesVector.add(new Integer(i));
                copyA[i] = Float.NEGATIVE_INFINITY;
            }
            if (!Float.isInfinite(origA[i]) || !(origA[i] < 0.0f)) continue;
            negInfinityIndicesVector.add(new Integer(i));
        }
        this.NaNIndices = new int[NaNIndicesVector.size()];
        for (i = 0; i < this.NaNIndices.length; ++i) {
            this.NaNIndices[i] = (Integer)NaNIndicesVector.get(i);
        }
        this.negInfinityIndices = new int[negInfinityIndicesVector.size()];
        for (i = 0; i < this.negInfinityIndices.length; ++i) {
            this.negInfinityIndices[i] = (Integer)negInfinityIndicesVector.get(i);
        }
        this.sort(copyA);
    }

    public QSort(double[] origA) {
        int i;
        double[] copyA = new double[origA.length];
        this.ascending = true;
        Vector<Integer> NaNIndicesVector = new Vector<Integer>();
        Vector<Integer> negInfinityIndicesVector = new Vector<Integer>();
        for (i = 0; i < copyA.length; ++i) {
            copyA[i] = origA[i];
            if (Double.isNaN(origA[i])) {
                NaNIndicesVector.add(new Integer(i));
                copyA[i] = Double.NEGATIVE_INFINITY;
            }
            if (!Double.isInfinite(origA[i]) || !(origA[i] < 0.0)) continue;
            negInfinityIndicesVector.add(new Integer(i));
        }
        this.NaNIndices = new int[NaNIndicesVector.size()];
        for (i = 0; i < this.NaNIndices.length; ++i) {
            this.NaNIndices[i] = (Integer)NaNIndicesVector.get(i);
        }
        this.negInfinityIndices = new int[negInfinityIndicesVector.size()];
        for (i = 0; i < this.negInfinityIndices.length; ++i) {
            this.negInfinityIndices[i] = (Integer)negInfinityIndicesVector.get(i);
        }
        this.sort(copyA);
    }

    public QSort(float[] origA, int ascOrDesc) {
        this(origA);
        if (ascOrDesc == 1) {
            this.ascending = true;
        } else if (ascOrDesc == 2) {
            this.ascending = false;
        }
    }

    public QSort(double[] origA, int ascOrDesc) {
        this(origA);
        if (ascOrDesc == 1) {
            this.ascending = true;
        } else if (ascOrDesc == 2) {
            this.ascending = false;
        }
    }

    public void sort(float[] a) {
        this.origIndx = new int[a.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(a, 0, a.length - 1);
    }

    public void sort(double[] a) {
        this.origIndx = new int[a.length];
        for (int i = 0; i <= this.origIndx.length - 1; ++i) {
            this.origIndx[i] = i;
        }
        this.quickSort(a, 0, a.length - 1);
    }

    void quickSort(float[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            float mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
        this.sorted = a;
    }

    void quickSort(double[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
        this.sortedDouble = a;
    }

    private void swap(float[] a, int i, int j) {
        float T = a[i];
        a[i] = a[j];
        a[j] = T;
        int TT = this.origIndx[i];
        this.origIndx[i] = this.origIndx[j];
        this.origIndx[j] = TT;
    }

    private void swap(double[] a, int i, int j) {
        double T = a[i];
        a[i] = a[j];
        a[j] = T;
        int TT = this.origIndx[i];
        this.origIndx[i] = this.origIndx[j];
        this.origIndx[j] = TT;
    }

    public float[] getSorted() {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            this.sorted[i] = Float.NaN;
        }
        if (!this.ascending) {
            float[] revSorted = this.reverse(this.sorted);
            return revSorted;
        }
        return this.sorted;
    }

    public double[] getSortedDouble() {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            this.sortedDouble[i] = Double.NaN;
        }
        if (!this.ascending) {
            double[] revSortedDouble = this.reverse(this.sortedDouble);
            return revSortedDouble;
        }
        return this.sortedDouble;
    }

    public int[] getOrigIndx() {
        int i;
        for (i = 0; i < this.NaNIndices.length; ++i) {
            this.origIndx[i] = this.NaNIndices[i];
        }
        for (i = this.NaNIndices.length; i < this.NaNIndices.length + this.negInfinityIndices.length; ++i) {
            this.origIndx[i] = this.negInfinityIndices[i - this.NaNIndices.length];
        }
        if (!this.ascending) {
            return this.reverse(this.origIndx);
        }
        return this.origIndx;
    }

    private boolean isNaNIndex(int index) {
        for (int i = 0; i < this.NaNIndices.length; ++i) {
            if (index != this.NaNIndices[i]) continue;
            return true;
        }
        return false;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private float[] reverse(float[] arr) {
        float[] revArr = new float[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private double[] reverse(double[] arr) {
        double[] revArr = new double[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    public static void main(String[] args) {
        double[] arr = new double[]{120.0, 0.01, -4.5, Double.NaN, 7.6, -65.0, Double.NEGATIVE_INFINITY, 3.5, -0.95, Double.POSITIVE_INFINITY, 600.0, Double.NaN, 65.0, Double.NEGATIVE_INFINITY, Double.MAX_VALUE};
        QSort sortArr = new QSort(arr, 1);
        double[] sortedArr = sortArr.getSortedDouble();
        int[] sortedArrIndices = sortArr.getOrigIndx();
        for (int i = 0; i < sortedArr.length; ++i) {
            System.out.println("arr[" + i + "] = " + arr[i] + ", sortedArr[" + i + "] = " + sortedArr[i] + ",  sortedArrIndices[" + i + "] = " + sortedArrIndices[i]);
        }
    }
}

