/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

public class IntArray {
    private int[] elementData;
    private int size;

    public IntArray(int initialCapacity) {
        this.elementData = new int[initialCapacity];
    }

    public int[] toArray() {
        int[] result = new int[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public int get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public void set(int index, int value) {
        this.RangeCheck(index);
        this.elementData[index] = value;
    }

    public boolean add(int i) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = i;
        return true;
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }
}

