/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import org.tigr.util.LUDecomposition;
import org.tigr.util.Maths;
import org.tigr.util.QRDecomposition;

public class FloatMatrix
implements Cloneable {
    public float[][] A;
    public int m;
    public int n;

    public FloatMatrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new float[m][n];
    }

    public FloatMatrix(int m, int n, float s) {
        this.m = m;
        this.n = n;
        this.A = new float[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.A[i][j] = s;
            }
        }
    }

    public FloatMatrix(float[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (A[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = A;
    }

    public FloatMatrix(float[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public FloatMatrix(float[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new float[m][this.n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = vals[i + j * m];
            }
        }
    }

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"array", "rowDimension", "columnDimension"};
    }

    public static FloatMatrix constructWithCopy(float[][] A) {
        int m = A.length;
        int n = A[0].length;
        FloatMatrix X = new FloatMatrix(m, n);
        float[][] C = X.getArray();
        for (int i = 0; i < m; ++i) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix copy() {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j];
            }
        }
        return X;
    }

    public Object clone() {
        return this.copy();
    }

    public float[][] getArray() {
        return this.A;
    }

    public float[][] getArrayCopy() {
        float[][] C = new float[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j];
            }
        }
        return C;
    }

    public float[] getColumnPackedCopy() {
        float[] vals = new float[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                vals[i + j * this.m] = this.A[i][j];
            }
        }
        return vals;
    }

    public float[] getRowPackedCopy() {
        float[] vals = new float[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                vals[i * this.n + j] = this.A[i][j];
            }
        }
        return vals;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public float get(int i, int j) {
        return this.A[i][j];
    }

    public FloatMatrix getMatrix(int i0, int i1, int j0, int j1) {
        FloatMatrix X = new FloatMatrix(i1 - i0 + 1, j1 - j0 + 1);
        float[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i - i0][j - j0] = this.A[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int[] r, int[] c) {
        FloatMatrix X = new FloatMatrix(r.length, c.length);
        float[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i][j] = this.A[r[i]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int i0, int i1, int[] c) {
        FloatMatrix X = new FloatMatrix(i1 - i0 + 1, c.length);
        float[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i - i0][j] = this.A[i][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public FloatMatrix getMatrix(int[] r, int j0, int j1) {
        FloatMatrix X = new FloatMatrix(r.length, j1 - j0 + 1);
        float[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i][j - j0] = this.A[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public void set(int i, int j, float s) {
        this.A[i][j] = s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, FloatMatrix X) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.A[i][j] = X.get(i - i0, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, FloatMatrix X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.A[r[i]][c[j]] = X.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, FloatMatrix X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.A[r[i]][j] = X.get(i, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, FloatMatrix X) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.A[i][c[j]] = X.get(i - i0, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public FloatMatrix transpose() {
        FloatMatrix X = new FloatMatrix(this.n, this.m);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[j][i] = this.A[i][j];
            }
        }
        return X;
    }

    public float norm1() {
        float f = 0.0f;
        for (int j = 0; j < this.n; ++j) {
            float s = 0.0f;
            for (int i = 0; i < this.m; ++i) {
                s += Math.abs(this.A[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public float normInf() {
        float f = 0.0f;
        for (int i = 0; i < this.m; ++i) {
            float s = 0.0f;
            for (int j = 0; j < this.n; ++j) {
                s += Math.abs(this.A[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public float normF() {
        float f = 0.0f;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                f = Maths.hypot(f, this.A[i][j]);
            }
        }
        return f;
    }

    public FloatMatrix uminus() {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = -this.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix plus(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j] + B.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix plusEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] + B.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix minus(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j] - B.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix minusEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] - B.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix arrayTimes(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j] * B.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix arrayTimesEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] * B.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix arrayRightDivide(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.A[i][j] / B.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix arrayRightDivideEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] / B.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix arrayLeftDivide(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = B.A[i][j] / this.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix arrayLeftDivideEquals(FloatMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = B.A[i][j] / this.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix times(float s) {
        FloatMatrix X = new FloatMatrix(this.m, this.n);
        float[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = s * this.A[i][j];
            }
        }
        return X;
    }

    public FloatMatrix timesEquals(float s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = s * this.A[i][j];
            }
        }
        return this;
    }

    public FloatMatrix times(FloatMatrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        FloatMatrix X = new FloatMatrix(this.m, B.n);
        float[][] C = X.getArray();
        float[] Bcolj = new float[this.n];
        for (int j = 0; j < B.n; ++j) {
            for (int k = 0; k < this.n; ++k) {
                Bcolj[k] = B.A[k][j];
            }
            for (int i = 0; i < this.m; ++i) {
                float[] Arowi = this.A[i];
                float s = 0.0f;
                for (int k = 0; k < this.n; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                C[i][j] = s;
            }
        }
        return X;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public FloatMatrix solve(FloatMatrix B) {
        return this.m == this.n ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
    }

    public FloatMatrix solveTranspose(FloatMatrix B) {
        return this.transpose().solve(B.transpose());
    }

    public FloatMatrix inverse() {
        return this.solve(FloatMatrix.identity(this.m, this.m));
    }

    public float det() {
        return new LUDecomposition(this).det();
    }

    public float trace() {
        float t = 0.0f;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            t += this.A[i][i];
        }
        return t;
    }

    public static FloatMatrix random(int m, int n) {
        FloatMatrix A = new FloatMatrix(m, n);
        float[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = (float)Math.random();
            }
        }
        return A;
    }

    public static FloatMatrix identity(int m, int n) {
        FloatMatrix A = new FloatMatrix(m, n);
        float[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = (float)(i == j ? 1.0 : 0.0);
            }
        }
        return A;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                String s = format.format(this.A[i][j]);
                int padding = Math.max(1, width - s.length());
                for (int k = 0; k < padding; ++k) {
                    output.print(' ');
                }
                output.print(s);
            }
            output.println();
        }
        output.println();
    }

    public static FloatMatrix read(BufferedReader input) throws IOException {
        int j;
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Object> v = new Vector<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.addElement(Float.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        float[] row = new float[n];
        for (j = 0; j < n; ++j) {
            row[j] = ((Float)v.elementAt(j)).floatValue();
        }
        v.removeAllElements();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new float[n];
            v.addElement(row);
            j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j++] = Float.valueOf(tokenizer.sval).floatValue();
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        float[][] A = new float[m][];
        v.copyInto((Object[])A);
        return new FloatMatrix(A);
    }

    protected void checkMatrixDimensions(FloatMatrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public FloatMatrix getSubMatrix(int displayInterval) {
        if (displayInterval <= 0) {
            return this;
        }
        int sub_m = this.m / displayInterval;
        int sub_n = this.n / displayInterval;
        FloatMatrix X = new FloatMatrix(sub_m, sub_n);
        float[][] C = X.getArray();
        int i = 0;
        for (int k = 0; i < this.m && k < sub_m; i += displayInterval, ++k) {
            int j = 0;
            for (int l = 0; j < this.n && l < sub_n; j += displayInterval, ++l) {
                C[k][l] = this.A[i][j];
            }
        }
        return X;
    }
}

