/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.graph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.BoundariesDialog;
import org.tigr.util.awt.Drawable;
import org.tigr.util.awt.GBA;
import org.tigr.util.awt.Viewer;

public class GraphViewer
extends Viewer {
    public static final long serialVersionUID = 1000101030001L;
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    public static final int HISTOGRAM_BAR_OUTLINE = 2000;
    public static final int HISTOGRAM_BAR_SOLID = 2001;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    protected int startx;
    protected int stopx;
    protected int starty;
    protected int stopy;
    protected double graphstartx;
    protected double graphstopx;
    protected double graphstarty;
    protected double graphstopy;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected double xAxisValue = 0.0;
    protected double yAxisValue = 0.0;
    protected int pointSize;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    protected String title;
    protected String xLabel;
    protected String yLabel;
    protected String subTitle;
    protected JScrollPane scrollPane;
    protected JMenuBar menuBar;
    protected Drawable canvas;
    protected EventListener eventListener;
    protected GBA gba;
    protected boolean referenceLinesOn = true;
    private boolean redrawCachedImage = true;
    private BufferedImage cachedImage;
    protected Vector graphElements;
    protected JPopupMenu popup;
    protected boolean showCoordinates = false;
    protected DecimalFormat coordinateFormat;
    protected FontMetrics metrics;

    public static String[] getPersistenceDelegateArgs() {
        return new String[]{"frame", "startx", "stopx", "starty", "stopy", "graphstartx", "graphstopx", "graphstarty", "graphstopy", "preXSpacing", "postXSpacing", "preYSpacing", "postYSpacing", "title", "xLabel", "yLabel"};
    }

    public GraphViewer(JFrame frame, Integer startx, Integer stopx, Integer starty, Integer stopy, Double graphstartx, Double graphstopx, Double graphstarty, Double graphstopy, Integer preXSpacing, Integer postXSpacing, Integer preYSpacing, Integer postYSpacing, String title, String xLabel, String yLabel) {
        this(frame, (int)startx, (int)stopx, (int)starty, (int)stopy, (double)graphstartx, (double)graphstopx, (double)graphstarty, (double)graphstopy, (int)preXSpacing, (int)postXSpacing, (int)preYSpacing, (int)postYSpacing, title, xLabel, yLabel);
    }

    public GraphViewer(JFrame frame, int startx, int stopx, int starty, int stopy, double graphstartx, double graphstopx, double graphstarty, double graphstopy, int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing, String title, String xLabel, String yLabel) {
        super(frame);
        this.startx = startx;
        this.stopx = stopx;
        this.starty = starty;
        this.stopy = stopy;
        this.graphstartx = graphstartx;
        this.graphstopx = graphstopx;
        this.graphstarty = graphstarty;
        this.graphstopy = graphstopy;
        this.preXSpacing = preXSpacing;
        this.postXSpacing = postXSpacing;
        this.preYSpacing = preYSpacing;
        this.postYSpacing = postYSpacing;
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.initializeViewer();
        this.initializeCanvas();
        if (frame != null) {
            this.initializeFrame();
        }
        this.initializePopupMenu();
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private void initializeViewer() {
        this.setLayout(new GridBagLayout());
        this.eventListener = new EventListener();
        this.gba = new GBA();
        this.graphElements = new Vector();
        this.setBackground(Color.white);
        this.setTickFont("SansSerif", 1, 10);
        this.setLabelFont("SansSerif", 1, 12);
        this.setTitleFont("SansSerif", 1, 16);
        this.setSize(this.stopx - this.startx + this.preXSpacing + this.postXSpacing, this.stopy - this.starty + this.preYSpacing + this.postYSpacing);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
    }

    private void initializeCanvas() {
        this.canvas = new Drawable(this.startx, this.stopx, this.starty, this.stopy){

            @Override
            public void controlPaint(Graphics g) {
                GraphViewer.this.display(g);
            }
        };
        this.canvas.setBackground(Color.white);
        this.canvas.addMouseListener(this.eventListener);
        this.canvas.addMouseMotionListener(this.eventListener);
        this.canvas.setPreferredSize(new Dimension(450, 500));
        this.scrollPane = new JScrollPane(this.canvas);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.gba.add(this, this.scrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
    }

    private void initializeFrame() {
        this.frame.getContentPane().setLayout(new GridBagLayout());
        this.frame.setResizable(true);
        this.frame.setBackground(Color.white);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphViewer.this.close();
            }
        });
        this.initializeMenuBar(this.frame);
        this.gba.add(this.frame.getContentPane(), this, 0, 0, 1, 1, 1, 1, 1, 10);
        this.frame.pack();
    }

    private void initializeMenuBar(JFrame frame) {
        this.menuBar = new JMenuBar();
        frame.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.addActionListener(this.eventListener);
        fileMenu.add(closeItem);
        JMenu controlMenu = new JMenu("Control");
        JMenuItem graphBoundariesItem = new JMenuItem("Set Boundaries");
        graphBoundariesItem.addActionListener(this.eventListener);
        controlMenu.add(graphBoundariesItem);
        graphBoundariesItem.setEnabled(false);
        JCheckBoxMenuItem referenceLinesItem = new JCheckBoxMenuItem("Reference Lines");
        referenceLinesItem.addActionListener(this.eventListener);
        controlMenu.add(referenceLinesItem);
        referenceLinesItem.setSelected(true);
        this.menuBar.add(fileMenu);
        this.menuBar.add(controlMenu);
    }

    protected void initializePopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Set Bounds");
        item.setActionCommand("Set Boundaries");
        item.addActionListener(this.eventListener);
        this.popup.add(item);
        this.popup.addSeparator();
        item = new JMenuItem("Reference Lines");
        item.setActionCommand("Reference Lines");
        item.addActionListener(this.eventListener);
        this.popup.add(item);
    }

    public void display(Graphics g1D) {
        Graphics2D g = (Graphics2D)g1D;
        this.metrics = g.getFontMetrics();
        this.drawGraph(g);
    }

    public void drawGraph(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawSystem(g, 1100);
        for (int i = 0; i < this.graphElements.size(); ++i) {
            GraphElement e = (GraphElement)this.graphElements.elementAt(i);
            if (e instanceof GraphPoint) {
                this.drawPoint(g, (GraphPoint)e);
                continue;
            }
            if (e instanceof GraphBar) {
                this.drawBar(g, (GraphBar)e);
                continue;
            }
            if (e instanceof GraphTick) {
                this.drawTick(g, (GraphTick)e);
                continue;
            }
            if (!(e instanceof GraphLine)) continue;
            this.drawLine(g, (GraphLine)e);
        }
        if (this.referenceLinesOn) {
            boolean onGraph;
            int x = this.getXOldEvent();
            int y = this.getYOldEvent();
            double xVal = 0.0;
            double yVal = 0.0;
            boolean bl = onGraph = x <= this.convertX(this.graphstopx) && x >= this.convertX(this.graphstartx) && y >= this.convertY(this.graphstopy) && y <= this.convertY(this.graphstarty);
            if (onGraph) {
                this.setCursor(1);
                xVal = (double)(x - this.convertX(this.graphstartx)) / this.getXScale() + this.graphstartx;
                yVal = (double)(this.convertY(this.graphstarty) - y) / this.getYScale() + this.graphstarty;
                g.setColor(Color.magenta);
                g.drawLine(x, this.convertY(this.graphstarty), x, this.convertY(this.graphstopy));
                g.drawLine(this.convertX(this.graphstartx), y, this.convertX(this.graphstopx), y);
                if (this.showCoordinates) {
                    int coordinateWidth = this.metrics.stringWidth(this.coordinateFormat.format(xVal) + ", " + this.coordinateFormat.format(yVal));
                    Composite comp = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    g.setColor(Color.blue);
                    g.fillRect(x, y - 15, coordinateWidth + 10, 15);
                    g.setComposite(comp);
                    g.setColor(Color.black);
                    g.drawString(this.coordinateFormat.format(xVal) + ", " + this.coordinateFormat.format(yVal), x + 5, y - 3);
                }
            } else {
                this.setCursor(0);
            }
        }
        this.drawXLabel(g, this.xLabel, Color.black);
        this.drawYLabel(g, this.yLabel, Color.black);
        this.drawTitle(g, this.title, Color.black);
    }

    public void constructImage() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        BufferedImage tempImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(this.canvas.getSize().width, this.canvas.getSize().height);
        g = tempImage.createGraphics();
        this.drawGraph(g);
        this.cachedImage = tempImage;
    }

    public void drawImage(Graphics2D g) {
        g.drawImage((Image)this.cachedImage, 0, 0, this);
    }

    public void addGraphElement(GraphElement e) {
        this.graphElements.addElement(e);
    }

    public void setGraphStartX(double graphStartX) {
        this.graphstartx = graphStartX;
    }

    public double getGraphStartX() {
        return this.graphstartx;
    }

    public void setGraphStopX(double graphStopX) {
        this.graphstopx = graphStopX;
    }

    public double getGraphStopX() {
        return this.graphstopx;
    }

    public void setGraphStartY(double graphStartY) {
        this.graphstarty = graphStartY;
    }

    public double getGraphStartY() {
        return this.graphstarty;
    }

    public void setGraphStopY(double graphStopY) {
        this.graphstopy = graphStopY;
    }

    public double getGraphStopY() {
        return this.graphstopy;
    }

    public double getStartX() {
        return this.startx;
    }

    public double getStartY() {
        return this.starty;
    }

    public int getStopX() {
        return this.stopx;
    }

    public int getStopY() {
        return this.stopy;
    }

    public int getPostXSpacing() {
        return this.postXSpacing;
    }

    public int getPostYSpacing() {
        return this.postYSpacing;
    }

    public void setXAxisValue(double x) {
        this.xAxisValue = x;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setYAxisValue(double y) {
        this.yAxisValue = y;
    }

    public double getYAxisValue() {
        return this.yAxisValue;
    }

    public void setPreXSpacing(int x) {
        this.preXSpacing = x;
    }

    public int getPreXSpacing() {
        return this.preXSpacing;
    }

    public void setPreYSpacing(int y) {
        this.preYSpacing = y;
    }

    public int getPreYSpacing() {
        return this.preYSpacing;
    }

    public void setPostYSpacing(int y) {
        this.postYSpacing = y;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String xlabel) {
        this.xLabel = xlabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String ylabel) {
        this.yLabel = ylabel;
    }

    public void setTickFont(String fontName, int fontStyle, int fontSize) {
        this.tickFont = new Font(fontName, fontStyle, fontSize);
        this.tickFontWidth = (int)(0.6 * (double)fontSize);
        this.tickFontHeight = fontSize;
    }

    public void setLabelFont(String fontName, int fontStyle, int fontSize) {
        this.labelFont = new Font(fontName, fontStyle, fontSize);
        this.labelFontWidth = (int)(0.6 * (double)fontSize);
        this.labelFontHeight = fontSize;
    }

    public void setTitleFont(String fontName, int fontStyle, int fontSize) {
        this.titleFont = new Font(fontName, fontStyle, fontSize);
        this.titleFontWidth = (int)(0.6 * (double)fontSize);
        this.titleFontHeight = fontSize;
    }

    public void setPointSize(int pointSize) {
        this.pointSize = pointSize;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void showAll() {
        this.canvas.repaint();
    }

    public void clearAll(Graphics2D g) {
        this.canvas.fillRect(g, this.startx, this.starty, this.getSize().width, this.getSize().height, Color.white);
    }

    public void drawSystem(Graphics2D g, int systemStyle) {
        switch (systemStyle) {
            case 1000: {
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                break;
            }
            case 1001: {
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                g.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                g.drawLine((this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.stopy - this.postYSpacing, (this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.starty + this.preYSpacing);
                break;
            }
            case 1100: {
                this.drawLine(g, new GraphPoint(this.graphstartx, this.xAxisValue), new GraphPoint(this.graphstopx, this.xAxisValue), Color.black);
                this.drawLine(g, new GraphPoint(this.yAxisValue, this.graphstarty), new GraphPoint(this.yAxisValue, this.graphstopy), Color.black);
                break;
            }
        }
    }

    protected double getXScale() {
        return (double)(this.canvas.getSize().width - this.preXSpacing - this.postXSpacing) / (this.graphstopx - this.graphstartx);
    }

    protected double getYScale() {
        return (double)(this.canvas.getSize().height - this.preYSpacing - this.postYSpacing) / (this.graphstopy - this.graphstarty);
    }

    protected int convertX(double x) {
        return (int)((x - this.graphstartx) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double y) {
        return (int)((this.graphstopy - y) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawTick(Graphics2D g, GraphTick e) {
        if (e.getOrientation() == 0) {
            if (e.getLabel() != "") {
                this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
            } else {
                this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
            }
        } else if (e.getOrientation() == 1) {
            if (e.getLabel() != "") {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
            } else {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color) {
        if (!(x < this.graphstartx) && !(x > this.graphstopx) && length <= this.postYSpacing) {
            switch (alignment) {
                case 0: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue) - length / 2, this.convertX(x), this.convertY(this.xAxisValue) + length / 2, color);
                    break;
                }
                case 1: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) - length, color);
                    break;
                }
                case 5: {
                    this.canvas.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) + length, color);
                }
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawVerticalTick(g, x, length, alignment, color);
        g.rotate(-1.5707963267948966);
        this.canvas.drawString(g, label, -this.canvas.getSize().height + this.postYSpacing - label.length() * this.tickFontWidth - length, this.convertX(x) + this.tickFontHeight / 2, tickColor, this.tickFont);
        g.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color) {
        if (!(y < this.graphstarty) && !(y > this.graphstopy) && length <= this.preXSpacing) {
            switch (alignment) {
                case 0: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue) - length / 2, this.convertY(y), this.convertX(this.yAxisValue) + length / 2, this.convertY(y), color);
                    break;
                }
                case 3: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) + length, this.convertY(y), color);
                    break;
                }
                case 7: {
                    this.canvas.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) - length, this.convertY(y), color);
                }
            }
        }
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawHorizontalTick(g, y, length, alignment, color);
        this.canvas.drawString(g, label, this.startx + this.preXSpacing - length - label.length() * this.tickFontWidth, this.convertY(y) + this.tickFontHeight / 2, tickColor, this.tickFont);
    }

    public void enforceGraphBounds(Graphics2D g) {
        this.enforceGraphBounds(g, Color.white);
    }

    public void enforceGraphBounds(Graphics2D g, Color color) {
        int height = this.canvas.getSize().height;
        int width = this.canvas.getSize().width;
        this.canvas.fillRect(g, 0, 0, width, this.preYSpacing, color);
        this.canvas.fillRect(g, 0, height - this.postYSpacing, width, this.postYSpacing, color);
        this.canvas.fillRect(g, 0, 0, this.preXSpacing, height, color);
        this.canvas.fillRect(g, width - this.postXSpacing, 0, this.postXSpacing, height, color);
    }

    public void drawTitle(Graphics2D g, String title, Color titleColor) {
        if (this.subTitle == null) {
            this.canvas.drawString(g, title, this.canvas.getSize().width / 2 - title.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, titleColor, this.titleFont);
        } else {
            this.canvas.drawString(g, title, this.canvas.getSize().width / 2 - title.length() * this.titleFontWidth / 2, (int)((double)this.titleFontHeight * 1.5), titleColor, this.titleFont);
            this.canvas.drawString(g, this.subTitle, this.canvas.getSize().width / 2 - this.subTitle.length() * this.titleFontWidth / 2, this.titleFontHeight * 3, titleColor, this.titleFont);
        }
    }

    public void drawXLabel(Graphics2D g, String label, Color labelColor) {
        this.canvas.drawString(g, label, this.canvas.getSize().width / 2 - label.length() * this.labelFontWidth / 2, this.convertY(this.graphstarty) + this.postYSpacing - this.labelFontHeight, labelColor, this.labelFont);
    }

    public void drawYLabel(Graphics2D g, String label, Color labelColor) {
        g.rotate(-1.5707963267948966);
        this.canvas.drawString(g, label, this.startx - this.postYSpacing + this.preXSpacing - this.canvas.getSize().height / 2 - label.length() * this.labelFontWidth / 2, this.labelFontHeight, labelColor, this.labelFont);
        g.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D g, GraphPoint graphPoint) {
        this.drawPointAt(g, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D g, double x, double y, Color pointColor, int pointSize) {
        if (!(x < this.graphstartx || x > this.graphstopx || y < this.graphstarty || y > this.graphstopy)) {
            this.canvas.fillRect(g, this.convertX(x) - pointSize / 2, this.convertY(y) - pointSize / 2, pointSize, pointSize, pointColor);
        }
    }

    public void drawPoints(Graphics2D g, Vector graphPoints, int graphPointStyle) {
        GraphPoint graphPoint2 = null;
        switch (graphPointStyle) {
            case 3000: {
                for (int i = 0; i < graphPoints.size(); ++i) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    this.drawPoint(g, graphPoint);
                }
                break;
            }
            case 3001: {
                for (int i = 0; i < graphPoints.size(); ++i) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    if (i == 0) {
                        graphPoint2 = graphPoint;
                    }
                    this.drawLine(g, graphPoint2, graphPoint, Color.black);
                    this.drawPoint(g, graphPoint2);
                    this.drawPoint(g, graphPoint);
                    graphPoint2 = graphPoint;
                }
                break;
            }
        }
    }

    public void drawLine(Graphics2D g, GraphLine e) {
        if (!(e.getX1() < this.graphstartx || e.getX1() > this.graphstopx || e.getY1() < this.graphstarty || e.getY1() > this.graphstopy || e.getX2() < this.graphstartx || e.getX2() > this.graphstopx || e.getY2() < this.graphstarty || e.getY2() > this.graphstopy)) {
            this.canvas.drawLine(g, this.convertX(e.getX1()), this.convertY(e.getY1()), this.convertX(e.getX2()), this.convertY(e.getY2()), e.getColor());
        }
    }

    public void drawLine(Graphics2D g, GraphPoint graphPoint1, GraphPoint graphPoint2, Color lineColor) {
        this.canvas.drawLine(g, this.convertX(graphPoint1.getX()), this.convertY(graphPoint1.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), lineColor);
    }

    public void drawBar(Graphics2D g, GraphBar e) {
        if (e.getStyle() == 0) {
            this.drawVerticalHistogramBar(g, e.getLower(), e.getUpper(), e.getValue(), e.getColor(), e.getStyle());
        } else if (e.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D g, double low, double high, double value, Color barColor, int style) {
        if (!(low < this.graphstartx || low > this.graphstopx || high < this.graphstartx || high > this.graphstopx || value < this.graphstarty || value > this.graphstopy)) {
            if (style == 1) {
                this.canvas.drawRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()), (int)(value * this.getYScale()) - 1, barColor);
            } else if (style == 0) {
                this.canvas.fillRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()) + 1, (int)(value * this.getYScale()) + 1, barColor);
            }
        }
    }

    public void close() {
        if (this.hasFrame()) {
            this.frame.dispose();
        }
    }

    public void toggleReferenceLines() {
        this.referenceLinesOn = !this.referenceLinesOn;
    }

    public void setShowCoordinates(boolean showCoordinates) {
        this.showCoordinates = showCoordinates;
    }

    private class EventListener
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    Serializable {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GraphViewer.this.popup.setVisible(false);
            if (event.getActionCommand() == "Close") {
                GraphViewer.this.getFrame().dispose();
            } else if (event.getActionCommand() == "Set Boundaries") {
                BoundariesDialog bd = new BoundariesDialog(GraphViewer.this.getFrame(), GraphViewer.this.graphstartx, GraphViewer.this.graphstopx, GraphViewer.this.graphstarty, GraphViewer.this.graphstopy);
                bd.addActionInfoListener(new ActionInfoListener(){

                    @Override
                    public void actionInfoPerformed(ActionInfoEvent event) {
                        Hashtable hash = event.getHashtable();
                        GraphViewer.this.graphstartx = Double.parseDouble((String)hash.get("lowerx"));
                        GraphViewer.this.graphstopx = Double.parseDouble((String)hash.get("upperx"));
                        GraphViewer.this.graphstarty = Double.parseDouble((String)hash.get("lowery"));
                        GraphViewer.this.graphstopy = Double.parseDouble((String)hash.get("uppery"));
                        GraphViewer.this.setXAxisValue(GraphViewer.this.graphstarty);
                        GraphViewer.this.setYAxisValue(GraphViewer.this.graphstartx);
                        GraphViewer.this.repaint();
                    }
                });
                bd.show();
            } else if (event.getActionCommand() == "Reference Lines") {
                GraphViewer.this.referenceLinesOn = !GraphViewer.this.referenceLinesOn;
                GraphViewer.this.repaint();
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getModifiers() == 4) {
                GraphViewer.this.popup.show(event.getComponent(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            GraphViewer.this.setXOldEvent(-1);
            GraphViewer.this.setYOldEvent(-1);
            GraphViewer.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            GraphViewer.this.setXOldEvent(x);
            GraphViewer.this.setYOldEvent(y);
            GraphViewer.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }
    }
}

