/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import org.tigr.graph.Drawable;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphPointGroup;
import org.tigr.graph.GraphTick;

public class GraphCanvas
extends Drawable {
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    public static final int HISTOGRAM_BAR_OUTLINE = 2000;
    public static final int HISTOGRAM_BAR_SOLID = 2001;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    protected double graphStartX;
    protected double graphStopX;
    protected double graphStartY;
    protected double graphStopY;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected double xAxisValue;
    protected double yAxisValue;
    public boolean fixedHeight;
    public boolean fixedWidth;
    public int graphHeight;
    public int graphWidth;
    public boolean referenceLinesOn = true;
    public String title;
    public String xLabel;
    public String yLabel;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    protected Vector graphElements;

    public GraphCanvas() {
        this.initialize();
    }

    public GraphCanvas(int graphHeight, int graphWidth) {
        this.fixedHeight = true;
        this.fixedWidth = true;
        this.graphHeight = graphHeight;
        this.graphWidth = graphWidth;
        this.initialize();
    }

    public void initialize() {
        this.graphElements = new Vector();
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.setTickFont("monospaced", 0, 10);
        this.setLabelFont("monospaced", 0, 12);
        this.setTitleFont("monospaced", 0, 16);
    }

    @Override
    public void controlPaint(Graphics g1D) {
        Graphics2D g = (Graphics2D)g1D;
        this.drawGraph(g);
    }

    public void setTickFont(String fontName, int fontStyle, int fontSize) {
        this.tickFont = new Font(fontName, fontStyle, fontSize);
        this.tickFontWidth = (int)(0.6 * (double)fontSize);
        this.tickFontHeight = fontSize;
    }

    public void setLabelFont(String fontName, int fontStyle, int fontSize) {
        this.labelFont = new Font(fontName, fontStyle, fontSize);
        this.labelFontWidth = (int)(0.6 * (double)fontSize);
        this.labelFontHeight = fontSize;
    }

    public void setTitleFont(String fontName, int fontStyle, int fontSize) {
        this.titleFont = new Font(fontName, fontStyle, fontSize);
        this.titleFontWidth = (int)(0.6 * (double)fontSize);
        this.titleFontHeight = fontSize;
    }

    public void drawGraph(Graphics2D g) {
        this.drawSystem(g, 1100);
        for (int i = 0; i < this.graphElements.size(); ++i) {
            this.drawGraphElement(g, (GraphElement)this.graphElements.elementAt(i));
        }
        if (this.referenceLinesOn) {
            // empty if block
        }
        this.drawXLabel(g, this.xLabel, Color.black);
        this.drawYLabel(g, this.yLabel, Color.black);
        this.drawTitle(g, this.title, Color.black);
    }

    public void drawGraphElement(Graphics2D g, GraphElement e) {
        if (e instanceof GraphPoint) {
            this.drawPoint(g, (GraphPoint)e);
        } else if (e instanceof GraphBar) {
            this.drawBar(g, (GraphBar)e);
        } else if (e instanceof GraphTick) {
            this.drawTick(g, (GraphTick)e);
        } else if (e instanceof GraphLine) {
            this.drawLine(g, (GraphLine)e);
        } else if (e instanceof GraphPointGroup) {
            this.drawPointGroup(g, (GraphPointGroup)e);
        }
    }

    public void drawReferenceLines(Graphics2D g, int x, int y) {
        if (x <= this.convertX(this.graphStopX) && x >= this.convertX(this.graphStartX)) {
            g.setColor(Color.magenta);
            g.drawLine(x, this.convertY(this.graphStartY), x, this.convertY(this.graphStopY));
        }
        if (y >= this.convertY(this.graphStopY) && y <= this.convertY(this.graphStartY)) {
            g.setColor(Color.magenta);
            g.drawLine(this.convertX(this.graphStartX), y, this.convertX(this.graphStopX), y);
        }
    }

    public void addGraphElement(GraphElement e) {
        this.graphElements.addElement(e);
    }

    public void removeAllGraphElements() {
        this.graphElements = new Vector();
    }

    public void clearAll(Graphics2D g) {
        this.fillRect(g, 0, 0, this.getSize().width, this.getSize().height, this.getBackground());
    }

    public void setGraphStartX(double graphStartX) {
        this.graphStartX = graphStartX;
    }

    public double getGraphStartX() {
        return this.graphStartX;
    }

    public void setGraphStartY(double graphStartY) {
        this.graphStartY = graphStartY;
    }

    public double getGraphStartY() {
        return this.graphStartY;
    }

    public void setGraphStopX(double graphStopX) {
        this.graphStopX = graphStopX;
    }

    public double getGraphStopX() {
        return this.graphStopX;
    }

    public void setGraphStopY(double graphStopY) {
        this.graphStopY = graphStopY;
    }

    public double getGraphStopY() {
        return this.graphStopY;
    }

    public void setGraphBounds(double graphStartX, double graphStopX, double graphStartY, double graphStopY) {
        this.graphStartX = graphStartX;
        this.graphStopX = graphStopX;
        this.graphStartY = graphStartY;
        this.graphStopY = graphStopY;
    }

    public void setPreXSpacing(int preXSpacing) {
        this.preXSpacing = preXSpacing;
    }

    public int getPreXSpacing() {
        return this.preXSpacing;
    }

    public void setPostXSpacing(int postXSpacing) {
        this.postXSpacing = postXSpacing;
    }

    public int getPostXSpacing() {
        return this.postXSpacing;
    }

    public void setPreYSpacing(int preYSpacing) {
        this.preYSpacing = preYSpacing;
    }

    public int getPreYSpacing() {
        return this.preYSpacing;
    }

    public void setPostYSpacing(int postYSpacing) {
        this.postYSpacing = postYSpacing;
    }

    public int getPostYSpacing() {
        return this.postYSpacing;
    }

    public void setGraphSpacing(int preXSpacing, int postXSpacing, int preYSpacing, int postYSpacing) {
        this.preXSpacing = preXSpacing;
        this.postXSpacing = postXSpacing;
        this.preYSpacing = preYSpacing;
        this.postYSpacing = postYSpacing;
    }

    public void setXAxisValue(double x) {
        this.xAxisValue = x;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setYAxisValue(double y) {
        this.yAxisValue = y;
    }

    public double getYAxisValue() {
        return this.yAxisValue;
    }

    public void drawSystem(Graphics2D g, int systemStyle) {
        switch (systemStyle) {
            case 1100: {
                this.drawLine(g, new GraphPoint(this.graphStartX, this.xAxisValue), new GraphPoint(this.graphStopX, this.xAxisValue), Color.black);
                this.drawLine(g, new GraphPoint(this.yAxisValue, this.graphStartY), new GraphPoint(this.yAxisValue, this.graphStopY), Color.black);
                break;
            }
            case 1000: {
                break;
            }
            case 1001: {
                break;
            }
        }
    }

    @Override
    public int getWidth() {
        if (this.fixedWidth) {
            return this.graphWidth;
        }
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        if (this.fixedHeight) {
            return this.graphHeight;
        }
        return this.getSize().height;
    }

    protected double getXScale() {
        return (double)(this.getWidth() - this.preXSpacing - this.postXSpacing) / (this.graphStopX - this.graphStartX);
    }

    protected double getYScale() {
        return (double)(this.getHeight() - this.preYSpacing - this.postYSpacing) / (this.graphStopY - this.graphStartY);
    }

    protected int convertX(double x) {
        return (int)((x - this.graphStartX) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double y) {
        return (int)((this.graphStopY - y) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawTick(Graphics2D g, GraphTick e) {
        if (e.getOrientation() == 0) {
            if (e.getLabel() != "") {
                this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
            } else {
                this.drawVerticalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
            }
        } else if (e.getOrientation() == 1) {
            if (e.getLabel() != "") {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor(), e.getLabel(), e.getLabelColor());
            } else {
                this.drawHorizontalTick(g, e.getLocation(), e.getHeight(), e.getAlignment(), e.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color) {
        if (x < this.graphStartX || x > this.graphStopX) {
            return;
        }
        switch (alignment) {
            case 0: {
                this.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue) - length / 2, this.convertX(x), this.convertY(this.xAxisValue) + length / 2, color);
                break;
            }
            case 1: {
                this.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) - length, color);
                break;
            }
            case 5: {
                this.drawLine(g, this.convertX(x), this.convertY(this.xAxisValue), this.convertX(x), this.convertY(this.xAxisValue) + length, color);
            }
        }
    }

    public void drawVerticalTick(Graphics2D g, double x, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawVerticalTick(g, x, length, alignment, color);
        g.rotate(-1.5707963267948966);
        this.drawString(g, label, -this.getHeight() + this.postYSpacing - label.length() * this.tickFontWidth - length, this.convertX(x) + this.tickFontHeight / 2, tickColor, this.tickFont);
        g.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color) {
        if (y < this.graphStartY || y > this.graphStopY) {
            return;
        }
        switch (alignment) {
            case 0: {
                this.drawLine(g, this.convertX(this.yAxisValue) - length / 2, this.convertY(y), this.convertX(this.yAxisValue) + length / 2, this.convertY(y), color);
                break;
            }
            case 3: {
                this.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) + length, this.convertY(y), color);
                break;
            }
            case 7: {
                this.drawLine(g, this.convertX(this.yAxisValue), this.convertY(y), this.convertX(this.yAxisValue) - length, this.convertY(y), color);
            }
        }
    }

    public void drawHorizontalTick(Graphics2D g, double y, int length, int alignment, Color color, String label, Color tickColor) {
        this.drawHorizontalTick(g, y, length, alignment, color);
        this.drawString(g, label, this.preXSpacing - length - label.length() * this.tickFontWidth, this.convertY(y) + this.tickFontHeight / 2, tickColor, this.tickFont);
    }

    public void drawTitle(Graphics2D g, String title, Color titleColor) {
        if (title == null) {
            return;
        }
        this.drawString(g, title, this.getWidth() / 2 - title.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, titleColor, this.titleFont);
    }

    public void drawXLabel(Graphics2D g, String label, Color labelColor) {
        if (label == null) {
            return;
        }
        this.drawString(g, label, this.getWidth() / 2 - label.length() * this.labelFontWidth / 2, this.convertY(this.graphStartY) + this.postYSpacing - this.labelFontHeight, labelColor, this.labelFont);
    }

    public void drawYLabel(Graphics2D g, String label, Color labelColor) {
        if (label == null) {
            return;
        }
        g.rotate(-1.5707963267948966);
        this.drawString(g, label, -this.postYSpacing + this.preXSpacing - this.getHeight() / 2 - label.length() * this.labelFontWidth / 2, this.labelFontHeight, labelColor, this.labelFont);
        g.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D g, GraphPoint graphPoint) {
        this.drawPointAt(g, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D g, double x, double y, Color pointColor, int pointSize) {
        if (x < this.graphStartX || x > this.graphStopX || y < this.graphStartY || y > this.graphStopY) {
            return;
        }
        this.fillRect(g, this.convertX(x) - pointSize / 2, this.convertY(y) - pointSize / 2, pointSize, pointSize, pointColor);
    }

    public void drawPoints(Graphics2D g, Vector graphPoints, int graphPointStyle) {
        GraphPoint graphPoint2 = null;
        switch (graphPointStyle) {
            case 3000: {
                for (int i = 0; i < graphPoints.size(); ++i) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    this.drawPoint(g, graphPoint);
                }
                break;
            }
            case 3001: {
                for (int i = 0; i < graphPoints.size(); ++i) {
                    GraphPoint graphPoint = (GraphPoint)graphPoints.elementAt(i);
                    if (i == 0) {
                        graphPoint2 = graphPoint;
                    }
                    this.drawLine(g, graphPoint2, graphPoint, Color.black);
                    this.drawPoint(g, graphPoint2);
                    this.drawPoint(g, graphPoint);
                    graphPoint2 = graphPoint;
                }
                break;
            }
        }
    }

    public void drawPointGroup(Graphics2D g, GraphPointGroup gpg) {
        double[] x = gpg.getX();
        double[] y = gpg.getY();
        Color pointColor = gpg.getColor();
        int pointSize = gpg.getPointSize();
        for (int i = 0; i < Math.min(x.length, y.length); ++i) {
            this.drawPointAt(g, x[i], y[i], pointColor, pointSize);
        }
    }

    public void drawLine(Graphics2D g, GraphLine e) {
        this.drawLine(g, this.convertX(e.getX1()), this.convertY(e.getY1()), this.convertX(e.getX2()), this.convertY(e.getY2()), e.getColor());
    }

    public void drawLine(Graphics2D g, GraphPoint graphPoint1, GraphPoint graphPoint2, Color lineColor) {
        this.drawLine(g, this.convertX(graphPoint1.getX()), this.convertY(graphPoint1.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), lineColor);
    }

    public void drawBar(Graphics2D g, GraphBar e) {
        if (e.getStyle() == 0) {
            this.drawVerticalHistogramBar(g, e.getLower(), e.getUpper(), e.getValue(), e.getColor(), e.getStyle());
        } else if (e.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D g, double low, double high, double value, Color barColor, int style) {
        if (low < this.graphStartX || low > this.graphStopX || high < this.graphStartX || high > this.graphStopX) {
            return;
        }
        if (value < this.graphStartY || value > this.graphStopY) {
            return;
        }
        if (style == 1) {
            this.drawRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()), (int)(value * this.getYScale()) - 1, barColor);
        } else if (style == 0) {
            this.fillRect(g, this.convertX(low), this.convertY(value), (int)((high - low) * this.getXScale()) + 1, (int)(value * this.getYScale()) + 1, barColor);
        }
    }
}

